<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package blogar
 */

/**
 * Enqueue scripts and styles.
 */
if (!function_exists('blogar_content_estimated_reading_time')) {
    /**
     * Function that estimates reading time for a given $content.
     * @param string $content Content to calculate read time for.
     * @paramint $wpm Estimated words per minute of reader.
     * @returns int $time Esimated reading time.
     */
    function blogar_content_estimated_reading_time($content = '', $wpm = 200)
    {
        $clean_content = strip_shortcodes($content);
        $clean_content = strip_tags($clean_content);
        $word_count = str_word_count($clean_content);
        $time = ceil($word_count / $wpm);
        $output = $time . esc_attr__(' min read', 'blogar');
        return $output;
    }
}


/**
 * Escapeing
 */
if ( !function_exists('awescapeing') ) {
    function awescapeing($html){
        return $html;
    }
}

/**
 *  Convert Get Theme Option global to function
 */
if(!function_exists('axil_get_opt')){
    function axil_get_opt(){
        global $axil_option;
        return $axil_option;
    }
}
/**
 * Get terms
 */
function axil_get_terms_gb( $term_type = null, $hide_empty = false ) {
    if(!isset( $term_type )){
        return;
    }
    $axil_custom_terms = array();
    $terms = get_terms( $term_type, array( 'hide_empty' => $hide_empty ) );
    array_push( $axil_custom_terms, esc_html__( '--- Select ---', 'blogar' ) );
    if ( is_array( $terms ) && ! empty( $terms ) ) {
        foreach ( $terms as $single_term ) {
            if ( is_object( $single_term ) && isset( $single_term->name, $single_term->slug ) ) {
                $axil_custom_terms[ $single_term->slug ] = $single_term->name;
            }
        }
    }
    return $axil_custom_terms;
}

/**
 * Blog Pagination
 */
if(!function_exists('axil_blog_pagination')){
    function axil_blog_pagination(){
        GLOBAL $wp_query;
        if ($wp_query->post_count < $wp_query->found_posts) {
            ?>
            <div class="post-pagination"> <?php
                the_posts_pagination(array(
                    'prev_text'          => '<i class="fal fa-arrow-left"></i>',
                    'next_text'          => '<i class="fal fa-arrow-right"></i>',
                    'type'               => 'list',
                    'show_all'  	     => false,
                    'end_size'           => 1,
                    'mid_size'           => 8,
                )); ?>
            </div>
            <?php
        }
    }
}

/**
 * Short Title
 */
if (!function_exists('axil_short_title')){
    function axil_short_title($title, $length = 30) {
        if (strlen($title) > $length) {
            return substr($title, 0, $length) . ' ...';
        }else {
            return $title;
        }
    }
}


/**
 * Get ACF data conditionally
 */
if( !function_exists('axil_get_acf_data') ){
    function axil_get_acf_data($fields){
        return (class_exists('ACF') && get_field_object($fields)) ? get_field($fields) : false;
    }

}


/**
 * @param $url
 * @return string
 */
if ( !function_exists('axil_getEmbedUrl') ){
    function axil_getEmbedUrl($url) {
        // function for generating an embed link
        $finalUrl = '';

        if (strpos($url, 'facebook.com/') !== false) {
            // Facebook Video
            $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';

        } else if(strpos($url, 'vimeo.com/') !== false) {
            // Vimeo video
            $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
            if (strpos($videoId, '&') !== false){
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://player.vimeo.com/video/'.$videoId;

        } else if (strpos($url, 'youtube.com/') !== false) {
            // Youtube video
            $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
            if (strpos($videoId, '&') !== false){
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.youtube.com/embed/'.$videoId;

        } else if(strpos($url, 'youtu.be/') !== false) {
            // Youtube  video
            $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
            if (strpos($videoId, '&') !== false) {
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.youtube.com/embed/'.$videoId;

        } else if (strpos($url, 'dailymotion.com/') !== false) {
            // Dailymotion Video
            $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
            if (strpos($videoId, '&') !== false) {
                $videoId = explode("&",$videoId)[0];
            }
            $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;

        } else{
            $finalUrl.=$url;
        }

        return $finalUrl;
    }
}


/**
 * @param $prefix
 * @param $title
 * @param string $subtitle
 * @return array
 */
function axil_redux_add_fields($prefix, $title, $subtitle = '')
{
    return array(
        array(
            'id' => $prefix . '_sec',
            'type' => 'section',
            'title' => $title,
            'subtitle' => $subtitle,
            'indent' => true,
        ),
        array(
            'id' => $prefix . '_activate',
            'type' => 'switch',
            'title' => esc_html__('Activate Ad', 'blogar'),
            'on' => esc_html__('Enabled', 'blogar'),
            'off' => esc_html__('Disabled', 'blogar'),
            'default' => false,
        ),
        array(
            'id' => $prefix . '_type',
            'type' => 'button_set',
            'title' => esc_html__('Ad Type', 'blogar'),
            'options' => array(
                'image' => esc_html__('Image Link', 'blogar'),
                'code' => esc_html__('Custom Code', 'blogar'),
            ),
            'default' => 'image',
            'required' => array($prefix . '_activate', 'equals', true)
        ),
        array(
            'id' => $prefix . '_image',
            'type' => 'media',
            'title' => esc_html__('Image', 'blogar'),
            'default' => '',
            'required' => array($prefix . '_type', 'equals', 'image')
        ),
        array(
            'id' => $prefix . '_url',
            'type' => 'text',
            'title' => esc_html__('Link', 'blogar'),
            'default' => '',
            'required' => array($prefix . '_type', 'equals', 'image')
        ),

        array(
            'id' => $prefix . '_link_type',
            'type' => 'button_set',
            'title' => esc_html__('Open Advertisement Tab', 'blogar'),
            'options' => array(
                'blank' => esc_html__('Open in new tab', 'blogar'),
                'same' => esc_html__('Open in Same tab', 'blogar'),
            ),
            'required' => array($prefix . '_type', 'equals', 'image'),
            'default' => 'blank',

        ),
        array(
            'id' => $prefix . '_code',
            'type' => 'textarea',
            'title' => esc_html__('Custom Code', 'blogar'),
            'default' => '',
            'subtitle' => esc_html__('Supports: Shortcode, Adsense, Text, HTML, Scripts', 'blogar'),
            'required' => array($prefix . '_type', 'equals', 'code')
        ),
    );
}

/***
 * pt_like_it
 */
add_action( 'wp_ajax_nopriv_pt_like_it', 'pt_like_it' );
add_action( 'wp_ajax_pt_like_it', 'pt_like_it' );
if(!function_exists('pt_like_it')){
    function pt_like_it() {

        if ( ! wp_verify_nonce( $_REQUEST['nonce'], 'pt_like_it_nonce' ) || ! isset( $_REQUEST['nonce'] ) ) {
            exit( "No naughty business please" );
        }

        $likes = get_post_meta( $_REQUEST['post_id'], '_pt_likes', true );
        $likes = ( empty( $likes ) ) ? 0 : $likes;
        $new_likes = $likes + 1;

        update_post_meta( $_REQUEST['post_id'], '_pt_likes', $new_likes );

        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            echo esc_html($new_likes);
            die();
        }
        else {
            wp_redirect( get_permalink( $_REQUEST['post_id'] ) );
            exit();
        }
    }
}



/**
 * @param $tags
 * @param $context
 * @return array
 */
if (! function_exists('blogar_kses_allowed_html')){
    function blogar_kses_allowed_html($tags, $context) {
        switch($context) {
            case 'social':
                $tags = array(
                    'a' => array('href' => array()),
                    'b' => array()
                );
                return $tags;
            case 'allow_link':
                $tags = array(
                    'a' => array(
                        'class' => array(),
                        'href' => array(),
                        'rel' => array(),
                        'title' => array(),
                        'target' => array(),
                    ),
                    'b' => array()
                );
                return $tags;
            case 'allow_title':
                $tags = array(
                    'a' => array(
                        'class' => array(),
                        'href' => array(),
                        'rel' => array(),
                        'title' => array(),
                        'target' => array(),
                    ),
                    'span' => array(
                        'class' => array(),
                        'style' => array(),
                    ),
                    'b' => array()
                );
                return $tags;

            case 'alltext_allow':
                $tags = array(
                    'a' => array(
                        'class' => array(),
                        'href' => array(),
                        'rel' => array(),
                        'title' => array(),
                        'target' => array(),
                    ),
                    'abbr' => array(
                        'title' => array(),
                    ),
                    'b' => array(),
                    'br' => array(),
                    'blockquote' => array(
                        'cite' => array(),
                    ),
                    'cite' => array(
                        'title' => array(),
                    ),
                    'code' => array(),
                    'del' => array(
                        'datetime' => array(),
                        'title' => array(),
                    ),
                    'dd' => array(),
                    'div' => array(
                        'class' => array(),
                        'title' => array(),
                        'style' => array(),
                        'id' => array(),
                    ),
                    'dl' => array(),
                    'dt' => array(),
                    'em' => array(),
                    'h1' => array(),
                    'h2' => array(),
                    'h3' => array(),
                    'h4' => array(),
                    'h5' => array(),
                    'h6' => array(),
                    'i' => array(
                        'class' => array(),
                    ),
                    'img' => array(
                        'alt' => array(),
                        'class' => array(),
                        'height' => array(),
                        'src' => array(),
                        'srcset' => array(),
                        'width' => array(),
                    ),
                    'li' => array(
                        'class' => array(),
                    ),
                    'ol' => array(
                        'class' => array(),
                    ),
                    'p' => array(
                        'class' => array(),
                    ),
                    'q' => array(
                        'cite' => array(),
                        'title' => array(),
                    ),
                    'span' => array(
                        'class' => array(),
                        'title' => array(),
                        'style' => array(),
                    ),
                    'strike' => array(),
                    'strong' => array(),
                    'ul' => array(
                        'class' => array(),
                    ),
                );
                return $tags;
            default:
                return $tags;
        }
    }
    add_filter( 'wp_kses_allowed_html', 'blogar_kses_allowed_html', 10, 2);
}

