<?php
/**
 * The template to display Admin notices
 *
 * @package FORM
 * @since FORM 1.0.64
 */

$form_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$form_skins_args = get_query_var( 'form_skins_notice_args' );
?>
<div class="form_admin_notice form_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$form_theme_img = form_get_file_url( 'screenshot.jpg' );
	if ( '' != $form_theme_img ) {
		?>
		<div class="form_notice_image"><img src="<?php echo esc_url( $form_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'form' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="form_notice_title">
		<?php esc_html_e( 'New skins are available', 'form' ); ?>
	</h3>
	<?php

	// Description
	$form_total      = $form_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$form_skins_msg  = $form_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $form_total, 'form' ), $form_total ) . '</strong>'
							: '';
	$form_total      = $form_skins_args['free'];
	$form_skins_msg .= $form_total > 0
							? ( ! empty( $form_skins_msg ) ? ' ' . esc_html__( 'and', 'form' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $form_total, 'form' ), $form_total ) . '</strong>'
							: '';
	$form_total      = $form_skins_args['pay'];
	$form_skins_msg .= $form_skins_args['pay'] > 0
							? ( ! empty( $form_skins_msg ) ? ' ' . esc_html__( 'and', 'form' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $form_total, 'form' ), $form_total ) . '</strong>'
							: '';
	?>
	<div class="form_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'form' ), $form_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="form_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $form_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			esc_html_e( 'Go to Skins manager', 'form' );
			?>
		</a>
		<?php
		// Dismiss notice for 7 days
		?>
		<a href="#" role="button" class="button button-secondary form_notice_button_dismiss" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Dismiss', 'form' );
			?>
		</a>
		<?php
		// Hide notice forever
		?>
		<a href="#" role="button" class="button button-secondary form_notice_button_hide" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Never show again', 'form' );
			?>
		</a>
	</div>
</div>
