<?php
/**
 * The "Style 2" template to display the post header of the single post or attachment:
 * featured image and title placed in the post header
 *
 * @package FORM
 * @since FORM 1.75.0
 */

if ( apply_filters( 'form_filter_single_post_header', form_is_singular( 'post' ) || form_is_singular( 'attachment' ) ) ) {
	$form_post_format = str_replace( 'post-format-', '', get_post_format() );

	// Featured image
	ob_start();
	form_show_post_featured_image( array(
		'thumb_bg'  => true,
	) );
	$form_post_header = ob_get_contents();
	ob_end_clean();

	$form_with_featured_image = form_is_with_featured_image( $form_post_header );

	// Post title and meta
	ob_start();
	form_show_post_title_and_meta( array(
										'content_wrap'  => true,
										'share_type'    => 'list',
										'show_labels'   => true,
										'author_avatar' => false,
										'add_spaces'    => false,
										'cat_sep' 	    => false,
										)
									);
	$form_post_header .= ob_get_contents();
	ob_end_clean();

	if ( strpos( $form_post_header, 'post_featured' ) !== false
		|| strpos( $form_post_header, 'post_title' ) !== false
		|| strpos( $form_post_header, 'post_meta' ) !== false
	) {
		?>
		<div class="post_header_wrap post_header_wrap_in_header post_header_wrap_style_<?php
			echo esc_attr( form_get_theme_option( 'single_style' ) );
			if ( $form_with_featured_image ) {
				echo ' with_featured_image';
			}
		?>">
			<?php
			do_action( 'form_action_before_post_header' );
			form_show_layout( $form_post_header );
			do_action( 'form_action_after_post_header' );
			?>
		</div>
		<?php
	}
}
