<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package FORM
 * @since FORM 1.0
 */

// Page (category, tag, archive, author) title

if ( form_need_page_title() ) {
	form_sc_layouts_showed( 'title', true );
	?>
	<div class="top_panel_title sc_layouts_row">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Blog/Page title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$form_blog_title           = form_get_blog_title();
							$form_blog_title_text      = '';
							$form_blog_title_class     = '';
							$form_blog_title_link      = '';
							$form_blog_title_link_text = '';
							if ( is_array( $form_blog_title ) ) {
								$form_blog_title_text      = $form_blog_title['text'];
								$form_blog_title_class     = ! empty( $form_blog_title['class'] ) ? ' ' . $form_blog_title['class'] : '';
								$form_blog_title_link      = ! empty( $form_blog_title['link'] ) ? $form_blog_title['link'] : '';
								$form_blog_title_link_text = ! empty( $form_blog_title['link_text'] ) ? $form_blog_title['link_text'] : '';
							} else {
								$form_blog_title_text = $form_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $form_blog_title_class ); ?>"<?php
								if ( form_is_on( form_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$form_top_icon = form_get_term_image_small();
								if ( ! empty( $form_top_icon ) ) {
									$form_attr = form_getimagesize( $form_top_icon );
									?>
									<img src="<?php echo esc_url( $form_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'form' ); ?>"
										<?php
										if ( ! empty( $form_attr[3] ) ) {
											form_show_layout( $form_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $form_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $form_blog_title_link ) && ! empty( $form_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $form_blog_title_link ); ?>" class="theme_button sc_layouts_title_link"><?php echo esc_html( $form_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'form_action_breadcrumbs' );
						$form_breadcrumbs = ob_get_contents();
						ob_end_clean();
						form_show_layout( $form_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
