<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package FORM
 * @since FORM 1.0
 */

$form_args = get_query_var( 'form_logo_args' );

// Site logo
$form_logo_type   = isset( $form_args['type'] ) ? $form_args['type'] : '';
$form_logo_image  = form_get_logo_image( $form_logo_type );
$form_logo_text   = form_is_on( form_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$form_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $form_logo_image['logo'] ) || ! empty( $form_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $form_logo_image['logo'] ) ) {
			if ( empty( $form_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $form_logo_image['logo'] ) && (int) $form_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$form_attr = form_getimagesize( $form_logo_image['logo'] );
				echo '<img src="' . esc_url( $form_logo_image['logo'] ) . '"'
						. ( ! empty( $form_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $form_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $form_logo_text ) . '"'
						. ( ! empty( $form_attr[3] ) ? ' ' . wp_kses_data( $form_attr[3] ) : '' )
						. '>';
			}
		} else {
			form_show_layout( form_prepare_macros( $form_logo_text ), '<span class="logo_text">', '</span>' );
			form_show_layout( form_prepare_macros( $form_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
