<?php
/**
 * The template to display default site header
 *
 * @package FORM
 * @since FORM 1.0
 */

$form_header_css   = '';
$form_header_image = get_header_image();
$form_header_video = form_get_header_video();
if ( ! empty( $form_header_image ) && form_trx_addons_featured_image_override( form_is_singular() || form_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$form_header_image = form_get_current_mode_image( $form_header_image );
}
?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $form_header_image ) || ! empty( $form_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $form_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $form_header_image ) {
		echo ' ' . esc_attr( form_add_inline_css_class( 'background-image: url(' . esc_url( $form_header_image ) . ');' ) );
	}
	if ( form_is_singular() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $form_header_video ) ) {
		get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/header-navi' ) );

	// Page title and breadcrumbs area
	if ( ! form_is_single() ) {
		get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/header-title' ) );
	}
	?>
</header>
