<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package FORM
 * @since FORM 1.0.06
 */

$form_header_css   = '';
$form_header_image = get_header_image();
if ( ! empty( $form_header_image ) && form_trx_addons_featured_image_override( form_is_singular() || form_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$form_header_image = form_get_current_mode_image( $form_header_image );
}

$form_header_id = form_get_custom_header_id();
$form_header_meta = form_get_custom_layout_meta( $form_header_id );
if ( ! empty( $form_header_meta['margin'] ) ) {
	form_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( form_prepare_css_value( $form_header_meta['margin'] ) ) ) );
	form_storage_set( 'custom_header_margin', form_prepare_css_value( $form_header_meta['margin'] ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $form_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $form_header_id ) ) ); ?>
				<?php
				echo ! empty( $form_header_image )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $form_header_image ) {
					echo ' ' . esc_attr( form_add_inline_css_class( 'background-image: url(' . esc_url( $form_header_image ) . ');' ) );
				}
				if ( form_is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				?>
">
	<?php

	// Custom header's layout
	do_action( 'form_action_show_layout', $form_header_id );

	?>
</header>
