<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package FORM
 * @since FORM 1.0.10
 */

// Footer sidebar
$form_footer_name    = form_get_theme_option( 'footer_widgets' );
$form_footer_present = ! form_is_off( $form_footer_name ) && is_active_sidebar( $form_footer_name );
if ( $form_footer_present ) {
	form_storage_set( 'current_sidebar', 'footer' );
	ob_start();
	if ( is_active_sidebar( $form_footer_name ) ) {
		dynamic_sidebar( $form_footer_name );
	}
	$form_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $form_out ) ) {
		$form_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $form_out );
		$form_need_columns = true;   //or check: strpos($form_out, 'columns_wrap')===false;
		if ( $form_need_columns ) {
			$form_columns = max( 0, (int) form_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $form_columns ) {
				$form_columns = min( 4, max( 1, form_tags_count( $form_out, 'aside' ) ) );
			}
			if ( $form_columns > 1 ) {
				$form_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $form_columns ) . ' widget', $form_out );
			} else {
				$form_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area sc_layouts_row">
			<?php do_action( 'form_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<div class="content_wrap">
					<?php
					if ( $form_need_columns ) {
						?>
						<div class="columns_wrap">
						<?php
					}
					do_action( 'form_action_before_sidebar', 'footer' );
					form_show_layout( $form_out );
					do_action( 'form_action_after_sidebar', 'footer' );
					if ( $form_need_columns ) {
						?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<?php do_action( 'form_action_after_sidebar_wrap', 'footer' ); ?>
		</div>
		<?php
	}
}
