<?php
/**
 * The template to display default site footer
 *
 * @package FORM
 * @since FORM 1.0.10
 */

$form_footer_id = form_get_custom_footer_id();
$form_footer_meta = form_get_custom_layout_meta( $form_footer_id );
if ( ! empty( $form_footer_meta['margin'] ) ) {
	form_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( form_prepare_css_value( $form_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $form_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $form_footer_id ) ) ); ?>">
	<?php
	// Custom footer's layout
	do_action( 'form_action_show_layout', $form_footer_id );
	?>
</footer>