<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package FORM
 * @since FORM 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
				<?php
					$form_copyright = form_get_theme_option( 'copyright' );
					if ( ! empty( $form_copyright ) ) {
						// Replace {{Y}} or {Y} with the current year
						$form_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $form_copyright );
						// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
						$form_copyright = form_prepare_macros( $form_copyright );
						// Display copyright
						echo wp_kses( nl2br( $form_copyright ), 'form_kses_content' );
					}
				?>
			</div>
		</div>
	</div>
</div>