<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FORM
 * @since FORM 1.0
 */

$form_template_args = get_query_var( 'form_template_args' );

if ( is_array( $form_template_args ) ) {
	$form_columns       = empty( $form_template_args['columns'] ) ? 1 : max( 1, $form_template_args['columns'] );
	$form_blog_style    = array( $form_template_args['type'], $form_columns );
	$form_columns_class = form_get_column_class( 1, $form_columns, ! empty( $form_template_args['columns_tablet']) ? $form_template_args['columns_tablet'] : '', ! empty($form_template_args['columns_mobile']) ? $form_template_args['columns_mobile'] : '' );
} else {
	$form_template_args = array();
	$form_blog_style    = explode( '_', form_get_theme_option( 'blog_style' ) );
	$form_columns       = empty( $form_blog_style[1] ) ? 1 : max( 1, $form_blog_style[1] );
	$form_columns_class = form_get_column_class( 1, $form_columns );
}
$form_expanded   = ! form_sidebar_present() && form_get_theme_option( 'expand_content' ) == 'expand';

$form_post_format = get_post_format();
$form_post_format = empty( $form_post_format ) ? 'standard' : str_replace( 'post-format-', '', $form_post_format );

?><div class="<?php
	if ( ! empty( $form_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( form_is_blog_style_use_masonry( $form_blog_style[0] )
			? 'masonry_item masonry_item-1_' . esc_attr( $form_columns )
			: esc_attr( $form_columns_class )
			);
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $form_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $form_columns )
				. ' post_layout_' . esc_attr( $form_blog_style[0] )
				. ' post_layout_' . esc_attr( $form_blog_style[0] ) . '_' . esc_attr( $form_columns )
	);
	form_add_blog_animation( $form_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$form_hover      = ! empty( $form_template_args['hover'] ) && ! form_is_inherit( $form_template_args['hover'] )
							? $form_template_args['hover']
							: form_get_theme_option( 'image_hover' );

	$form_components = ! empty( $form_template_args['meta_parts'] )
							? ( is_array( $form_template_args['meta_parts'] )
								? $form_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $form_template_args['meta_parts'] ) )
								)
							: form_array_get_keys_by_value( form_get_theme_option( 'meta_parts' ) );

	form_show_post_featured( apply_filters( 'form_filter_args_featured',
		array(
			'thumb_size' => ! empty( $form_template_args['thumb_size'] )
								? $form_template_args['thumb_size']
								: form_get_thumb_size(
									strpos( form_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( $form_columns > 2 ? 'big' : 'full' )
										: ( $form_columns > 2
											? 'med'
											: ( $form_expanded || $form_columns == 1 ? 
												( $form_expanded && $form_columns == 1 ? 'huge' : 'big' ) 
												: 'med' 
												)
											)												
								),
			'hover'      => $form_hover,
			'meta_parts' => $form_components,
			'no_links'   => ! empty( $form_template_args['no_links'] ),
		),
		'content-classic',
		$form_template_args
	) );

	// Title and post meta
	$form_show_title = get_the_title() != '';
	$form_show_meta  = count( $form_components ) > 0;

	if ( $form_show_title ) {
		?><div class="post_header entry-header"><?php
			// Categories
			if ( apply_filters( 'form_filter_show_blog_categories', $form_show_meta && in_array( 'categories', $form_components ), array( 'categories' ), 'classic' ) ) {
				do_action( 'form_action_before_post_category' );
				?><div class="post_category"><?php
					form_show_post_meta( apply_filters(
														'form_filter_post_meta_args',
														array(
															'components' => 'categories',
															'seo'        => false,
															'echo'       => true,
															),
														'hover_' . $form_hover, 1
														)
										);
				?></div><?php
				$form_components = form_array_delete_by_value( $form_components, 'categories' );
				do_action( 'form_action_after_post_category' );
			}
			// Post title
			if ( apply_filters( 'form_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'form_action_before_post_title' );
				if ( empty( $form_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'form_action_after_post_title' );
			}
		?></div><?php
	}
	
	// Post meta
	if ( apply_filters( 'form_filter_show_blog_meta', $form_show_meta, $form_components, 'classic' ) ) {
		if ( count( $form_components ) > 0 ) {
			do_action( 'form_action_before_post_meta' );
			form_show_post_meta(
				apply_filters(
					'form_filter_post_meta_args', array(
						'components' => join( ',', $form_components ),
						'seo'        => false,
						'echo'       => true,
						'author_avatar' => false,
					), $form_blog_style[0], $form_columns
				)
			);
			do_action( 'form_action_after_post_meta' );
		}
	}

	// Post content
	ob_start();
	if ( apply_filters( 'form_filter_show_blog_excerpt', ( ! isset( $form_template_args['hide_excerpt'] ) || (int)$form_template_args['hide_excerpt'] == 0 ) && (int)form_get_theme_option( 'excerpt_length' ) > 0, 'classic' ) ) {
		form_show_post_content( $form_template_args, '<div class="post_content_inner">', '</div>' );
	}
	$form_content = ob_get_contents();
	ob_end_clean();

	form_show_layout( $form_content, '<div class="post_content entry-content">', '</div>' );

		
	// More button
	if ( apply_filters( 'form_filter_show_blog_readmore', ! $form_show_title || ! empty( $form_template_args['more_button'] ), 'classic' ) ) {
		if ( empty( $form_template_args['no_links'] ) ) {
			do_action( 'form_action_before_post_readmore' );
			form_show_post_more_link( $form_template_args, '<p>', '</p>' );
			do_action( 'form_action_after_post_readmore' );
		}
	}

	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
