<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package FORM
 * @since FORM 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( form_is_on( form_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( form_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( form_is_on( form_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$form_mult = form_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $form_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( form_is_on( form_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$form_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $form_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( form_is_on( form_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $form_author_description ), 'form_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$form_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );	// get_the_author_posts() return posts number by post_type from first post in the result
			if ( $form_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $form_posts_total, 'form' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $form_posts_total ) . '</span>'
								 		),
							'form_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'form' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'form_action_user_meta', 'author-page' );
			$form_socials = ob_get_contents();
			ob_end_clean();
			form_show_layout( $form_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'form' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
