<?php
/**
 * The template to display Admin notices
 *
 * @package FORM
 * @since FORM 1.0.1
 */

$form_theme_slug = get_template();
$form_theme_obj  = wp_get_theme( $form_theme_slug );
?>
<div class="form_admin_notice form_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$form_theme_img = form_get_file_url( 'screenshot.jpg' );
	if ( '' != $form_theme_img ) {
		?>
		<div class="form_notice_image"><img src="<?php echo esc_url( $form_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'form' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="form_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'form' ),
				$form_theme_obj->get( 'Name' ) . ( FORM_THEME_FREE ? ' ' . __( 'Free', 'form' ) : '' ),
				$form_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="form_notice_text">
		<p class="form_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $form_theme_obj->description ) );
			?>
		</p>
		<p class="form_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'form' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="form_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=form_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'form' );
			?>
		</a>
	</div>
</div>
