<?php
/**
 * Required plugins
 *
 * @package FORM
 * @since FORM 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'form_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'form_skin_required_plugins', -1 );
	function form_skin_required_plugins() {
		$form_theme_required_plugins_groups = array(
			'core'          => esc_html__( 'Core', 'form' ),
			'page_builders' => esc_html__( 'Page Builders', 'form' ),
			'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'form' ),
			'socials'       => esc_html__( 'Socials and Communities', 'form' ),
			'events'        => esc_html__( 'Events and Appointments', 'form' ),
			'content'       => esc_html__( 'Content', 'form' ),
			'other'         => esc_html__( 'Other', 'form' ),
		);
		$form_theme_required_plugins        = array(
			// Core
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'form' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'form' ),
				'required'    => true, // Check this plugin in the list on load Theme Dashboard
				'logo'        => 'trx_addons.png',
				'group'       => $form_theme_required_plugins_groups['core'],
			),
			// Page Builders
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'form' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'form' ),
				'required'    => false, // Leave this plugin unchecked on load Theme Dashboard
				'logo'        => 'elementor.png',
				'group'       => $form_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'form' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'form' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $form_theme_required_plugins_groups['page_builders'],
			),
			// Content
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'form' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'form' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $form_theme_required_plugins_groups['content'],
			),
			'metform'                    => array(
				'title'       => esc_html__( 'MetForm', 'form' ),
				'description' => esc_html__( "Contact Form, Survey, Quiz, & Custom Form Builder for Elementor", 'form' ),
				'required'    => false,
				'logo'        => 'metform.png',
				'group'       => $form_theme_required_plugins_groups['content'],
			),
			'woocommerce'                => array(
				'title'       => esc_html__( 'WooCommerce', 'form' ),
				'description' => esc_html__( "Connect the store to your website and start selling now", 'form' ),
				'required'    => false,
				'logo'        => 'woocommerce.png',
				'group'       => $form_theme_required_plugins_groups['ecommerce'],
			),
			// Other
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'form' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'form' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $form_theme_required_plugins_groups['other'],
			)
		);

		if ( FORM_THEME_FREE ) {
			unset( $form_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $form_theme_required_plugins['trx_updater'] );
		}

		// Add plugins list to the global storage
		form_storage_set( 'required_plugins', $form_theme_required_plugins );
	}
}
