<?php
/* WooCommerce skin-specific functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 3 - add/remove Theme Options elements

if ( ! function_exists( 'form_woocommerce_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'form_woocommerce_skin_theme_setup3', 3 );
	function form_woocommerce_skin_theme_setup3() {
		if ( form_exists_woocommerce() ) {
			// Panel 'Shop' with skin-specific options
			form_storage_set_array_after( 'options', 'shop_single', form_options_get_list_cpt_options_body( 'shop', esc_html__( 'Product', 'form' ), 'single' ) );
			// Hide 'shop_mode'
			form_storage_set_array2( 'options', 'shop_mode', 'type', 'hidden' );
			// Hide 'single_product_gallery_thumbs'
			form_storage_set_array2( 'options', 'single_product_gallery_thumbs', 'type', 'hidden' );
			// Hide 'shop_buttons'
			form_storage_set_array2( 'options', 'shop_hover', 'std', 'none' );
			form_storage_set_array2( 'options', 'shop_hover', 'type', 'hidden' );
			// Number of related products by default
			form_storage_set_array2( 'options', 'related_posts_shop', 'std', 4);
			form_storage_set_array2( 'options', 'related_columns_shop', 'std', 4);
		}
	}
}


// Remove\Register Action\filters
if ( ! function_exists( 'form_woocommerce_skin_woocommerce_remove_action' ) ) {
	add_action( 'init', 'form_woocommerce_skin_woocommerce_remove_action', 11 );
	function form_woocommerce_skin_woocommerce_remove_action() {
		if ( form_exists_woocommerce() ) {
			add_filter( 'form_filter_woocommerce_sale_flash', 'form_change_woocommerce_sale_flash', 10, 3 );
		}
	}
}


// Show/Hide product's tags before the title
if ( ! function_exists( 'form_woocommerce_skin_show_title' ) ) {
	add_filter( 'form_filter_show_woocommerce_title', 'form_woocommerce_skin_show_title' );
	function form_woocommerce_skin_show_title() {
		return false;
	}
}


// Add label "UP TO"
if ( ! function_exists( 'form_change_woocommerce_sale_flash' ) ) {
	function form_change_woocommerce_sale_flash($new_sale, $percent, $product) {
		if( 'variable' === $product->get_type() ){
			$new_sale = '<span class="onsale"><span class="onsale_up">'. esc_html__('Up to', 'form') .'</span> - '. esc_html( $percent ) . '%</span>';
		}
		return $new_sale;
	}
}

// Image width for thumbnails gallery
if ( ! function_exists( 'form_filter_woocommerce_skin_theme_support' ) ) {
	add_filter( 'form_filter_woocommerce_theme_support', 'form_filter_woocommerce_skin_theme_support' );
	function form_filter_woocommerce_skin_theme_support( $arr ) {
		$arr['gallery_thumbnail_image_width'] = 300;
		return $arr;
	}
}