<?php
// Add theme-specific CSS-animations
if ( ! function_exists( 'form_elm_add_theme_animations' ) ) {
	add_filter( 'elementor/controls/animations/additional_animations', 'form_elm_add_theme_animations' );
	function form_elm_add_theme_animations( $animations ) {
		/* To add a theme-specific animations to the list:
			1) Merge to the array 'animations': array(
													esc_html__( 'Theme Specific', 'form' ) => array(
														'ta_custom_1' => esc_html__( 'Custom 1', 'form' )
													)
												)
			2) Add a CSS rules for the class '.ta_custom_1' to create a custom entrance animation
		*/
		$animations = array_merge(
						$animations,
						array(
							esc_html__( 'Theme Specific', 'form' ) => array(
																			'ta_fadeinup' 		=> esc_html__( 'Fade In Up (Short)', 'form' ),
																			'ta_fadeinright'	=> esc_html__( 'Fade In Right (Short)', 'form' ),
																			'ta_fadeinleft'		=> esc_html__( 'Fade In Left (Short)', 'form' ),
																			'ta_fadeindown'		=> esc_html__( 'Fade In Down (Short)', 'form' ),
																			'ta_fadein' 		=> esc_html__( 'Fade In (Short)', 'form' ),
																			'ta_popup' 			=> esc_html__( 'Pop Up', 'form' ),
																			'ta_infiniterotate' => esc_html__( 'Infinite Rotate', 'form' ),
																			)
							)
						);
		return $animations;
	}
}
