<?php
/**
 * The template to display single post
 *
 * @package FORM
 * @since FORM 1.0
 */

// Full post loading
$full_post_loading          = form_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = form_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = form_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$form_related_position   = form_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$form_posts_navigation   = form_get_theme_option( 'posts_navigation' );
$form_prev_post          = false;
$form_prev_post_same_cat = (int)form_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( form_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	form_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'form_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $form_posts_navigation ) {
		$form_prev_post = get_previous_post( $form_prev_post_same_cat );  // Get post from same category
		if ( ! $form_prev_post && $form_prev_post_same_cat ) {
			$form_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $form_prev_post ) {
			$form_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $form_prev_post ) ) {
		form_sc_layouts_showed( 'featured', false );
		form_sc_layouts_showed( 'title', false );
		form_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $form_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/content', 'single-' . form_get_theme_option( 'single_style' ) ), 'single-' . form_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $form_related_position, 'inside' ) === 0 ) {
		$form_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'form_action_related_posts' );
		$form_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $form_related_content ) ) {
			$form_related_position_inside = max( 0, min( 9, form_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $form_related_position_inside ) {
				$form_related_position_inside = mt_rand( 1, 9 );
			}

			$form_p_number         = 0;
			$form_related_inserted = false;
			$form_in_block         = false;
			$form_content_start    = strpos( $form_content, '<div class="post_content' );
			$form_content_end      = strrpos( $form_content, '</div>' );

			for ( $i = max( 0, $form_content_start ); $i < min( strlen( $form_content ) - 3, $form_content_end ); $i++ ) {
				if ( $form_content[ $i ] != '<' ) {
					continue;
				}
				if ( $form_in_block ) {
					if ( strtolower( substr( $form_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$form_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $form_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $form_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$form_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $form_content[ $i + 1 ] && in_array( $form_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$form_p_number++;
					if ( $form_related_position_inside == $form_p_number ) {
						$form_related_inserted = true;
						$form_content = ( $i > 0 ? substr( $form_content, 0, $i ) : '' )
											. $form_related_content
											. substr( $form_content, $i );
					}
				}
			}
			if ( ! $form_related_inserted ) {
				if ( $form_content_end > 0 ) {
					$form_content = substr( $form_content, 0, $form_content_end ) . $form_related_content . substr( $form_content, $form_content_end );
				} else {
					$form_content .= $form_related_content;
				}
			}
		}

		form_show_layout( $form_content );
	}

	// Comments
	do_action( 'form_action_before_comments' );
	comments_template();
	do_action( 'form_action_after_comments' );

	// Related posts
	if ( 'below_content' == $form_related_position
		&& ( 'scroll' != $form_posts_navigation || (int)form_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)form_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'form_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $form_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $form_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $form_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $form_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'form_action_nav_links_single_scroll_data', $form_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
