<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package FORM
 * @since FORM 1.0
 */

if ( form_sidebar_present() ) {
	
	$form_sidebar_type = form_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $form_sidebar_type && ! form_is_layouts_available() ) {
		$form_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $form_sidebar_type ) {
		// Default sidebar with widgets
		$form_sidebar_name = form_get_theme_option( 'sidebar_widgets' );
		form_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $form_sidebar_name ) ) {
			dynamic_sidebar( $form_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$form_sidebar_id = form_get_custom_sidebar_id();
		do_action( 'form_action_show_layout', $form_sidebar_id );
	}
	$form_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $form_out ) ) {
		$form_sidebar_position    = form_get_theme_option( 'sidebar_position' );
		$form_sidebar_position_ss = form_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $form_sidebar_position );
			echo ' sidebar_' . esc_attr( $form_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $form_sidebar_type );

			$form_sidebar_scheme = apply_filters( 'form_filter_sidebar_scheme', form_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $form_sidebar_scheme ) && ! form_is_inherit( $form_sidebar_scheme ) && 'custom' != $form_sidebar_type ) {
				echo ' scheme_' . esc_attr( $form_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<span id="sidebar_skip_link_anchor" class="form_skip_link_anchor"></span>
			<?php

			do_action( 'form_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $form_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$form_title = apply_filters( 'form_filter_sidebar_control_title', 'float' == $form_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'form' ) : '' );
				$form_text  = apply_filters( 'form_filter_sidebar_control_text', 'above' == $form_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'form' ) : '' );
				?>
				<a href="#" role="button" class="sidebar_control" title="<?php echo esc_attr( $form_title ); ?>"><?php echo esc_html( $form_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'form_action_before_sidebar', 'sidebar' );
				form_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $form_out ) );
				do_action( 'form_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'form_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
