<?php
/* MetForm support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'form_metform_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'form_metform_theme_setup9', 9 );
	function form_metform_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'form_filter_tgmpa_required_plugins', 'form_metform_tgmpa_required_plugins' );
			add_filter( 'form_filter_theme_plugins', 'form_metform_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'form_metform_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('form_filter_tgmpa_required_plugins',	'form_metform_tgmpa_required_plugins');
	function form_metform_tgmpa_required_plugins( $list = array() ) {
		if ( form_storage_isset( 'required_plugins', 'metform' ) && form_storage_get_array( 'required_plugins', 'metform', 'install' ) !== false ) {
			$list[] = array(
				'name'     => form_storage_get_array( 'required_plugins', 'metform', 'title' ),
				'slug'     => 'metform',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'form_metform_theme_plugins' ) ) {
	//Handler of the add_filter( 'form_filter_theme_plugins', 'form_metform_theme_plugins' );
	function form_metform_theme_plugins( $list = array() ) {
		return form_add_group_and_logo_to_slave( $list, 'metform', 'metform-' );
	}
}



// Check if a plugin is installed and activated
if ( ! function_exists( 'form_exists_metform' ) ) {
	function form_exists_metform() {
		return class_exists( 'MetForm\Plugin' );
	}
}
