<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package FORM
 * @since FORM 1.0
 */

$form_template = apply_filters( 'form_filter_get_template_part', form_blog_archive_get_template() );

if ( ! empty( $form_template ) && 'index' != $form_template ) {

	get_template_part( $form_template );

} else {

	form_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$form_stickies   = is_home()
								|| ( in_array( form_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) form_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$form_post_type  = form_get_theme_option( 'post_type' );
		$form_args       = array(
								'blog_style'     => form_get_theme_option( 'blog_style' ),
								'post_type'      => $form_post_type,
								'taxonomy'       => form_get_post_type_taxonomy( $form_post_type ),
								'parent_cat'     => form_get_theme_option( 'parent_cat' ),
								'posts_per_page' => form_get_theme_option( 'posts_per_page' ),
								'sticky'         => form_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $form_stickies )
															&& count( $form_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		form_blog_archive_start();

		do_action( 'form_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'form_action_before_page_author' );
			get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'form_action_after_page_author' );
		}

		if ( form_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'form_action_before_page_filters' );
			form_show_filters( $form_args );
			do_action( 'form_action_after_page_filters' );
		} else {
			do_action( 'form_action_before_page_posts' );
			form_show_posts( array_merge( $form_args, array( 'cat' => $form_args['parent_cat'] ) ) );
			do_action( 'form_action_after_page_posts' );
		}

		do_action( 'form_action_blog_archive_end' );

		form_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
