<?php
/**
 * The Header: Logo and main menu
 *
 * @package FORM
 * @since FORM 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( form_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'form_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'form_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('form_action_body_wrap_attributes'); ?>>

		<?php do_action( 'form_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'form_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('form_action_page_wrap_attributes'); ?>>

			<?php do_action( 'form_action_page_wrap_start' ); ?>

			<?php
			$form_full_post_loading = ( form_is_singular( 'post' ) || form_is_singular( 'attachment' ) ) && form_get_value_gp( 'action' ) == 'full_post_loading';
			$form_prev_post_loading = ( form_is_singular( 'post' ) || form_is_singular( 'attachment' ) ) && form_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $form_full_post_loading && ! $form_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="form_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'form_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to content", 'form' ); ?></a>
				<?php if ( form_sidebar_present() ) { ?>
				<a class="form_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'form_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'form' ); ?></a>
				<?php } ?>
				<a class="form_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'form_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to footer", 'form' ); ?></a>

				<?php
				do_action( 'form_action_before_header' );

				// Header
				$form_header_type = form_get_theme_option( 'header_type' );
				if ( 'custom' == $form_header_type && ! form_is_layouts_available() ) {
					$form_header_type = 'default';
				}
				get_template_part( apply_filters( 'form_filter_get_template_part', "templates/header-" . sanitize_file_name( $form_header_type ) ) );

				// Side menu
				if ( in_array( form_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'form_filter_use_navi_mobile', form_sc_layouts_showed( 'menu_button' ) || $form_header_type == 'default' ) ) {
					get_template_part( apply_filters( 'form_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'form_action_after_header' );

			}
			?>

			<?php do_action( 'form_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( form_is_off( form_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $form_header_type ) ) {
						$form_header_type = form_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $form_header_type && form_is_layouts_available() ) {
						$form_header_id = form_get_custom_header_id();
						if ( $form_header_id > 0 ) {
							$form_header_meta = form_get_custom_layout_meta( $form_header_id );
							if ( ! empty( $form_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$form_footer_type = form_get_theme_option( 'footer_type' );
					if ( 'custom' == $form_footer_type && form_is_layouts_available() ) {
						$form_footer_id = form_get_custom_footer_id();
						if ( $form_footer_id ) {
							$form_footer_meta = form_get_custom_layout_meta( $form_footer_id );
							if ( ! empty( $form_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'form_action_page_content_wrap_class', $form_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'form_filter_is_prev_post_loading', $form_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( form_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'form_action_page_content_wrap_data', $form_prev_post_loading );
			?>>
				<?php
				do_action( 'form_action_page_content_wrap', $form_full_post_loading || $form_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'form_filter_single_post_header', form_is_singular( 'post' ) || form_is_singular( 'attachment' ) ) ) {
					if ( $form_prev_post_loading ) {
						if ( form_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'form_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$form_path = apply_filters( 'form_filter_get_template_part', 'templates/single-styles/' . form_get_theme_option( 'single_style' ) );
					if ( form_get_file_dir( $form_path . '.php' ) != '' ) {
						get_template_part( $form_path );
					}
				}

				// Widgets area above page
				$form_body_style   = form_get_theme_option( 'body_style' );
				$form_widgets_name = form_get_theme_option( 'widgets_above_page', 'hide' );
				$form_show_widgets = ! form_is_off( $form_widgets_name ) && is_active_sidebar( $form_widgets_name );
				if ( $form_show_widgets ) {
					if ( 'fullscreen' != $form_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					form_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $form_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'form_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $form_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'form_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'form_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<span id="content_skip_link_anchor" class="form_skip_link_anchor"></span>
						<?php
						// Single posts banner between prev/next posts
						if ( ( form_is_singular( 'post' ) || form_is_singular( 'attachment' ) )
							&& $form_prev_post_loading 
							&& form_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'form_action_between_posts' );
						}

						// Widgets area above content
						form_create_widgets_area( 'widgets_above_content' );

						do_action( 'form_action_page_content_start_text' );
