<?php
$form_woocommerce_sc = form_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $form_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$form_scheme = form_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $form_scheme ) && ! form_is_inherit( $form_scheme ) ) {
			echo ' scheme_' . esc_attr( $form_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( form_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( form_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$form_css      = '';
			$form_bg_image = form_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $form_bg_image ) ) {
				$form_css .= 'background-image: url(' . esc_url( form_get_attachment_url( $form_bg_image ) ) . ');';
			}
			if ( ! empty( $form_css ) ) {
				echo ' style="' . esc_attr( $form_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$form_anchor_icon = form_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$form_anchor_text = form_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $form_anchor_icon ) || ! empty( $form_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $form_anchor_icon ) ? ' icon="' . esc_attr( $form_anchor_icon ) . '"' : '' )
											. ( ! empty( $form_anchor_text ) ? ' title="' . esc_attr( $form_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( form_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' form-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$form_css      = '';
				$form_bg_mask  = form_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$form_bg_color_type = form_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $form_bg_color_type ) {
					$form_bg_color = form_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $form_bg_color_type ) {
					$form_bg_color = form_get_scheme_color( 'bg_color', $form_scheme );
				} else {
					$form_bg_color = '';
				}
				if ( ! empty( $form_bg_color ) && $form_bg_mask > 0 ) {
					$form_css .= 'background-color: ' . esc_attr(
						1 == $form_bg_mask ? $form_bg_color : form_hex2rgba( $form_bg_color, $form_bg_mask )
					) . ';';
				}
				if ( ! empty( $form_css ) ) {
					echo ' style="' . esc_attr( $form_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$form_caption     = form_get_theme_option( 'front_page_woocommerce_caption' );
				$form_description = form_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $form_caption ) || ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $form_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $form_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $form_caption, 'form_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $form_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $form_description ), 'form_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $form_woocommerce_sc ) {
						$form_woocommerce_sc_ids      = form_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$form_woocommerce_sc_per_page = count( explode( ',', $form_woocommerce_sc_ids ) );
					} else {
						$form_woocommerce_sc_per_page = max( 1, (int) form_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$form_woocommerce_sc_columns = max( 1, min( $form_woocommerce_sc_per_page, (int) form_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$form_woocommerce_sc}"
										. ( 'products' == $form_woocommerce_sc
												? ' ids="' . esc_attr( $form_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $form_woocommerce_sc
												? ' category="' . esc_attr( form_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $form_woocommerce_sc
												? ' orderby="' . esc_attr( form_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( form_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $form_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $form_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
