<?php
$form_slider_sc = form_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $form_slider_sc ) && strpos( $form_slider_sc, '[' ) !== false && strpos( $form_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( form_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$form_anchor_icon = form_get_theme_option( 'front_page_title_anchor_icon' );
		$form_anchor_text = form_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $form_anchor_icon ) || ! empty( $form_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $form_anchor_icon ) ? ' icon="' . esc_attr( $form_anchor_icon ) . '"' : '' )
									. ( ! empty( $form_anchor_text ) ? ' title="' . esc_attr( $form_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $form_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$form_scheme = form_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $form_scheme ) && ! form_is_inherit( $form_scheme ) ) {
			echo ' scheme_' . esc_attr( $form_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( form_get_theme_option( 'front_page_title_paddings' ) );
		if ( form_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$form_css      = '';
		$form_bg_image = form_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $form_bg_image ) ) {
			$form_css .= 'background-image: url(' . esc_url( form_get_attachment_url( $form_bg_image ) ) . ');';
		}
		if ( ! empty( $form_css ) ) {
			echo ' style="' . esc_attr( $form_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$form_anchor_icon = form_get_theme_option( 'front_page_title_anchor_icon' );
		$form_anchor_text = form_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $form_anchor_icon ) || ! empty( $form_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $form_anchor_icon ) ? ' icon="' . esc_attr( $form_anchor_icon ) . '"' : '' )
									. ( ! empty( $form_anchor_text ) ? ' title="' . esc_attr( $form_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( form_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' form-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$form_css      = '';
			$form_bg_mask  = form_get_theme_option( 'front_page_title_bg_mask' );
			$form_bg_color_type = form_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $form_bg_color_type ) {
				$form_bg_color = form_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $form_bg_color_type ) {
				$form_bg_color = form_get_scheme_color( 'bg_color', $form_scheme );
			} else {
				$form_bg_color = '';
			}
			if ( ! empty( $form_bg_color ) && $form_bg_mask > 0 ) {
				$form_css .= 'background-color: ' . esc_attr(
					1 == $form_bg_mask ? $form_bg_color : form_hex2rgba( $form_bg_color, $form_bg_mask )
				) . ';';
			}
			if ( ! empty( $form_css ) ) {
				echo ' style="' . esc_attr( $form_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$form_caption = form_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $form_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $form_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $form_caption, 'form_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$form_description = form_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $form_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $form_description ), 'form_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( form_get_theme_option( 'front_page_title_button1_link' ) != '' || form_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						form_show_layout( form_customizer_partial_refresh_front_page_title_button1_link() );
						form_show_layout( form_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
