<div class="front_page_section front_page_section_contacts<?php
	$form_scheme = form_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $form_scheme ) && ! form_is_inherit( $form_scheme ) ) {
		echo ' scheme_' . esc_attr( $form_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( form_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( form_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$form_css      = '';
		$form_bg_image = form_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $form_bg_image ) ) {
			$form_css .= 'background-image: url(' . esc_url( form_get_attachment_url( $form_bg_image ) ) . ');';
		}
		if ( ! empty( $form_css ) ) {
			echo ' style="' . esc_attr( $form_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$form_anchor_icon = form_get_theme_option( 'front_page_contacts_anchor_icon' );
	$form_anchor_text = form_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $form_anchor_icon ) || ! empty( $form_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $form_anchor_icon ) ? ' icon="' . esc_attr( $form_anchor_icon ) . '"' : '' )
									. ( ! empty( $form_anchor_text ) ? ' title="' . esc_attr( $form_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( form_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' form-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$form_css      = '';
			$form_bg_mask  = form_get_theme_option( 'front_page_contacts_bg_mask' );
			$form_bg_color_type = form_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $form_bg_color_type ) {
				$form_bg_color = form_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $form_bg_color_type ) {
				$form_bg_color = form_get_scheme_color( 'bg_color', $form_scheme );
			} else {
				$form_bg_color = '';
			}
			if ( ! empty( $form_bg_color ) && $form_bg_mask > 0 ) {
				$form_css .= 'background-color: ' . esc_attr(
					1 == $form_bg_mask ? $form_bg_color : form_hex2rgba( $form_bg_color, $form_bg_mask )
				) . ';';
			}
			if ( ! empty( $form_css ) ) {
				echo ' style="' . esc_attr( $form_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$form_caption     = form_get_theme_option( 'front_page_contacts_caption' );
			$form_description = form_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $form_caption ) || ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $form_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $form_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $form_caption, 'form_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $form_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $form_description ), 'form_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$form_content = form_get_theme_option( 'front_page_contacts_content' );
			$form_layout  = form_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $form_layout && ( ! empty( $form_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $form_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $form_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $form_content, 'form_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $form_layout && ( ! empty( $form_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$form_sc = form_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $form_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $form_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					form_show_layout( do_shortcode( $form_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $form_layout && ( ! empty( $form_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
