<div class="front_page_section front_page_section_about<?php
	$form_scheme = form_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $form_scheme ) && ! form_is_inherit( $form_scheme ) ) {
		echo ' scheme_' . esc_attr( $form_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( form_get_theme_option( 'front_page_about_paddings' ) );
	if ( form_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$form_css      = '';
		$form_bg_image = form_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $form_bg_image ) ) {
			$form_css .= 'background-image: url(' . esc_url( form_get_attachment_url( $form_bg_image ) ) . ');';
		}
		if ( ! empty( $form_css ) ) {
			echo ' style="' . esc_attr( $form_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$form_anchor_icon = form_get_theme_option( 'front_page_about_anchor_icon' );
	$form_anchor_text = form_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $form_anchor_icon ) || ! empty( $form_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $form_anchor_icon ) ? ' icon="' . esc_attr( $form_anchor_icon ) . '"' : '' )
									. ( ! empty( $form_anchor_text ) ? ' title="' . esc_attr( $form_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( form_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' form-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$form_css           = '';
			$form_bg_mask       = form_get_theme_option( 'front_page_about_bg_mask' );
			$form_bg_color_type = form_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $form_bg_color_type ) {
				$form_bg_color = form_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $form_bg_color_type ) {
				$form_bg_color = form_get_scheme_color( 'bg_color', $form_scheme );
			} else {
				$form_bg_color = '';
			}
			if ( ! empty( $form_bg_color ) && $form_bg_mask > 0 ) {
				$form_css .= 'background-color: ' . esc_attr(
					1 == $form_bg_mask ? $form_bg_color : form_hex2rgba( $form_bg_color, $form_bg_mask )
				) . ';';
			}
			if ( ! empty( $form_css ) ) {
				echo ' style="' . esc_attr( $form_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$form_caption = form_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $form_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $form_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $form_caption, 'form_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$form_description = form_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $form_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $form_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $form_description ), 'form_kses_content' ); ?></div>
				<?php
			}

			// Content
			$form_content = form_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $form_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $form_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$form_page_content_mask = '%%CONTENT%%';
					if ( strpos( $form_content, $form_page_content_mask ) !== false ) {
						$form_content = preg_replace(
							'/(\<p\>\s*)?' . $form_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$form_content
						);
					}
					form_show_layout( $form_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
