<?php
/**
 * The Front Page template file.
 *
 * @package FORM
 * @since FORM 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( form_is_on( form_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$form_sections = form_array_get_keys_by_value( form_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $form_sections ) ) {
			foreach ( $form_sections as $form_section ) {
				get_template_part( apply_filters( 'form_filter_get_template_part', 'front-page/section', $form_section ), $form_section );
			}
		}

		// Else if this page is a blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'form_filter_get_template_part', 'blog' ) );

		// Else - display a native page content
	} else {
		get_template_part( apply_filters( 'form_filter_get_template_part', 'page' ) );
	}

	// Else get the template 'index.php' to show posts
} else {
	get_template_part( apply_filters( 'form_filter_get_template_part', 'index' ) );
}

get_footer();
