<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package FORM
 * @since FORM 1.0
 */

							do_action( 'form_action_page_content_end_text' );
							
							// Widgets area below the content
							form_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'form_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'form_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'form_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'form_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$form_body_style = form_get_theme_option( 'body_style' );
					$form_widgets_name = form_get_theme_option( 'widgets_below_page', 'hide' );
					$form_show_widgets = ! form_is_off( $form_widgets_name ) && is_active_sidebar( $form_widgets_name );
					$form_show_related = form_is_single() && form_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $form_show_widgets || $form_show_related ) {
						if ( 'fullscreen' != $form_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $form_show_related ) {
							do_action( 'form_action_related_posts' );
						}

						// Widgets area below page content
						if ( $form_show_widgets ) {
							form_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $form_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'form_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'form_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! form_is_singular( 'post' ) && ! form_is_singular( 'attachment' ) ) || ! in_array ( form_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<span id="footer_skip_link_anchor" class="form_skip_link_anchor"></span>
				<?php

				do_action( 'form_action_before_footer' );

				// Footer
				$form_footer_type = form_get_theme_option( 'footer_type' );
				if ( 'custom' == $form_footer_type && ! form_is_layouts_available() ) {
					$form_footer_type = 'default';
				}
				get_template_part( apply_filters( 'form_filter_get_template_part', "templates/footer-" . sanitize_file_name( $form_footer_type ) ) );

				do_action( 'form_action_after_footer' );

			}
			?>

			<?php do_action( 'form_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'form_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'form_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>