jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.notice[data-notice="get-start"] button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'dropshipping_shop_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});

// Plugin – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const dropshipping_shop_button = document.getElementById('install-activate-button');

    if (!dropshipping_shop_button) return;

    dropshipping_shop_button.addEventListener('click', function (e) {
        e.preventDefault();

        const dropshipping_shop_redirectUrl = dropshipping_shop_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const dropshipping_shop_checkData = new FormData();
        dropshipping_shop_checkData.append('action', 'check_plugin_activation');

        fetch(installPluginData.ajaxurl, {
            method: 'POST',
            body: dropshipping_shop_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = dropshipping_shop_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                dropshipping_shop_button.textContent = 'Installing & Activating...';

                const dropshipping_shop_installData = new FormData();
                dropshipping_shop_installData.append('action', 'install_and_activate_required_plugin');
                dropshipping_shop_installData.append('_ajax_nonce', installPluginData.nonce);

                fetch(installPluginData.ajaxurl, {
                    method: 'POST',
                    body: dropshipping_shop_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = dropshipping_shop_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        dropshipping_shop_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    dropshipping_shop_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
