jQuery(document).ready(function() {
  jQuery('.owl-carousel').owlCarousel({
    loop: true,
    margin: 15,
    nav: true,
    navText: ["<span class='left-btn p-3'></span>", "<span class='right-btn p-3'></span>"], 
    dots: false,
    rtl: false,
    responsive: {
    0: { 
      items: 1 
    },
    768: { 
      items: 2 
    },
    992: { 
      items: 2 
    },
    1200: { 
      items: 3 
    }
  },
    autoplay: true,
  });
});

// Scroll to Top
window.onscroll = function() {
  const dropshipping_shop_button = document.querySelector('.scroll-top-box');
  if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
    dropshipping_shop_button.style.display = "block";
  } else {
    dropshipping_shop_button.style.display = "none";
  }
};

document.querySelector('.scroll-top-box a').onclick = function(event) {
  event.preventDefault();
  window.scrollTo({top: 0, behavior: 'smooth'});
};

// Gallery Slider
jQuery(document).ready(function($) {
  var $dropshipping_shop_gallery = $('.banner-top-gallery');
  var dropshipping_shop_rotateImages = function () {
    var $dropshipping_shop_firstImage = $dropshipping_shop_gallery.children('.banner-top-image').first();
    var $dropshipping_shop_clone = $dropshipping_shop_firstImage.clone(true);

    $dropshipping_shop_firstImage.fadeOut(600, function () {
      $(this).remove();
      $dropshipping_shop_gallery.append($dropshipping_shop_clone.hide().fadeIn(600));
    });
  };

  var interval = setInterval(dropshipping_shop_rotateImages, 3000);

  $('.banner-top-right-card').hover(
    function () {
      clearInterval(interval);
    },
    function () {
      interval = setInterval(dropshipping_shop_rotateImages, 3000);
    }
  );

  $('.banner-top-gallery .banner-top-image').on('click', function () {
    dropshipping_shop_rotateImages();
  });
});