<?php
/**
 * Add theme page
 */

function dropshipping_shop_menu() {
	add_theme_page( esc_html__( 'Dropshipping Shop', 'dropshipping-shop' ), esc_html__( 'Dropshipping Shop Theme', 'dropshipping-shop' ), 'edit_theme_options', 'dropshipping-shop-info', 'dropshipping_shop_theme_page_display' );
}
add_action( 'admin_menu', 'dropshipping_shop_menu' );

function dropshipping_shop_admin_theme_style() {
	wp_enqueue_style('dropshipping-shop-custom-admin-style', esc_url(get_template_directory_uri()) . '/css/admin-style.css');
	wp_enqueue_script('dropshipping-shop-tabs', esc_url(get_template_directory_uri()) . '/js/tab.js');
}
add_action('admin_enqueue_scripts', 'dropshipping_shop_admin_theme_style');

/**
 * Display About page
 */
function dropshipping_shop_theme_page_display() {
	$dropshipping_shop_theme = wp_get_theme();

	if ( is_child_theme() ) {
		$dropshipping_shop_theme = wp_get_theme()->parent();
	} ?>

	<div class="wrapper-info">
	    <div class="col-left sshot-section">
	    	<h2><?php esc_html_e( 'Welcome to Dropshipping Shop Theme', 'dropshipping-shop' ); ?> <span class="version"><?php esc_html_e('Version:','dropshipping-shop'); ?> <?php echo esc_html($dropshipping_shop_theme['Version']);?></span></h2>
	    	<p><?php esc_html_e('All our WordPress themes are modern, minimalist, 100% responsive, seo-friendly,feature-rich, and multipurpose that best suit designers, bloggers and other professionals who are working in the creative fields.','dropshipping-shop'); ?></p>
	    </div>
	    <div class="col-right coupen-section">
			<div class="logo-section">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" alt="" />
			</div>
			<div class="logo-right">            
	            <div class="update-now">
	                <div class="theme-info">
	                    <div class="theme-info-left">
	                        <h2><?php esc_html_e('TRY PREMIUM','dropshipping-shop'); ?></h2>
	                        <h4><?php esc_html_e('DROPSHIPPING SHOP THEME','dropshipping-shop'); ?></h4>
	                    </div>    
	                    <div class="theme-info-right"></div>
	                </div>    
	                <div class="dicount-row">
	                    <div class="disc-sec">    
	                        <h5 class="disc-text"><?php esc_html_e('GET THE FLAT DISCOUNT OF','dropshipping-shop'); ?></h5>
	                        <h1 class="disc-per"><?php esc_html_e('20%','dropshipping-shop'); ?></h1>    
	                    </div>
	                    <div class="coupen-info">
	                        <h5 class="coupen-code"><?php esc_html_e('"VWPRO20"','dropshipping-shop'); ?></h5>
	                        <h5 class="coupen-text"><?php esc_html_e('USE COUPON CODE','dropshipping-shop'); ?></h5>
	                        <div class="info-link">                        
	                            <a href="<?php echo esc_url( DROPSHIPPING_SHOP_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'UPGRADE TO PRO', 'dropshipping-shop' ); ?></a>
	                        </div>    
	                    </div>    
	                </div>                
	            </div>
	        </div> 
	    </div>

	    <div class="tab-sec">
			<div class="tab">
				<button class="tablinks" onclick="dropshipping_shop_open_tab(event, 'lite_theme')"><?php esc_html_e( 'Free Setup', 'dropshipping-shop' ); ?></button>
			  	<button class="tablinks" onclick="dropshipping_shop_open_tab(event, 'pro_theme')"><?php esc_html_e( 'Get Premium', 'dropshipping-shop' ); ?></button>
			  	<button class="tablinks" onclick="dropshipping_shop_open_tab(event, 'free_pro')"><?php esc_html_e( 'Free Vs Premium', 'dropshipping-shop' ); ?></button>
			  	<button class="tablinks" onclick="dropshipping_shop_open_tab(event, 'get_bundle')"><?php esc_html_e( 'Get 350+ Themes Bundle at $99', 'dropshipping-shop' ); ?></button>
			</div>

			<div id="lite_theme" class="tabcontent open">
				<div class="lite-theme-tab">
					<h3><?php esc_html_e( 'Lite Theme Information', 'dropshipping-shop' ); ?></h3>
					<hr class="h3hr">
				  	<p><?php esc_html_e('Launch your dream online store with the Dropshipping Shop free theme, crafted for modern entrepreneurs looking to build powerful and scalable eCommerce websites. This theme is ideal for those stepping into the digital marketplace with a focus on dropshipping, print on demand, online store, ecommerce store, online retail shop, fashion store, electronics store, beauty products, custom merchandise, niche product catalog, single product store, and general online shop businesses. Whether you’re starting a clothing store, home décor shop, gadget store, or custom merchandise business, this theme gives you all the tools to succeed online. It supports WooCommerce, making it easy to manage product listings, shopping carts, online payments, and order processing. With a sleek and responsive design, it ensures your store looks perfect across all devices, enhancing user experience and engagement. Easy customization options allow you to personalize colors, fonts, and layouts to match your brand without coding. The theme is optimized for speed and search engines, helping your website rank better and load faster. It integrates smoothly with plugins like Contact Form 7, Rank Math SEO, and Mailchimp, giving you advanced control over marketing, lead generation, analytics, and customer interactions. Whether you’re running a small shop, marketplace, or a large-scale catalog, it scales effortlessly without compromising performance. If you’re ready to establish your presence in the world of ecommerce and dropshipping, this theme is your go-to solution. Download it now and start building a professional online business that grows with you.','dropshipping-shop'); ?></p>
				  	<div class="col-left-inner">
						<div class="pro-links">
					    	<a href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site', 'dropshipping-shop'); ?></a>
							<a href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site', 'dropshipping-shop'); ?></a>
						</div>
						<div class="support-forum-col-section">
							<div class="support-forum-col">
								<h4><?php esc_html_e('Having Trouble, Need Support?', 'dropshipping-shop'); ?></h4>
								<p> <?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'dropshipping-shop'); ?></p>
								<div class="info-link">
									<a href="<?php echo esc_url( DROPSHIPPING_SHOP_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'dropshipping-shop'); ?></a>
								</div>
							</div>
							<div class="support-forum-col">
								<h4><?php esc_html_e('Reviews & Testimonials', 'dropshipping-shop'); ?></h4>
								<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'dropshipping-shop'); ?>  </p>
								<div class="info-link">
									<a href="<?php echo esc_url( DROPSHIPPING_SHOP_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'dropshipping-shop'); ?></a>
								</div>
							</div>
							<div class="support-forum-col">
								<h4><?php esc_html_e('Theme Documentation', 'dropshipping-shop'); ?></h4>
								<p> <?php esc_html_e('If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'dropshipping-shop'); ?>  </p>
								<div class="info-link">
									<a href="<?php echo esc_url( DROPSHIPPING_SHOP_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Free Theme Documentation', 'dropshipping-shop'); ?></a>
								</div>
							</div>
						</div>
				  	</div>
				</div>
			</div>

			<div id="pro_theme" class="tabcontent">
			  	<h3><?php esc_html_e( 'Premium Theme Information', 'dropshipping-shop' ); ?></h3>
				<hr class="h3hr">
				<div class="col-left-pro">
	    			<p><?php esc_html_e('Our Dropshipping WordPress Theme is a modern and powerful eCommerce solution built exclusively for entrepreneurs looking to launch or scale their online business effortlessly. With a sleek and user-friendly interface, this theme provides all the essential tools and design elements required to build a successful dropshipping store. It’s fully compatible with WooCommerce, giving you the flexibility to manage products, payments, and shipping with ease. The clean and professional design makes your site look trustworthy and attractive to customers, which is essential for conversion and brand growth. This theme comes with pre-designed templates that can be customized to suit any dropshipping niche whether it’s fashion, electronics, home décor, or beauty products. The layout is mobile-first and retina-ready, ensuring your store looks flawless on every device. The integration with Elementor allows you to craft visually stunning pages without any coding knowledge. With optimized loading speed, SEO integration, and advanced product display options, you can ensure both performance and visibility. Whether you\'re a beginner or an experienced store owner, this theme simplifies the process and offers full control through a powerful admin panel. Choose our Dropshipping WordPress Theme for a seamless and scalable eCommerce experience.','dropshipping-shop'); ?></p>
	    		</div>
		    	<div class="col-right-pro">
			    	<div class="pro-links">
				    	<a href="<?php echo esc_url( DROPSHIPPING_SHOP_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'dropshipping-shop'); ?></a>
						<a href="<?php echo esc_url( DROPSHIPPING_SHOP_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'dropshipping-shop'); ?></a>
						<a href="<?php echo esc_url( DROPSHIPPING_SHOP_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'dropshipping-shop'); ?></a>
						<a href="<?php echo esc_url( DROPSHIPPING_SHOP_THEME_BUNDLE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get 350+ Themes Bundle at $99', 'dropshipping-shop'); ?></a>
					</div>
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/pro.png" alt="" />
				</div>
			</div>

			<div id="free_pro" class="tabcontent">
				<div class="featurebox">
				    <h3 class="theme-features"><?php esc_html_e( 'Theme Features', 'dropshipping-shop' ); ?></h3>
					<hr class="h3hr1">
					<div class="table-image">
						<table class="tablebox">
							<thead>
								<tr>
									<th><?php esc_html_e('Features', 'dropshipping-shop'); ?></th>
									<th><?php esc_html_e('Free Themes', 'dropshipping-shop'); ?></th>
									<th><?php esc_html_e('Premium Themes', 'dropshipping-shop'); ?></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td><?php esc_html_e('Easy Setup', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Responsive Design', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('SEO Friendly', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Banner Settings', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Template Pages', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('1', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('14', 'dropshipping-shop'); ?></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Home Page Template', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('1', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('1', 'dropshipping-shop'); ?></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Theme sections', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('2', 'dropshipping-shop'); ?></td>
									<td class="table-img"><?php esc_html_e('12', 'dropshipping-shop'); ?></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Contact us Page Template', 'dropshipping-shop'); ?></td>
									<td class="table-img">0</td>
									<td class="table-img"><?php esc_html_e('1', 'dropshipping-shop'); ?></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Blog Templates & Layout', 'dropshipping-shop'); ?></td>
									<td class="table-img">0</td>
									<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'dropshipping-shop'); ?></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Section Reordering', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Demo Importer', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Full Documentation', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Latest WordPress Compatibility', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Support 3rd Party Plugins', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Secure and Optimized Code', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Exclusive Functionalities', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Section Enable / Disable', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Section Google Font Choices', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Gallery', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Simple & Mega Menu Option', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Support to add custom CSS / JS ', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Shortcodes', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Premium Membership', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Budget Friendly Value', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Priority Error Fixing', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Custom Feature Addition', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('All Access Theme Pass', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Seamless Customer Support', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('WordPress 6.4 or later', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('PHP 8.2 or 8.3', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('MySQL 5.6 (or greater) | MariaDB 10.0 (or greater)', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Influence Registration', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr class="odd">
									<td><?php esc_html_e('Detailed Influencer Portfolio', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
									<td><?php esc_html_e('Premium Pricing Plan', 'dropshipping-shop'); ?></td>
									<td class="table-img"><span class="dashicons dashicons-no"></span></td>
									<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								</tr>
								<tr>
								<td></td>
								<td class="table-img"></td>
								<td class="update-link"><a href="<?php echo esc_url( DROPSHIPPING_SHOP_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade to Pro', 'dropshipping-shop'); ?></a></td>
								</tr>
							</tbody>
						</table>

					</div>
				</div>
			</div>

			<div id="get_bundle" class="tabcontent">		  	
			   <div class="col-left-pro">
			   	<h3><?php esc_html_e( 'WP Theme Bundle', 'dropshipping-shop' ); ?></h3>
			    	<p><?php esc_html_e('Enhance your website effortlessly with our WP Theme Bundle. Get access to 350+ premium WordPress themes and 5+ powerful plugins, all designed to meet diverse business needs. Enjoy seamless integration with any plugins, ultimate customization flexibility, and regular updates to keep your site current and secure. Plus, benefit from our dedicated customer support, ensuring a smooth and professional web experience.','dropshipping-shop'); ?></p>
			    	<div class="feature">
			    		<h4><?php esc_html_e( 'Features:', 'dropshipping-shop' ); ?></h4>
			    		<p><?php esc_html_e('350+ Premium Themes & 5+ Plugins.', 'dropshipping-shop'); ?></p>
			    		<p><?php esc_html_e('Seamless Integration.', 'dropshipping-shop'); ?></p>
			    		<p><?php esc_html_e('Customization Flexibility.', 'dropshipping-shop'); ?></p>
			    		<p><?php esc_html_e('Regular Updates.', 'dropshipping-shop'); ?></p>
			    		<p><?php esc_html_e('Dedicated Support.', 'dropshipping-shop'); ?></p>
			    	</div>
			    	<p>Upgrade now and give your website the professional edge it deserves, all at an unbeatable price of $99!</p>
			    	<div class="pro-links">
						<a href="<?php echo esc_url( DROPSHIPPING_SHOP_THEME_BUNDLE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'dropshipping-shop'); ?></a>
						<a href="<?php echo esc_url( DROPSHIPPING_SHOP_THEME_BUNDLE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'dropshipping-shop'); ?></a>
					</div>
			   </div>
			   <div class="col-right-pro">
			    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/bundle.png" alt="" />
			   </div>		    
			</div>
		</div>
	</div>
<?php }?>
