<?php
/**
 * Dropshipping Shop: Block Patterns
 *
 * @since Dropshipping Shop 1.0
 */

 /**
  * Get patterns content.
  *
  * @param string $file_name Filename.
  * @return string
  */
function dropshipping_shop_get_pattern_content( $file_name ) {
	ob_start();
	include get_theme_file_path( '/patterns/' . $file_name . '.php' );
	$output = ob_get_contents();
	ob_end_clean();
	return $output;
}

/**
 * Registers block patterns and categories.
 *
 * @since Dropshipping Shop 1.0
 *
 * @return void
 */
function dropshipping_shop_register_block_patterns() {

	$patterns = array(
		'header-default' => array(
			'title'      => __( 'Default header', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-headers' ),
			'blockTypes' => array( 'parts/header' ),
		),
		'footer-default' => array(
			'title'      => __( 'Default footer', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-footers' ),
			'blockTypes' => array( 'parts/footer' ),
		),
		'home-banner' => array(
			'title'      => __( 'Home Banner', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-banner' ),
		),
		'product-section' => array(
			'title'      => __( 'Product Section', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-product-section' ),
		),
		'about-section' => array(
			'title'      => __( 'About Section', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-about-section' ),
		),
		'testimonial-section' => array(
			'title'      => __( 'Testimonial Section', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-testimonial-section' ),
		),
		'news-section' => array(
			'title'      => __( 'News Section', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-news-section' ),
		),
		'faq-section' => array(
			'title'      => __( 'FAQ Section', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-faq-section' ),
		),
		'primary-sidebar' => array(
			'title'    => __( 'Primary Sidebar', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-sidebars' ),
		),
		'hidden-404' => array(
			'title'    => __( '404 content', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-pages' ),
		),
		'post-listing-single-column' => array(
			'title'    => __( 'Post Single Column', 'dropshipping-shop' ),
			//'inserter' => false,
			'categories' => array( 'dropshipping-shop-query' ),
		),
		'post-listing-two-column' => array(
			'title'    => __( 'Post Two Column', 'dropshipping-shop' ),
			//'inserter' => false,
			'categories' => array( 'dropshipping-shop-query' ),
		),
		'post-listing-three-column' => array(
			'title'    => __( 'Post Three Column', 'dropshipping-shop' ),
			//'inserter' => false,
			'categories' => array( 'dropshipping-shop-query' ),
		),
		'post-listing-four-column' => array(
			'title'    => __( 'Post Four Column', 'dropshipping-shop' ),
			//'inserter' => false,
			'categories' => array( 'dropshipping-shop-query' ),
		),
		'feature-post-column' => array(
			'title'    => __( 'Feature Post Column', 'dropshipping-shop' ),
			//'inserter' => false,
			'categories' => array( 'dropshipping-shop-query' ),
		),
		'comment-section-1' => array(
			'title'    => __( 'Comment Section 1', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-comment-sections' ),
		),
		'cover-with-post-title' => array(
			'title'    => __( 'Cover With Post Title', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-banner-sections' ),
		),
		'cover-with-search-title' => array(
			'title'    => __( 'Cover With Search Title', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-banner-sections' ),
		),
		'cover-with-archive-title' => array(
			'title'    => __( 'Cover With Archive Title', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-banner-sections' ),
		),
		'cover-with-index-title' => array(
			'title'    => __( 'Cover With Index Title', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-banner-sections' ),
		),
		'theme-button' => array(
			'title'    => __( 'Theme Button', 'dropshipping-shop' ),
			'categories' => array( 'dropshipping-shop-theme-button' ),
		),
	);

	$block_pattern_categories = array(
		'dropshipping-shop-footers' => array( 'label' => __( 'Footers', 'dropshipping-shop' ) ),
		'dropshipping-shop-headers' => array( 'label' => __( 'Headers', 'dropshipping-shop' ) ),
		'dropshipping-shop-pages'   => array( 'label' => __( 'Pages', 'dropshipping-shop' ) ),
		'dropshipping-shop-query'   => array( 'label' => __( 'Query', 'dropshipping-shop' ) ),
		'dropshipping-shop-sidebars'   => array( 'label' => __( 'Sidebars', 'dropshipping-shop' ) ),
		'dropshipping-shop-banner'   => array( 'label' => __( 'Banner Sections', 'dropshipping-shop' ) ),
		'dropshipping-shop-product-section'   => array( 'label' => __( 'Product Section', 'dropshipping-shop' ) ),
		'dropshipping-shop-about-section'   => array( 'label' => __( 'About Section', 'dropshipping-shop' ) ),
		'dropshipping-shop-testimonial-section'   => array( 'label' => __( 'Testimonial Section', 'dropshipping-shop' ) ),
		'dropshipping-shop-news-section'   => array( 'label' => __( 'News Section', 'dropshipping-shop' ) ),
		'dropshipping-shop-faq-section'   => array( 'label' => __( 'FAQ Section', 'dropshipping-shop' ) ),
		'dropshipping-shop-comment-section'   => array( 'label' => __( 'Comment Sections', 'dropshipping-shop' ) ),
		'dropshipping-shop-theme-button'   => array( 'label' => __( 'Theme Button Sections', 'dropshipping-shop' ) ),
	);

	/**
	 * Filters the theme block pattern categories.
	 *
	 * @since Dropshipping Shop 1.0
	 *
	 * @param array[] $block_pattern_categories {
	 *     An associative array of block pattern categories, keyed by category name.
	 *
	 *     @type array[] $properties {
	 *         An array of block category properties.
	 *
	 *         @type string $label A human-readable label for the pattern category.
	 *     }
	 * }
	 */
	$block_pattern_categories = apply_filters( 'dropshipping_shop_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}

	/**
	 * Filters the theme block patterns.
	 *
	 * @since Dropshipping Shop 1.0
	 *
	 * @param array $block_patterns List of block patterns by name.
	 */
	$patterns = apply_filters( 'dropshipping_shop_block_patterns', $patterns );

	foreach ( $patterns as $block_pattern => $pattern ) {
		$pattern['content'] = dropshipping_shop_get_pattern_content( $block_pattern );
		register_block_pattern(
			'dropshipping-shop/' . $block_pattern,
			$pattern
		);
	}
}
add_action( 'init', 'dropshipping_shop_register_block_patterns', 9 );
