<?php
/**
 * Custom Settings for Home v10
 */

acf_add_local_field_group(array(
    'key' => 'group_610bc319bb497',
    'title' => esc_html__( 'Home v10 Options', 'electro' ),
    'fields' => array(
        array(
            'key' => 'field_611a0ba986bbc',
            'label' => esc_html__( 'General', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_611a0c5552e6d',
            'label' => esc_html__( 'Header Style', 'electro'),
            'name' => 'home_v10_header_style',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'v1' => 'Header v1',
                'v2' => 'Header v2',
                'v3' => 'Header v3',
                'v4' => 'Header v4',
                'v5' => 'Header v5',
                'v6' => 'Header v6',
                'v7' => 'Header v7',
                'v8' => 'Header v8',
                'v9' => 'Header v9',
                'v10' => 'Header v10',
                'v11' => 'Header v11',
                'v12' => 'Header v12',
                'v13' => 'Header v13',
            ),
            'default_value' => 'v10',
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 1,
            'ajax' => 0,
            'return_format' => 'value',
            'placeholder' => '',
        ),
        array(
            'key' => 'field_611a233b6fe99',
            'label' => esc_html__( 'Block', 'electro' ),
            'name' => 'home_v10_block',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'row',
            'sub_fields' => array(
                array(
                    'key' => 'field_611a23aa241ee',
                    'label' => esc_html__( 'Page Content', 'electro' ),
                    'name' => 'page_content',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_611a248e3c7d4',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_611a24a43c7d5',
                            'label' => esc_html__( 'Priority', 'electro'),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 5,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_611a24e3852c1',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 0,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_611a2a4adf7cd',
                    'label' => esc_html__( 'Slider With Ads', 'electro' ),
                    'name' => 'slider_with_ads',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_611a2a4adf7ce',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_611a2a4adf7cf',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 10,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_611a2a4adf7d0',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_611a4b92c0cfd',
                    'label' => esc_html__( 'Sidebar With Products', 'electro' ),
                    'name' => 'sidebar_with_products',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_611a4b92c0cfe',
                            'label' => esc_html__( 'Animation', 'electro' ),
                            'name' => 'animation',
                            'type' => 'select',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'bounce' => 'bounce',
                                'flash' => 'flash',
                                'pulse' => 'pulse',
                                'rubberBand' => 'rubberBand',
                                'shake' => 'shake',
                                'swing' => 'swing',
                                'tada' => 'tada',
                                'wobble' => 'wobble',
                                'jello' => 'jello',
                                'bounceIn' => 'bounceIn',
                                'bounceInDown' => 'bounceInDown',
                                'bounceInLeft' => 'bounceInLeft',
                                'bounceInRight' => 'bounceInRight',
                                'bounceInUp' => 'bounceInUp',
                                'bounceOut' => 'bounceOut',
                                'bounceOutDown' => 'bounceOutDown',
                                'bounceOutLeft' => 'bounceOutLeft',
                                'bounceOutRight' => 'bounceOutRight',
                                'bounceOutUp' => 'bounceOutUp',
                                'fadeIn' => 'fadeIn',
                                'fadeInDown' => 'fadeInDown',
                                'fadeInDownBig' => 'fadeInDownBig',
                                'fadeInLeft' => 'fadeInLeft',
                                'fadeInLeftBig' => 'fadeInLeftBig',
                                'fadeInRight' => 'fadeInRight',
                                'fadeInRightBig' => 'fadeInRightBig',
                                'fadeInUp' => 'fadeInUp',
                                'fadeInUpBig' => 'fadeInUpBig',
                                'fadeOut' => 'fadeOut',
                                'fadeOutDown' => 'fadeOutDown',
                                'fadeOutDownBig' => 'fadeOutDownBig',
                                'fadeOutLeft' => 'fadeOutLeft',
                                'fadeOutLeftBig' => 'fadeOutLeftBig',
                                'fadeOutRight' => 'fadeOutRight',
                                'fadeOutRightBig' => 'fadeOutRightBig',
                                'fadeOutUp' => 'fadeOutUp',
                                'fadeOutUpBig' => 'fadeOutUpBig',
                                'flip' => 'flip',
                                'flipInX' => 'flipInX',
                                'flipInY' => 'flipInY',
                                'flipOutX' => 'flipOutX',
                                'flipOutY' => 'flipOutY',
                                'lightSpeedIn' => 'lightSpeedIn',
                                'lightSpeedOut' => 'lightSpeedOut',
                                'rotateIn' => 'rotateIn',
                                'rotateInDownLeft' => 'rotateInDownLeft',
                                'rotateInDownRight' => 'rotateInDownRight',
                                'rotateInUpLeft' => 'rotateInUpLeft',
                                'rotateInUpRight' => 'rotateInUpRight',
                                'rotateOut' => 'rotateOut',
                                'rotateOutDownLeft' => 'rotateOutDownLeft',
                                'rotateOutDownRight' => 'rotateOutDownRight',
                                'rotateOutUpLeft' => 'rotateOutUpLeft',
                                'rotateOutUpRight' => 'rotateOutUpRight',
                                'slideInUp' => 'slideInUp',
                                'slideInDown' => 'slideInDown',
                                'slideInLeft' => 'slideInLeft',
                                'slideInRight' => 'slideInRight',
                                'slideOutUp' => 'slideOutUp',
                                'slideOutDown' => 'slideOutDown',
                                'slideOutLeft' => 'slideOutLeft',
                                'slideOutRight' => 'slideOutRight',
                                'zoomIn' => 'zoomIn',
                                'zoomInDown' => 'zoomInDown',
                                'zoomInLeft' => 'zoomInLeft',
                                'zoomInRight' => 'zoomInRight',
                                'zoomInUp' => 'zoomInUp',
                                'zoomOut' => 'zoomOut',
                                'zoomOutDown' => 'zoomOutDown',
                                'zoomOutLeft' => 'zoomOutLeft',
                                'zoomOutRight' => 'zoomOutRight',
                                'zoomOutUp' => 'zoomOutUp',
                                'hinge' => 'hinge',
                                'rollIn' => 'rollIn',
                                'rollOut' => 'rollOut',
                            ),
                            'default_value' => false,
                            'allow_null' => 1,
                            'multiple' => 0,
                            'ui' => 1,
                            'ajax' => 0,
                            'return_format' => 'value',
                            'placeholder' => '',
                        ),
                        array(
                            'key' => 'field_611a4b92c0cff',
                            'label' => esc_html__( 'Priority', 'electro' ),
                            'name' => 'priority',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 20,
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'min' => '',
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_611a4b92c0d00',
                            'label' => esc_html__( 'Enabled ?', 'electro' ),
                            'name' => 'is_enabled',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 1,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_610bf77e03bcd',
            'label' => esc_html__( 'Slide With Ads', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_611a2a4adf7d0',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_611a015c3b3bd',
            'label' => esc_html__( 'Background Image', 'electro' ),
            'name' => 'homev10_slider_with_ads_bg_image',
            'type' => 'image',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'large',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_610bf804c88fc',
            'label' => esc_html__( 'Slider Shortcode', 'electro' ),
            'name' => 'home_v10_slider_shortcode',
            'type' => 'text',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_610bf88529ae8',
            'label' => esc_html__( 'Ads #1', 'electro' ),
            'name' => 'home_v10_ads_1',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_610bf8d87e29f',
                    'label' => esc_html__( 'Title', 'electro' ),
                    'name' => 'title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => wp_kses_post( 'Catch Big <strong>Deals</strong> on<br>The Consoles' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_610bf8e47e2a0',
                    'label' => esc_html__( 'Action Text', 'electro' ),
                    'name' => 'action_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => esc_html( 'Shop now' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_610bf8ef7e2a1',
                    'label' => esc_html__( 'Image', 'electro' ),
                    'name' => 'image',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_6119fdcba935f',
                    'label' => esc_html__( 'URL', 'electro' ),
                    'name' => 'url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_610bfad0f674f',
            'label' => esc_html__( 'Ads #2', 'electro' ),
            'name' => 'home_v10_ads_2',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_610bfad0f6750',
                    'label' => esc_html__( 'Title', 'electro' ),
                    'name' => 'title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => wp_kses_post( 'Catch Big <strong>Deals</strong> on<br>The Consoles' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_610bfad0f6751',
                    'label' => esc_html__( 'Action Text', 'electro' ),
                    'name' => 'action_text',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => esc_html( 'Shop now' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_610bfad0f6752',
                    'label' => esc_html__( 'Image', 'electro'),
                    'name' => 'image',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_6119fde2ebd03',
                    'label' => esc_html__( 'URL', 'electro' ),
                    'name' => 'url',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'https://#',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_611a6521e86a3',
            'label' => esc_html__( 'Sidebar With Products', 'electro' ),
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_611a4b92c0d00',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_6124bb598a3d5',
            'label' => esc_html__( 'Sidebar', 'electro' ),
            'name' => 'home_v10_sidebar',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_6124bb658a3d6',
                    'label' => esc_html__( 'Enable ?', 'electro' ),
                    'name' => 'is_enabled',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 1,
                    'ui' => 1,
                    'ui_on_text' => esc_html__( 'Enable', 'electro' ),
                    'ui_off_text' => esc_html__( 'Disable', 'electro' ),
                ),
                array(
                    'key' => 'field_6124b9047a952',
                    'label' => esc_html__( 'Menu Title', 'electro' ),
                    'name' => 'menu_title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_6124bb658a3d6',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => esc_html( 'Assortment' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_611b4fa695c59',
            'label' => esc_html__( 'Products', 'electro' ),
            'name' => 'home_v10_products',
            'type' => 'group',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_611bb71f02628',
                    'label' => esc_html__( 'Section Title', 'electro' ),
                    'name' => 'section_title',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => esc_html( 'Hot Products Today' ),
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_611b50bf1224a',
                    'label' => esc_html__( 'Products Content', 'electro' ),
                    'name' => 'content',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent_products' => esc_html__( 'Recent Products', 'electro'),
                        'featured_products' => esc_html__( 'Featured Products', 'electro' ),
                        'sale_products' => esc_html__( 'Sale Products', 'electro' ),
                        'best_selling_products' => esc_html__( 'Best Selling Products', 'electro' ),
                        'top_rated_products' => esc_html__( 'Top Rated products', 'electro' ),
                        'products' => esc_html__( 'Products', 'electro' ),
                    ),
                    'default_value' => 'recent_products',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_611cfe7075c49',
                    'label' => esc_html__( 'Choose Products', 'electro' ),
                    'name' => 'ids',
                    'type' => 'relationship',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_611b50bf1224a',
                                'operator' => '==',
                                'value' => 'products',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'post_type' => array(
                        0 => 'product',
                    ),
                    'taxonomy' => '',
                    'filters' => array(
                        0 => 'search',
                        1 => 'post_type',
                        2 => 'taxonomy',
                    ),
                    'elements' => array(
                        0 => 'featured_image',
                    ),
                    'min' => '',
                    'max' => '',
                    'return_format' => 'id',
                ),
                array(
                    'key' => 'field_611b51c9ed499',
                    'label' => esc_html__( 'Products Per Page', 'electro' ),
                    'name' => 'limit',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 15,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_611b4fe095c5a',
                    'label' => esc_html__( 'Wide Column', 'electro' ),
                    'name' => 'wide_column',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 2,
                    'max' => 5,
                    'step' => '',
                ),
                array(
                    'key' => 'field_611b51f7ed49a',
                    'label' => esc_html__( 'Columns', 'electro' ),
                    'name' => 'columns',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 1,
                    'max' => 6,
                    'step' => '',
                ),
                array(
                    'key' => 'field_611b522902739',
                    'label' => esc_html__( 'Orderby', 'electro' ),
                    'name' => 'orderby',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'date' => 'Date',
                        'id' => 'Id',
                        'menu_order' => 'Menu Order',
                        'popularity' => 'Popularity',
                        'rand' => 'Rand',
                        'rating' => 'Rating',
                        'title' => 'Title',
                    ),
                    'default_value' => 'date',
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 1,
                    'ajax' => 0,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_611b52f3467fc',
                    'label' => esc_html__( 'Order', 'electro' ),
                    'name' => 'order',
                    'type' => 'radio',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'ASC' => 'ASC',
                        'DESC' => 'DESC',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'default_value' => 'ASC',
                    'layout' => 'vertical',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_611d0be4ed41c',
                    'label' => esc_html__( 'Pagination ?', 'electro' ),
                    'name' => 'is_pagination_enabled',
                    'type' => 'true_false',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 1,
                    'ui' => 1,
                    'ui_on_text' => esc_html__( 'Enable', 'electro' ),
                    'ui_off_text' => esc_html__( 'Disable', 'electro' ),
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'page',
            ),
            array(
                'param' => 'post_template',
                'operator' => '==',
                'value' => 'template-homepage-v10.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
));  