<?php
/*
Plugin Name: Kingdom - Visual Composer Addon
Plugin URI: http://www.aa-team.com
Description: Extend Visual Composer with Kingdom theme shortcodes.
Version: 1.3
Author: AA-Team
Author URI: http://www.aa-team.com
License: GPLv2 or later
*/


// don't load directly
if (!defined('ABSPATH')) die('-1');

class VCExtendAddonClass {
	
	public $updater_dev = null;
	public $pluginName = 'js-composer-extend-kingdom';

    function __construct() {

    	if( defined('UPDATER_DEV') ) {
			$this->updater_dev = (string) UPDATER_DEV;
		}
		
        // We safely integrate with VC with this hook
        add_action( 'init', array( $this, 'integrateWithVC' ) );
		
		// Ajax Request
		add_action( 'wp_ajax_kd_amz_today_deals', array($this, 'ajax_request') );
		add_action( 'wp_ajax_nopriv_kd_amz_today_deals', array($this, 'ajax_request') );
		
        // Use this when creating a shortcode addon
        add_shortcode( 'vc_kingdom_blog_slideshow', array( $this, 'kingdom_blog_slideshow') );
		add_shortcode( 'vc_kingdom_box_headline', array( $this, 'kingdom_box_headline') );
		add_shortcode( 'vc_kingdom_fancy_heading', array( $this, 'kingdom_fancy_heading') );
		add_shortcode( 'vc_kingdom_amazon_top_deals', array( $this, 'kingdom_amazon_top_deals') );

        // Register CSS and JS
        add_action( 'wp_enqueue_scripts', array( $this, 'loadCssAndJs' ) );

        // product updater
		add_action( 'admin_init', array($this, 'product_updater') );
    }

    /**
	 * Gets updater instance.
	 *
	 * @return AATeam_Product_Updater
	 */
	public function product_updater() {
		require_once( 'assets/class-updater.php' );
		
		if( class_exists('Kingdom_AATeam_Product_Updater') ){
			$product_data = get_plugin_data( __FILE__, false ); 
			new Kingdom_AATeam_Product_Updater( $this, $product_data['Version'], 'js-composer-extend-kingdom', 'js-composer-extend-kingdom/vc_extend.php' );
		}
	}
	
	public function ajax_request()
	{
		global $wpdb;
		
		$html = array();
		
		$sub_action = isset($_REQUEST['sub_action']) && in_array($_REQUEST['sub_action'], array('kd_amz_update_today_deals', 'kd_amz_get_today_deals')) ? $_REQUEST['sub_action'] : '';
		
		if( $sub_action === 'kd_amz_update_today_deals' ) {
			
			// Check cache
			$last_cache_time = get_option('kd_amazon_td_last_cache_time');
			$db_cache_time = get_theme_mod('kd_amazon_cache_lifetime');
			if( !isset($db_cache_time) || trim($db_cache_time) == '' ) {
				$db_cache_time = 86400; // 24 hours (default)
			}else{
				$db_cache_time = $db_cache_time * 60 * 60;
			}
			  
			if( (time() - $last_cache_time ) >= $db_cache_time ) {
				if( $this->get_fresh_deals_data() ) {
					update_option( 'kd_amazon_td_last_cache_time', time() );
				}
				
				die('CACHED');
			}else{
				die('FROM CACHE');
			}
		}
		
		if( $sub_action == 'kd_amz_get_today_deals' ) {
			$params = isset($_REQUEST['params']) ? $_REQUEST['params'] : array();
			  
			if( count($params) > 0 ) {
				
				$aff_id = function_exists( 'WooZone' ) && isset(WooZone()->amz_settings['AffiliateID']['com']) ? WooZone()->amz_settings['AffiliateID']['com'] : 'INVALID_COM_AFFILIATE_ID';
							
				$sql = array();
				$sql_params = array();
				$sql[] = "SELECT * FROM `" . $wpdb->prefix . "amazon_today_deals` WHERE 1=1";
				if( trim($params['query_string']) != '' ) {
					$sql[] = "AND title LIKE '%s'";
					$sql_params[] = '%' . $params['query_string'] . '%';
				}
	
				if( $params['ignore_empty_price'] == 'yes' ) {
					$sql[] = "AND list_price > 0";
				}
				
				if( $params['save_percent'] > 0 ) {
					$sql[] = "AND save_percent >= %d";
					$sql_params[] = $params['save_percent'];
				}
				
				$sql[] = "ORDER BY " . esc_sql($params['order_by']) . " " . esc_sql($params['order_type']);
				
				$sql[] = "LIMIT %d";
				$sql_params[] = $params['per_page'];
				
				$sql = implode(' ', $sql);
				$sql = $wpdb->prepare( $sql, $sql_params);  
				$deals = $wpdb->get_results($sql, ARRAY_A);
				
				$c = 1;
				
				// Calculate column size  
				if( $params['list_type'] == 'list' ) {
					$params['kd_display_columns'] = $params['kd_display_columns_list'];
				}else if ( $params['list_type'] == 'grid' ) {
					$params['kd_display_columns'] = $params['kd_display_columns_grid'];
				}
				$columns = (int) round(((int) 12 / (int) $params['kd_display_columns']));
				
				if( count($deals) > 0 ) {
					
					if( $params['slider'] == 'yes' ) {
						$html[] = '<div class="kd_owl_today_offers">';
					}
						
					foreach( $deals as $deal ) {
						
						$deal['link'] = str_replace('&tag=rssfeeds-20', '&tag=' . $aff_id, $deal['link']);
						
						if( $params['slider'] == 'no' ) {
							$c = $c <= $params['kd_display_columns'] ? $c : 1;
							$html[] = $c == 1 ? '<div class="row">' : '';
							$html[] = '<div class="col-lg-' . ( $columns ) . ' col-md-4 col-sm-1">';
						}
						
						
						$html[] = '<div class="kd_product_offer_wrapper ' . ( $params['list_type'] == 'grid' ? 'kd_product_offer_grid' : '') . '">';
						if( isset($deal['img_url']) && trim($deal['img_url']) != '' ) {
							$html[] = '<div class="kd_prod_img"><a href="' . ( $deal['link'] ) . '" target="_blank"><span>' . __('View details', 'vc_extend') . '</span><img src="' . ( $deal['img_url'] ) . '"/></a></div>';
						}
						
						if( $params['list_type'] == 'grid' ) {
							$html[] = '<div class="kd_product_offer_info_wrapper">';
						}
						
						$html[] = '<h3><a href="' . ( $deal['link'] ) . '">' . ( trim(str_ireplace('deal of the day:', '', $deal['title'])) ) . '</a></h3>';
						
						if( $params['short_description'] == 'yes' ) {
							$html[] = '<p>' . ( $deal['short_description'] ) . '</p>';
						}
						
						if( isset($deal['deal_price']) && $deal['deal_price'] > 0 ) {
							$html[] = '<span class="kd_deal_price">$' . ( $deal['deal_price'] ) . '</span>';
						}
						
						if( isset($deal['list_price']) && $deal['list_price'] > 0 ) {
							$html[] = '<span class="kd_list_price">' . __('Price:', 'vc_extend') . ' $' . ( $deal['list_price'] );
							
							if( isset($deal['save_percent']) && $deal['save_percent'] > 0 ) {
								$html[] = '(' . $deal['save_percent'] . '% ' . __('off', 'vc_extend') . ')';
							}
							
							$html[] = '</span>';
						}
						
						if( stristr($deal['title'], 'deal of the day') !== false ) {
							$html[] = '<span class="kd_deal_of_the_day">';
							$html[] = __('DEAL OF THE DAY', 'vc_extend');
							$html[] = '</span>';
						}
						
						$html[] = '<div class="kd_expire_time_wrapper">';
						$html[] = 	'<div id="kd_offer_expire_time">' . $deal['expires'] . '</div>';
						$html[] = 	'<div class="kd_timer_legend">';
						$html[] = 		'<span class="kd_days">' . __('days', 'vc_extend') . '</span>';
						$html[] = 		'<span class="kd_hours">' . __('hours', 'vc_extend') . '</span>';
						$html[] = 		'<span class="kd_minutes">' . __('minutes', 'vc_extend') . '</span>';
						$html[] = 		'<span class="kd_secobds">' . __('seconds', 'vc_extend') . '</span>';
						$html[] = 	'</div>';
						$html[] = '</div>';
						
						if( $params['list_type'] == 'grid' ) {
							$html[] = '</div>';
						}
						
						$html[] = '</div>';
						
						if( $params['slider'] == 'no' ) {
							$html[] = '</div>';
							$html[] = $c == $params['kd_display_columns'] ? '</div>' : '';
							$c++;
						}
					}
		
					if( $params['slider'] == 'yes' ) {
						$html[] = '</div>';
					}
					
				}else{
					
					$html[] = __('<h3>No deals available for the moment.</h3>', 'vc_extend');
					
				}
			}
		
			die( implode("\n", $html) );
		}
		
		die('INVALID ACTION !');
	}

    public function integrateWithVC() 
    {
        // Check if Visual Composer is installed
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            // Display notice that Visual Compser is required
            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
            return;
        }

        /*
        Add your Visual Composer logic here.
        Lets call vc_map function to "register" our custom shortcode within Visual Composer interface.

        More info: http://kb.wpbakery.com/index.php?title=Vc_map
        */

        vc_add_shortcode_param( 'html_description', 'html_description_settings_field' );
		function html_description_settings_field( $settings, $value ) {
		   return '<div class="html_description_block">' . ( $value ) . '</div>'; // This is html markup that will be outputted in content elements edit form
		}
		
		vc_map( array(
            "name" => __("Kingdom Headline", 'vc_extend'),
            "description" => __("Kingdom Headline", 'vc_extend'),
            "base" => "vc_kingdom_box_headline",
            "class" => "",
            "controls" => "full",
            "icon" => plugins_url('assets/kingdom-vc-icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
            "category" => __('Kingdom', 'js_composer'),
            //'admin_enqueue_js' => array(plugins_url('assets/vc_extend.js', __FILE__)), // This will load js file in the VC backend editor
            //'admin_enqueue_css' => array(plugins_url('assets/vc_extend_admin.css', __FILE__)), // This will load css file in the VC backend editor
            "params" => array(
              array(
                  "type" => "textfield",
                  "holder" => "",
                  "class" => "",
                  "heading" => __("Headline Title", 'vc_extend'),
                  "param_name" => "kingdom_headline_title",
                  "value" => __("", 'vc_extend'),
                  "std"         => 'Headline goes here',
                  "description" => __("Kingdom Headline Title", 'vc_extend')
              ),
            )
        ) );

		vc_map( array(
            "name" => __("Kingdom Blog Slideshow", 'vc_extend'),
            "description" => __("Kingdom Blog Slideshow", 'vc_extend'),
            "base" => "vc_kingdom_blog_slideshow",
            "class" => "",
            "controls" => "full",
            "icon" => plugins_url('assets/kingdom-vc-icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
            "category" => __('Kingdom', 'js_composer'),
            //'admin_enqueue_js' => array(plugins_url('assets/vc_extend.js', __FILE__)), // This will load js file in the VC backend editor
            //'admin_enqueue_css' => array(plugins_url('assets/vc_extend_admin.css', __FILE__)), // This will load css file in the VC backend editor
            "params" => array(
              array(
			      "type"        => "dropdown",
			      "heading"     => __("Blog columns number"),
			      "param_name"  => "blog_columms_no",
			      "admin_label" => true,
			      "value"       => array(
			        '1 column'   => '1',
			        '2 columns'   => '2',
			        '3 columns'   => '3',
			        '4 columns'   => '4',
			      ),
			      "std"         => '1',
			      "description" => __("Blog columns number")
		      ),
			  
              array(
                  "type" => "textfield",
                  "holder" => "",
                  "class" => "",
                  "heading" => __("Blog posts per page", 'vc_extend'),
                  "param_name" => "per_page",
                  "value" => __("", 'vc_extend'),
                  "std"         => '10',
                  "description" => __("Blog posts per page", 'vc_extend')
              ),
              
			  array(
			      "type"        => "dropdown",
			      "heading"     => __("Order Blog Posts By"),
			      "param_name"  => "orderby",
			      "admin_label" => true,
			      "value"       => array(
				        'post_date'   => 'post_date',
				        'ID'   => 'ID',
				        'author'   => 'author',
				        'title'   => 'title',
				        'name'   => 'name',
				        'menu_order'   => 'menu_order',
			      ),
			      "std"         => 'post_date',
			      "description" => __("")
		      ),
		      
            )
        ) );
		
		vc_map( array(
            "name" => __("Kingdom Fancy Heading", 'vc_extend'),
            "description" => __("Kingdom Fancy Heading", 'vc_extend'),
            "base" => "vc_kingdom_fancy_heading",
            "class" => "",
            "controls" => "full",
            "icon" => plugins_url('assets/kingdom-vc-icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
            "category" => __('Kingdom', 'js_composer'),
            //'admin_enqueue_js' => array(plugins_url('assets/vc_extend.js', __FILE__)), // This will load js file in the VC backend editor
            //'admin_enqueue_css' => array(plugins_url('assets/vc_extend_admin.css', __FILE__)), // This will load css file in the VC backend editor
            "params" => array(
            	array(
			      "type"        => "dropdown",
			      "heading"     => __("Fancy Heading Icon"),
			      "param_name"  => "fancy_heading_icon",
			      "admin_label" => true,
			      "value"       => array(
			        'yes'   => 'yes',
			        'no'   => 'no',
			      ),
			      "std"         => 'no',
			      "description" => __("Display heading icon")
		      ),

		      array(
			      "type"        => "dropdown",
			      "heading"     => __("Fancy Heading Style"),
			      "param_name"  => "fancy_heading_style",
			      "admin_label" => true,
			      "value"       => array(
			        'Style 1'   => 'Style 1',
			        'Style 2'   => 'Style 2',
			        'Style 3'   => 'Style 3',
			      ),
			      "std"         => 'Style 1',
			      "description" => __("Fancy heading style")
		      ),

		      array(
			      "type"        => "dropdown",
			      "heading"     => __("Fancy Heading Icon Type"),
			      "param_name"  => "fancy_heading_icon_type",
			      "admin_label" => true,
			      "value"       => array(
			        'font awesome'   => 'font awesome',
			        'manual upload'   => 'manual upload',
			      ),
			      "std"         => 'font awesome',
			      "description" => __("Fancy Heading Icon Type")
		      ),

		      array(
                  "type" => "iconpicker",
                  "holder" => "",
                  "class" => "",
                  "heading" => __("Fancy Heading Font Awesome Icon", 'vc_extend'),
                  "param_name" => "font_awesome_icon",
                  "value" => __("fa fa-html5", 'vc_extend'),
                  "description" => __("Fancy Heading Font Awesome Icon", 'vc_extend'),
              ),
              
			  array(
                  "type" => "attach_image",
                  "holder" => "",
                  "class" => "",
                  "heading" => __("Kingdom Fancy Heading Icon URL", 'vc_extend'),
                  "param_name" => "icon_url",
                  "description" => __("Kingdom Fancy Heading Icon URL", 'vc_extend')
              ),

			  array(
	              "type" => "textfield",
	              "holder" => "",
	              "class" => "",
	              "heading" => __("Title", 'vc_extend'),
	              "param_name" => "title",
	              "value" => __("Lorem ipsum", 'vc_extend'),
	              "description" => __("Kingdom Fancy Heading Title", 'vc_extend')
              ),

              array(
			      "type"        => "dropdown",
			      "heading"     => __("Text align"),
			      "param_name"  => "text_align",
			      "admin_label" => true,
			      "value"       => array(
			        'left'   => 'left',
			        'right'   => 'right',
			        'center'  => 'center',
			        'justify' => 'justify'
			      ),
			      "std"         => 'center',
			      "description" => __("Text Align")
		      ),
		    /*  
		      array(
	              "type" => "textfield",
	              "holder" => "",
	              "class" => "",
	              "heading" => __("Font Size (in px)", 'vc_extend'),
	              "param_name" => "font_size",
	              "value" => __("", 'vc_extend'),
	              "description" => __("Kingdom Fancy Heading Font Size", 'vc_extend')
              ),*/
            )
        ) );
        
		vc_map( array(
			"name" => __("Kingdom Amazon Top Deals", 'vc_extend'),
            "description" => __("Kingdom Amazon Top Deals", 'vc_extend'),
            "base" => "vc_kingdom_amazon_top_deals",
            "class" => "",
            "controls" => "full",
            "icon" => plugins_url('assets/kingdom-vc-icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
            "category" => __('Kingdom', 'js_composer'),
            //'admin_enqueue_js' => array(plugins_url('assets/vc_extend.js', __FILE__)), // This will load js file in the VC backend editor
            //'admin_enqueue_css' => array(plugins_url('assets/vc_extend_admin.css', __FILE__)), // This will load css file in the VC backend editor
            "params" => array(
				array(
					"type"=> "dropdown",
					"heading" => __("List type", 'vc_extend'),
					"param_name"=> "list_type",
					"admin_label" => true,
					"value" => array(
							__('List', 'vc_extend') => 'list',
							__('Grid', 'vc_extend') => 'grid',
					),
					"std" => 'list'
				),
				
				array(
					"type" => "textfield",
					"holder" => "",
					"class" => "",
					"heading" => __("Products per page", 'vc_extend'),
					"param_name" => "per_page",
					"value" => __("", 'vc_extend'),
					"std" => '12',
					"description" => __("How many products to show per page", 'vc_extend')
				),
				
				array(
					"type" => "dropdown",
					"holder" => "",
					"class" => "",
					"heading" => __("Columns per row", 'vc_extend'),
					"param_name" => "kd_display_columns_list",
					"value" => range(1,4),
					"std" => 4,
					"description" => __("How many columns per row do you want?", 'vc_extend'),
					"dependency" => array(
						'element' => 'list_type',
						'value' => array('list')
					)
				),
				
				array(
					"type" => "dropdown",
					"holder" => "",
					"class" => "",
					"heading" => __("Columns per row", 'vc_extend'),
					"param_name" => "kd_display_columns_grid",
					"value" => range(1,2),
					"std" => 2,
					"description" => __("How many columns per row do you want?", 'vc_extend'),
					"dependency" => array(
						'element' => 'list_type',
						'value' => array('grid')
					)
				),
				
				array(
					"type" => "textfield",
					"holder" => "",
					"class" => "",
					"heading" => __("Saved percent(%) from", 'vc_extend'),
					"param_name" => "save_percent",
					"value" => __("", 'vc_extend'),
					"std" => '',
					"description" => __("Show only products above this saved percent", 'vc_extend')
				),
				
				array(
					"type" => "textfield",
					"holder" => "",
					"class" => "",
					"heading" => __("Filter by title", 'vc_extend'),
					"param_name" => "query_string",
					"value" => __("", 'vc_extend'),
					"std" => '',
					"description" => __("Show only products that contains specific word(s)/characters in the title", 'vc_extend')
				),
				
				array(
					"type"=> "dropdown",
					"heading" => __("Slider", 'vc_extend'),
					"param_name"=> "slider",
					"admin_label" => true,
					"value" => array(
							__('NO', 'vc_extend') => 'no',
							__('YES', 'vc_extend') => 'yes'
					),
					"std" => 'no',
				),
				
				array(
					"type"=> "dropdown",
					"heading" => __("Order by", 'vc_extend'),
					"param_name"=> "order_by",
					"admin_label" => true,
					"value" => array(
							__('Title', 'vc_extend') 		=> 'title',
							__('List Price', 'vc_extend')	=> 'list_price',
							__('Deal Price', 'vc_extend')	=> 'deal_price',
							__('Save Percent', 'vc_extend')	=> 'save_percent',
							__('Expire Date', 'vc_extend')	=> 'expires',
							__('Offer Date', 'vc_extend')	=> 'date',
					),
					"std" => 'date',
					"description" => __("", 'vc_extend')
				),
				
				array(
					"type"=> "dropdown",
					"heading" => __("Order type", 'vc_extend'),
					"param_name"=> "order_type",
					"admin_label" => true,
					"value" => array(
							__('ASCENDING', 'vc_extend') => 'ASC',
							__('DESCENDING', 'vc_extend') => 'DESC'
					),
					"std" => 'DESC',
				),
				
				array(
					"type"=> "dropdown",
					"heading" => __("Ignore empty price", 'vc_extend'),
					"param_name"=> "ignore_empty_price",
					"admin_label" => true,
					"value" => array(
							__('NO', 'vc_extend') => 'no',
							__('YES', 'vc_extend') => 'yes'
					),
					"std" => 'yes',
					"description" => __("Show offers with empty listing price or not", 'vc_extend')
				),
				
				array(
					"type"=> "dropdown",
					"heading" => __("Short description", 'vc_extend'),
					"param_name"=> "short_description",
					"admin_label" => true,
					"value" => array(
							__('NO', 'vc_extend') => 'no',
							__('YES', 'vc_extend') => 'yes'
					),
					"std" => 'no',
				),
            )
        ) );

    }

	public function kingdom_box_headline( $atts, $content )
	{
		extract( shortcode_atts( array(
			'class'	=> 'kd_featured',
			'kingdom_headline_title' => 'Headline goes here'
			), $atts ) );
 
			return 
				'<div class="' . ( $class ) . '">
				<h1>' . ( strip_tags( $kingdom_headline_title ) ) . '</h1>
			</div>';
	}

	public function kingdom_blog_slideshow( $atts, $content )
	{
		global $kingdom; 
	
		$html = array();
			
		extract( shortcode_atts( array(
			'per_page' 	=> '10',
			'orderby' => 'post_date',
			'blog_columms_no' => 1
		), $atts ) );
		
		$args = array(
		    'numberposts' => (int)$per_page,
		    'orderby' => 'post_date',
		    'order' => 'DESC',
		    'post_type' => 'post',
		    'post_status' => 'publish',
		    'suppress_filters' => true 
		);
	
	    $recent_posts = wp_get_recent_posts( $args, ARRAY_A );
		if( count($recent_posts) > 0 ){
			$item_bs_class = '';
			if( $blog_columms_no == 1 ) {
				$item_bs_class = ' col-lg-12 ';
			} elseif(  $blog_columms_no == 2 ) {
				$item_bs_class = ' col-lg-6 col-md-6 col-sm-6 col-xs-12 kd-hp-blogpost ';
			} elseif( $blog_columms_no == 3 ) {
				$item_bs_class = ' col-lg-4 col-md-4 col-sm-6 col-xs-12 kd-hp-blogpost';
			} elseif( $blog_columms_no == 4 ) {
				$item_bs_class = ' col-lg-3 col-md-3 col-sm-6 col-xs-12 kd-hp-blogpost';
			}
			$html[] = '<div id="kd_blog_slider" data-columns="' . $blog_columms_no . '">';
				$html[] = '<div class="row">';
					foreach ($recent_posts as $post) {
						
						$post_link = get_permalink( $post['ID'] );
						$post_thumbnail_id = get_post_thumbnail_id( $post['ID'] );
						$thumb = wp_get_attachment_image_src( $post_thumbnail_id, array(250,250) );
						
						$html[] = '<div class="kd-blog-item ' . $item_bs_class . '">';
						
						if( $thumb != false ){
							if( $blog_columms_no == 1 ) {
								$html[] = 	'<div class="col-lg-3 col-md-3 col-sm-5 col-xs-12 kd_blog_slider_img">';	
							} else {
								$html[] = 	'<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 kd_blog_slider_img">';
							}
									$html[] = 		'<a href="' . ( $post_link ) . '"><img src="' . ( $thumb[0] ) . '" alt="image"/></a>';
								$html[] = 	'</div>';
							if( $blog_columms_no == 1 ) {
								$html[] = 	'<div class="col-lg-9 col-md-9 col-sm-7 col-xs-12">';
							} else {
								$html[] = 	'<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">';
							}
						}
						else{
							$html[] = 	'<div class="col-lg-12">';
						}
						
						$html[] = 		'<h2><a href="' . ( $post_link ) . '">' . ( $post['post_title'] ) . '</a></h2>';
						$html[] = 		'<p>';
						$html[] = 			'<span>'.get_the_date( null, $post['ID'] ). ' / ' .get_comments_number( $post['ID'] ).' '.__('Comments', 'kingdom').'</span>';
						$html[] = 		'</p>';
						$html[] = 		'<p>';
						//wpautop
						$html[] = 			( $kingdom->coreFunctions->shorten_string( strip_tags($post['post_content']) , 300));
						$html[] = 		'</p>';
						$html[] = 		'<a href="' . ( $post_link ) . '"> '.__('Read More', 'kingdom').' + </a>';
						$html[] = 	'</div>';
						$html[] = '</div>';
					}
				$html[] = '</div>';
			$html[] = '</div>';
		}
		
		return implode("\n", $html);
	}

	/* kingdom Fancy heading */
	public function kingdom_fancy_heading( $atts, $content = null )
	{
		extract( shortcode_atts( array(
			'fancy_heading_icon'	=> 'no',
			'fancy_heading_style'	=> 'Style 1',
			'fancy_heading_icon_type' => 'font awesome',
			'font_awesome_icon' => 'fa fa-asterisk',
			'icon_url' => '',
			'title' => 'Lorem Ipsum',
			'text_align' => 'center',
			'font_size' => ''
		), $atts ) );
		$icon_img = '';
		$fa_icon = '';
		
		if( $fancy_heading_icon == 'yes' ) {
			if( $fancy_heading_icon_type == 'manual uploads' ) {
				if( isset( $icon_url ) ) {
					$icon = wp_get_attachment_image_src( $icon_url, "full" );
		        	$icon = $icon[0];
					$icon_img = '<p class="fancy-heading-icon"><img src="'. $icon .'" alt="'. $title .'" /></p>';
				}
			} elseif( $fancy_heading_icon_type == 'font awesome' ) {
				if( isset( $font_awesome_icon ) ) {
					$fa_icon = '<p class="fancy-heading-icon"><i class="' . $font_awesome_icon . '"></i></p>';
				}
			} 

		}

		if( $fancy_heading_style == 'Style 1' ) {
			$fancy_heading_style_class = 'style-1';
		} elseif( $fancy_heading_style == 'Style 2' ) {
			$fancy_heading_style_class = 'style-2';
		} elseif( $fancy_heading_style == 'Style 3' ) {
			$fancy_heading_style_class = 'style-3';
		}
		
		$fss = '';
		
		if( isset( $font_size ) && $font_size != '' ) {
			$fss = ' font-size: ' . $font_size . '; ';
		}

		return '<h1 style="' . $fss . ' text-align: ' . $text_align . ';" class="kd-fancy-heading ' . $fancy_heading_style_class . '">' . $title . $icon_img . $fa_icon . '</h1>';
	}

	public function kingdom_get_top_deals()
	{
		$_get_top_deals = wp_remote_get('http://rssfeeds.s3.amazonaws.com/goldbox', array('timeout' => 15));  
		
		if( is_array($_get_top_deals) ) {
			$get_top_deals = $_get_top_deals['body']; // use the content
			
			$xml = simplexml_load_string($get_top_deals);
			$json = json_encode($xml);
			$top_deals = json_decode($json,TRUE);
			
			return $top_deals;  
		}
	}
	
	public function kingdom_parse_deal( $html )
	{
		$tmp_parsed_html = array();
		$parsed_html = array();
		
		preg_match("/<img src=\"(.*?)\"[^>]*\/>/i", $html, $tmp_parsed_html['img_url']);
		preg_match("/<td>List Price: <strike>(.*?)<\/strike><\/td>/i", $html, $tmp_parsed_html['list_price']);
		preg_match("/<td><b>Deal Price: (.*?)<\/b><\/td>/i", $html, $tmp_parsed_html['deal_price']);
		preg_match("/<td>You Save: (.*?)<\/td>/i", $html, $tmp_parsed_html['save_price']);
		preg_match("/<td>Expires (.*?)<\/td>/i", $html, $tmp_parsed_html['expires']);
		preg_match_all("/<td>(.*?)<\/td>/i", $html, $tmp_parsed_html['description']);
		
		foreach( $tmp_parsed_html as $key => $parse ) {
			if( $key == 'description' ) {  
				$parsed_html[$key] = $parse[1][(count($parse[1]) - 2)];
			}else{
				$parsed_html[$key] = end($parse);
			}
		}
		
		return $parsed_html;
	}
	
	public function get_fresh_deals_data()
	{
		global $wpdb;
		
		$_tmp = $this->kingdom_get_top_deals();
		
		if( isset($_tmp['channel']) && isset($_tmp['channel']['item']) ) {
			
			$wpdb->query("TRUNCATE `" . $wpdb->prefix . "amazon_today_deals`;");
			$insert_product = array();
			
			foreach($_tmp['channel']["item"] as $item ) {
				$parsed_data = $this->kingdom_parse_deal( $item['description'] );
				$save_percent = '';
				if( isset($parsed_data['save_price']) && $parsed_data['save_price'] != '' ) {
					preg_match('/\((.*?)\)/i', $parsed_data['save_price'], $_save_percent);
					if( count($_save_percent) > 0 ) {
						$save_percent = str_replace('%', '', end($_save_percent));
					}
				}
				    
				$data = array(
					'title' => $item['title'],
					'link' => $item['link'],
					'short_description' => strip_tags($parsed_data['description']),
					'img_url' => $parsed_data['img_url'],
					'list_price' => str_replace('$', '', $parsed_data['list_price']),
					'deal_price' => str_replace('$', '', $parsed_data['deal_price']),
					'save_percent' => $save_percent,
					'expires' => date('Y-m-d H:i:s', strtotime($parsed_data['expires'])),
					'date' => date('Y-m-d H:i:s', strtotime($item['pubDate'])),
				);
				
				$wpdb->insert( $wpdb->prefix . 'amazon_today_deals', $data );
				$insert_product[] = $wpdb->insert_id;
			}

			if( count($insert_product) > 0 ) {
				return true;
			}
		}

		return false;
	}

	/* kingdom Amazon Top Deals */
	public function kingdom_amazon_top_deals( $atts, $content = null )
	{
		global $wpdb;
		
		extract( shortcode_atts( array(
			'list_type'		=> 'list',
			'per_page'		=> 12,
			'kd_display_columns_list' => 3,
			'kd_display_columns_grid' => 2,
			'save_percent'	=> '',
			'slider'		=> 'no',
			'query_string'	=> '',
			'order_by'		=> 'date',
			'order_type'	=> 'DESC',
			'ignore_empty_price'	=> 'yes',
			'short_description'		=> 'no',
		), $atts ) );
		
		$html = array();
		 
		$html[] = '<div class="kd_amz_today_deals"';
		$html[] = ' data-list_type="' . ( $list_type ) . '"';
		$html[] = ' data-per_page="' . ( $per_page ) . '"';
		$html[] = ' data-kd_display_columns_list="' . ( $kd_display_columns_list ) . '"';
		$html[] = ' data-kd_display_columns_grid="' . ( $kd_display_columns_grid ) . '"';
		$html[] = ' data-save_percent="' . ( $save_percent ) . '"';
		$html[] = ' data-slider="' . ( $slider ) . '"';
		$html[] = ' data-query_string="' . ( $query_string ) . '"';
		$html[] = ' data-order_by="' . ( $order_by ) . '"';
		$html[] = ' data-order_type="' . ( $order_type ) . '"';
		$html[] = ' data-ignore_empty_price="' . ( $ignore_empty_price ) . '"';
		$html[] = ' data-short_description="' . ( $short_description ) . '"';
		$html[] = '><img src="' . ( get_stylesheet_directory_uri() ) . '/images/topdeals-loader.gif" width="270" height="233" class="loader" alt="' . __('Loading...', 'vc_extent') . '"/></div>';
		
		return implode("\n", $html);
	}
	
    /*
    Load plugin css and javascript files which you may need on front end of your site
    */
    public function loadCssAndJs() {
      wp_register_style( 'vc_extend_style', plugins_url('assets/vc_extend.css', __FILE__) );
      wp_enqueue_style( 'vc_extend_style' );

      // If you need any javascript files on front end, here is how you can load them.
      wp_enqueue_script( 'vc_extend_js', plugins_url('assets/vc_extend.js', __FILE__), array('jquery') );
	  wp_localize_script( 'vc_extend_js', 'kd_js_params', array('ajax_url' => admin_url('admin-ajax.php')) );
    }

    /*
    Show notice if your plugin is activated but Visual Composer is not
    */
    public function showVcVersionNotice() {
        $plugin_data = get_plugin_data(__FILE__);
        echo '
        <div class="updated">
          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="http://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'vc_extend'), $plugin_data['Name']).'</p>
        </div>';
    }

}
// Finally initialize code
new VCExtendAddonClass();