function kd_initOfferTimer(expire_time) {
	// Set the date we're counting down to
	var countDownDate = new Date(expire_time.text()).getTime();
	 
	// Update the count down every 1 second
	var x = setInterval(function() {
	
	  // Get todays date and time
	  var now = new Date().getTime();
	
	  // Find the distance between now an the count down date
	  var distance = countDownDate - now;
	
	  // Time calculations for days, hours, minutes and seconds
	  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
	  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
	  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
	  var seconds = Math.floor((distance % (1000 * 60)) / 1000);
	
	  // Display the result in the element with id="demo"
	  var days_html = '';
	  if( days == '0' ) {
	  	$(expire_time).parent().find('.kd_days').remove();
	  }else{
	  	days_html = '<span>' + days + '</span> <span class="sep">&nbsp;</span> ';
	  }
	  $(expire_time).html( days_html + '<span>' + hours + '</span> <span class="sep">&nbsp;</span> <span>' + minutes + '</span> <span class="sep">&nbsp;</span> <span>' + seconds + '</span>');
	
	  // If the count down is finished, write some text 
	  if (distance < 0) {
		clearInterval(x);
		$(expire_time).html("<span>EXPIRED</span>");
		$(expire_time).parent().find('.kd_timer_legend').remove();
	  }
	}, 1000);
}

function kd_amazon_update_today_deals(that, params) {
	$.ajax({
		url: kd_js_params.ajax_url,
		method: "POST",
		data: {
			action: 'kd_amz_today_deals',
			sub_action: 'kd_amz_update_today_deals',
		},
		cache: false,
		success: function(resp) {
			
			$('.kd_amz_today_deals').each(function() {
				var that = $(this),
					params = {
						list_type: that.data('list_type'),
						per_page: that.data('per_page'),
						kd_display_columns_list: that.data('kd_display_columns_list'),
						kd_display_columns_grid: that.data('kd_display_columns_grid'),
						save_percent: that.data('save_percent'),
						slider: that.data('slider'),
						query_string: that.data('query_string'),
						order_by: that.data('order_by'),
						order_type: that.data('order_type'),
						ignore_empty_price: that.data('ignore_empty_price'),
						short_description: that.data('short_description')
					};
				
				kd_amazon_get_today_deals(that, params); 
			});
			
		}
	});
}

function kd_amazon_get_today_deals(that, params) {
	
	$.ajax({
		url: kd_js_params.ajax_url,
		method: "POST",
		data: {
			action: 'kd_amz_today_deals',
			sub_action: 'kd_amz_get_today_deals',
			params: params
		},
		dataType: "html",
		cache: false,
		success: function(resp) {
			
			that.html( resp );
			
			that.find('.kd_product_offer_wrapper').each(function() {
				kd_initOfferTimer( $(this).find('#kd_offer_expire_time') );
			});
			
			if( params.slider == 'yes') {
				$('.kd_owl_today_offers').each(function() {
					$(this).owlCarousel({
						navigation : true,
						pagination : false,
						items : params.list_type == 'list' ? params.kd_display_columns_list : params.kd_display_columns_grid,
						itemsDesktop : [1199,4],
						itemsDesktopSmall : [1024,2],
						itemsTablet: [768,2],
						itemsTabletSmall: false,
						itemsMobile : [479,1],
						navigationText: ["<i class='micon icon-arrow-left6'></i>", "<i class='micon icon-arrow-right6'></i>"],
					});
				});
			}
			
		}
	});
	
}

(function ($) {
	$(document).ready(function() {
		kd_amazon_update_today_deals(); 
	});
})(jQuery);