<?php
/*
 * Define class CSB_Settings
 * Make sure you skip down to the end of this file, as there are a few
 * lines of code that are very important.
 */
!defined('ABSPATH') and exit;

if (class_exists('CSB_Settings') != true) {
    
    class CSB_Settings
    {
        /*
         * Some required plugin information
         */
        const VERSION = '1.0';
		
		private $save_status = false;
        
        /*
         * Required __construct() function that initalizes the CSB_Settings
         */
        public function __construct()
        {
        	$this->save_settings();
        }
		
		private function save_settings()
		{
			$form_saved = isset( $_REQUEST['csb-form-saved'] ) ? (boolean) $_REQUEST['csb-form-saved'] : false;
			$box_id = isset( $_REQUEST['box_id'] ) ? (string) $_REQUEST['box_id'] : '';
			if( $form_saved === true && trim($box_id) != "" ){
				$params = isset( $_REQUEST[$box_id] ) ? $_REQUEST[$box_id] : array();
				
				if( count($params) > 0 ){
					update_option( $box_id, $params );
					$this->save_status = true;
				} 
			}
		}
        
        /*
         * Build options, method
         * ---------------------
         * this will create you interface via options array elements
         */
        public function build_options($options = array(), $box_id = '', $show_form=true )
        {
            // reset as array, this will stock all the html content, and at the end return it
            $html = array();  
  
            if (count($options) == 0) {
                return 'Please fill with some options content first!';
            }

            $noRowElements = array(
                'message',
                'html',
                'tmdb-login',
                'app'
            );
            $settings      = array();
            
            // get the values from DB
            $settings = get_option( $box_id );
			
            if( $show_form == true ){
                $html[] = '<form method="POST" class="csb-form" id="' . ($box_id) . '" action="">';
            }
            
			//$html[] = '<div class="csb-message csb-success ' . ( $this->save_status == false ? 'csb-display-none' : '' ) . '">Saved successfully!</div>';
            // create a hidden input for sending the prefix
            $html[] = 	'<input type="hidden" name="box_id" value="' . ($box_id) . '" />';
			$html[] = 	'<input type="hidden" name="csb-form-saved" value="1" />';
            
            $box = isset($options) ? $options : array();
            $html[] = $this->tabs_header($box); // tabs html header
 
            // loop the box elements
            if (isset($options['elements']) && count($options['elements']) > 0) {
                
                // loop the box elements now
                foreach ($options['elements'] as $elm_id => $value) {
                    
                    // some helpers. Reset an each loop, prevent collision
                    $val          = '';
                    $select_value = '';
                    $checked      = '';
                    $option_name  = isset($option_name) ? $option_name : '';
                    
                    // Set default value to $val
                    if (isset($value['std'])) {
                        $val = $value['std'];
                    }
                   
                    // If the option is already saved, ovveride $val
                    if ( ( $value['type'] != 'info' ) ) {
                        if ( isset($settings[($elm_id)] )
                            && (
                                ( !is_array($settings[($elm_id)]) && @trim($settings[($elm_id)]) != "" )
                                ||
                                ( is_array($settings[($elm_id)]) /*&& !empty($settings[($elm_id)])*/ )
                            )
                        ) {
                                $val = $settings[( $elm_id )];

                                // Striping slashes of non-array options
                                if ( !is_array($val) ) {
                                    $val = stripslashes( $val );
                                    //if($val == '') $val = true;
                                }
                        }
                    }
                    
                    // If there is a description save it for labels
                    $explain_value = '';
                    if (isset($value['desc'])) {
                        $explain_value = $value['desc'];
                    }
                    
                    if (!in_array($value['type'], $noRowElements)) {
                        // the row and the label 
                        $html[] = '<div data-name="' . ($this->tabs_elements($box, $elm_id)) . '" data-own="' . ( $elm_id ) . '" class="csb-form-row ' . ($this->tabs_elements($box, $elm_id)) . '">
							   <label for="' . ($elm_id) . '"><span>' . (isset($value['title']) ? $value['title'] : '') . '</span><span class="csb-remove-attributes" title="Remove Property"><i class="csb-icon-reset"></i></span></label>
							   <div class="csb-form-item">';
                    }
                    
                    switch ($value['type']) {
                        
                        // Basic text input
                        case 'text':
                            $html[] = '<input ' . (isset($value['force_width']) ? "style='width:" . ($value['force_width']) . "px;'" : '') . ' id="' . esc_attr($elm_id) . '" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" type="text" value="' . esc_attr($val) . '" />';
                            break;
							
						// Wordpress color picker input
						case 'color_picker':
							$html[] = '<input class="csb-wp-color-picker" ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' id="' . esc_attr( $elm_id ) . '" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" type="text" value="' . esc_attr( $val ) . '" />';

                            $html[] = '<div class="csb-wp-color-picker-material"></div>';
						break;

                        // Basic checkbox input
                        case 'checkbox':
                            $html[] = '<input ' . (isset($value['force_width']) ? "style='width:" . ($value['force_width']) . "px;'" : '') . ' ' . ($val == true ? 'checked' : '') . ' id="' . esc_attr($elm_id) . '" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" type="checkbox" value="" />';
                            break;

                        case 'template_typography':
                            if( $value['options'] ){
                                $html[] = '<div class="csb-typo-wrapper">';
                                $google_fonts = csb()->getAllGfonts();

                                foreach ($value['options'] as $option_key => $option_value) {
                                    $html[] =   '<fieldset class="csb-typo-row">';
                                    $html[] =       '<legend class="csb-typo-title">' . ( $option_value['title'] ) . '</legend>';
                                    $html[] =       '<div class="csb-typo-font-family">';
                                    $html[] =           '<span>Font-family:</span>';
                                    $html[] =           '<select name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . '][' . ( $option_key ) . '][family]">';

                                    if( count($google_fonts) > 0 ){
                                        foreach ($google_fonts as $font_key => $font ) {
                                            $html[] = '<option value="' . ( $font_key ) . '" ' . ( isset($val[$option_key]['family']) && $val[$option_key]['family'] == $font ? 'selected' : '' ) . '>' . ( $font ) . '</option>';
                                        }
                                    }
                                    $html[] =           '</select>';
                                    $html[] =       '</div>';
                                    
                                    $html[] =       '<div class="csb-typo-font-size">';
                                    $html[] =           '<span>Font-size:</span>';
                                    $html[] =           '<select name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . '][' . ( $option_key ) . '][size]">';
                                    foreach ( range( 10, 34 ) as $size ) {
                                        $html[] =           '<option value="' . ( $size ) . '" ' . ( isset($val[$option_key]['size']) && $val[$option_key]['size'] == $size ? 'selected' : '' ) .'>' . ( $size ) . 'px</option>';
                                    }
                                    $html[] =            '</select>';
                                    $html[] =        '</div>';

                                    $html[] =       '<div class="csb-typo-font-weight">';
                                    $html[] =           '<span>Font-weight:</span>';
                                    $html[] =           '<select name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . '][' . ( $option_key ) . '][weight]">';
                                    foreach ( array('normal', 'bold') as $weight ) {
                                        $html[] =           '<option value="' . ( $weight ) . '" ' . ( isset($val[$option_key]['weight']) && $val[$option_key]['weight'] == $weight ? 'selected' : '' ) .'>' . ( $weight ) . '</option>';
                                    }
                                    $html[] =            '</select>';
                                    $html[] =        '</div>';

                                    $html[] =       '<div class="csb-typo-font-color">';
                                    $html[] =           '<span>Font-color:</span>';
                                    $html[] =           '<input class="csb-wp-color-picker-typo" data-alpha="true" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . '][' . ( $option_key ) . '][color]" type="text" value="' . ( isset($val[$option_key]['color']) ? $val[$option_key]['color'] : '#000') . '" />';
                                    $html[] =           '<div class="csb-wp-color-picker-wrapper"></div>';
                                    $html[] =        '</div>';
                                    $html[] =        '<div class="csb-typo-font-preview">The quick brown fox jumps over the lazy dog</div>';

                                    $html[] =   '</fieldset>';
                                }
                                $html[] = '</div>';
                            }
                        break;
                        
                        // Basic checkbox input
                        /*
                            array(
                                'type' => 'slider',
                                'options' => array(
                                    'min' => -100,
                                    'max' => 72,
                                    'def' => 15,
                                    'step' => 5,
                                    'units' => array(
                                        'px',
                                        '%',
                                        'em',
                                        'rem',
                                    )
                                ),
                                'title' => 'Primary Color:',
                                'desc' => 'Your template primary color'
                            )
                        */
                        case 'slider':
                            $html[] = '<div class="csb-slider-wrapper">';
                            $html[] =   '<div class="csb-slider-container" data-min="' . ( $value['options']['min'] ) . '" data-max="' . ( $value['options']['max'] ) . '" data-def="' . ( $value['options']['def'] ) . '" data-step="' . ( $value['options']['step'] ) . '"></div>';
                            $html[] =   '<div class="csb-slider-manual">';
                            $html[] =       '<input data-type="slider" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" value="' . ( $value['options']['def'] ) . '" type="text" autocomplete="off">';
                            $html[] =       '<select class="csb_slider_size_selector">';

                            if( isset($value['options']['units']) && count($value['options']['units']) > 0 ){
                                foreach ($value['options']['units'] as $unit ) {
                                    $html[] =   '<option value="' . ( $unit ) . '">' . ( $unit ) . '</option>';
                                }
                            }
                            $html[] =       '</select>';
                            $html[] =   '</div>';
                            $html[] = '</div>';

                            //<small>(px vh % em)</small>
                           
                            break;

                         case 'radio_toggle':
                            $html[] = '<div class="csb-switch-field">';

                            if( isset($value['options']) && count($value['options']) > 0 ){
                                foreach ($value['options'] as $option ) {
                                    $size = 100 / count($value['options']);
                                    $size = number_format((float)$size, 2, '.', '');

                                    $html[] =  '<input data-type="radio_toggle" type="radio" id="' . ( $box_id ) . '-' . ( $option['id'] ) . '" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" value="' . ( $option['id'] ) . '" />';
                                    $html[] =  '<label for="' . ( $box_id ) . '-' . ( $option['id'] ) . '" style="width: ' . ( $size ) . '%;' . ( isset($option['style']) && trim($option['style']) ? $option['style'] : '' ) . '" title="' . ( $option['name'] ) . '">' . ( $option['name'] ) . '</label>';
                                }
                            }

                            $html[] = '</div>';

                            break;

                        // Basic checkbox input
                        case 'image_radio':

                            if( isset($value['options']) && count($value['options']) > 0 ){
                                $html[] = '<div class="csb-select-wrapper">';
                                    foreach ($value['options'] as $option_key => $option_value ) {
                                        $html[] =   '<label class="csb-select-item ' . ($val == $option_key ? 'select-on' : '') . '">';
                                        $html[] =       '<span>' . ( $option_value['caption'] ) . '</span>';
                                        $html[] =       '<img src="' . ( $option_value['img'] ) . '" />';
                                        $html[] =       '<input name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" ' . ($val == $option_key ? 'checked' : '') . ' type="radio" value="' . ( $option_key ) . '" />';
                                        $html[] =   '</label>';
                                    }
                                $html[] = '</div>'; 
                            }
                            break;
                        
                        // Basic upload_image
                        case 'upload_image':

                            $sub_type = isset($value['sub_type']) ? $value['sub_type'] : 'image_preview';

                            $html[] = '<div class="' . ( csb()->alias ) . '-upload-box-wrapper" data-type="' . ( $sub_type ) . '">';

                            if( $sub_type == 'image_preview' ) {
                                $html[] =   '<div class="' . ( csb()->alias ) . '-upload-image">';
                                if( (int)$val > 0 ){
                                    $html[] = wp_get_attachment_image( $val, array( '75', '75' ) );
                                }
                                $html[] =   '</div>';
                                $html[] =   '<input type="hidden" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" value="' . ( (int)$val ) . '" />';
                            }
                            else{
                                $html[] =   '<input type="text" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" value="' . ( (int)$val ) . '" />';
                            }
                            $html[] =   '<a href="#upload" target="blank" class="' . ( csb()->alias ) . '-button ' . ( csb()->alias ) . '-small yellow ' . ( csb()->alias ) . '-btn-upload">Upload Image</a>';
                            $html[] =   '<a href="#upload" target="blank" class="' . ( csb()->alias ) . '-button ' . ( csb()->alias ) . '-small red ' . ( csb()->alias ) . '-btn-upload-delete">Delete Image</a>';
                            $html[] = '</div>';
                            
                            break;
                        
                        // Basic textarea
                        case 'textarea':
                            $cols = "120";
                            if (isset($value['cols'])) {
                                $cols = $value['cols'];
                            }
                            $height = "style='height:120px;'";
                            if (isset($value['height'])) {
                                $height = "style='height:{$value['height']};'";
                            }
                            
                            $html[] = '<textarea id="' . esc_attr($elm_id) . '" ' . $height . ' cols="' . ($cols) . '" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']">' . esc_attr($val) . '</textarea>';
                            break;
                        
                        // Basic html/text message
                        case 'message':
                            $html[] = '<div class="csb-message csb-' . ($value['status']) . ' ' . ($this->tabs_elements($box, $elm_id)) . '">' . ($value['html']) . '</div>';
                            break;
                        
                        
                        // Basic html/text message
                        case 'html':
                            $html[] = str_replace("__box_id__", $box_id, $value['html']);
                            break;
						
                        // Select Box
                        case 'font_selector':

                            if( count($value['fonts']) == 0 ){
                                $value['fonts'] = csb()->getAllGfonts();
                            }

                            $html[] = "<input data-type='font_selector' data-fonts=' " . ( json_encode($value['fonts']) ) . "' ";
                            $html[] = 'class="csb-font-selector" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" id="' . esc_attr($elm_id) . '" />';

                            break;

                        // Select Box
                        case 'font_weight':
                            $html[] = "<input data-fonts=' " . ( json_encode($value['fonts']) ) . "' ";
                            $html[] = 'class="csb-font-selector" name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" id="' . esc_attr($elm_id) . '" />';

                            break;

                        // Select Box
                        case 'select':
                            $html[] = '<select ' . (isset($value['force_width']) ? "style='width:" . ($value['force_width']) . "px;'" : '') . ' name="' . ( $box_id ) . '[' . esc_attr( $elm_id ) . ']" id="' . esc_attr($elm_id) . '">';
                            
                            foreach ($value['options'] as $key => $option) {
                                $selected = '';
                                if ($val != '') {
                                    if ($val == $key) {
                                        $selected = ' selected="selected"';
                                    }
                                }
                                $html[] = '<option' . $selected . ' value="' . esc_attr($key) . '">' . esc_html($option) . '</option>';
                            }
                            $html[] = '</select>';
                            break;
                        
                        // multiselect Box
                        case 'multiselect':
                            $html[] = '<select multiple="multiple" size="3" name="[' . ( $box_id ) . '][' . esc_attr( $elm_id ) . '][]" id="' . esc_attr($elm_id) . '">';
                            
                            if (count($option) > 1) {
                                foreach ($value['options'] as $key => $option) {
                                    $selected = '';
                                    if ($val != '') {
                                        if (in_array($key, $val)) {
                                            $selected = ' selected="selected"';
                                        }
                                    }
                                    $html[] = '<option' . $selected . ' value="' . esc_attr($key) . '">' . esc_html($option) . '</option>';
                                }
                            }
                            $html[] = '</select>';
                            break;
                            
                        // multiselect Box
                        case 'multiselect_left2right':

                            $available = array(); $selected = array();
                            foreach ($value['options'] as $key => $option ) {
                                if( $val != '' ) {
                                    if ( in_array($key, $val) ) { $selected[] = $key; } 
                                }
                            }
                            $available = array_diff(array_keys($value['options']), $selected);
                            
                            $html[] = '<div class="csb-multiselect-half csb-multiselect-available" style="margin-right: 2%;">';
                            if( isset($value['info']['left']) ){
                                $html[] = '<h5>' . ( $value['info']['left'] ) . '</h5>';
                            }
                            $html[] = '<select multiple="multiple" size="' . (isset($value['rows_visible']) ? $value['rows_visible'] : 5) . '" name="[' . ( $box_id ) . '][' . esc_attr( $elm_id ) . '-available][]" id="' . esc_attr( $elm_id ) . '-available" class="multisel_l2r_available">';
                            
                            if(count($available) > 0){
                                foreach ($value['options'] as $key => $option ) {
                                    if ( !in_array($key, $available) ) continue 1;
                                    $html[] = '<option value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
                                } 
                            }
                            $html[] = '</select>';
                            
                            $html[] = '</div>';
                            
                            $html[] = '<div class="csb-multiselect-half csb-multiselect-selected">';
                            if( isset($value['info']['right']) ){
                                $html[] = '<h5>' . ( $value['info']['right'] ) . '</h5>';
                            }
                            $html[] = '<select multiple="multiple" size="' . (isset($value['rows_visible']) ? $value['rows_visible'] : 5) . '" name="[' . ( $box_id ) . '][' . esc_attr( $elm_id ) . '[]" id="' . esc_attr( $elm_id ) . '" class="multisel_l2r_selected">';
                            
                            if(count($selected) > 0){
                                foreach ($value['options'] as $key => $option ) {
                                    if ( !in_array($key, $selected) ) continue 1;
                                    $isselected = ' selected="selected"'; 
                                    $html[] = '<option'. $isselected .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
                                } 
                            }
                            $html[] = '</select>';
                            $html[] = '</div>';
                            $html[] = '<div style="clear:both"></div>';
                            $html[] = '<div class="multisel_l2r_btn" style="">';
                            $html[] = '<span style="display: inline-block; width: 24.1%; text-align: center;"><input id="' . esc_attr( $elm_id ) . '-moveright" type="button" value="Move Right" class="moveright csb-button gray"></span>';
                            $html[] = '<span style="display: inline-block; width: 24.1%; text-align: center;"><input id="' . esc_attr( $elm_id ) . '-moverightall" type="button" value="Move Right All" class="moverightall csb-button gray"></span>';
                            $html[] = '<span style="display: inline-block; width: 24.1%; text-align: center;"><input id="' . esc_attr( $elm_id ) . '-moveleft" type="button" value="Move Left" class="moveleft csb-button gray"></span>';
                            $html[] = '<span style="display: inline-block; width: 24.1%; text-align: center;"><input id="' . esc_attr( $elm_id ) . '-moveleftall" type="button" value="Move Left All" class="moveleftall csb-button gray"></span>';
                            $html[] = '</div>';
                        break;
                            
                        default:
							wp_die("Invalid filed types!");
                            
                    }

					// the element description
                    if (isset($value['desc'])){
                        $html[] = '<span class="csb-form-note">' . ($value['desc']) . '</span>';
					}

  					if (!in_array($value['type'], $noRowElements)) {
                        // close: .csb-form-row
                        $html[] = '</div></div>';
                    }
                }
                
                // csb-message use for status message, default it's hidden
                $html[] = '<div class="csb-message" id="csb-status-box" style="display:none;"></div>';
                
                if( $show_form == true ){
                    // buttons for saving settings
                    $html[] = '<div class="csb-button-row">
    					<input type="submit" value="Save Settings" class="csb-button yellow csb-saveOptions" />
    				</div>';
                }
                
                if( $show_form == true ){
                    // close: form
                    $html[] = '</form>';
                }
                
                // return the $html
                return implode("\n", $html);
            }
        }

        //make Tabs!
        private function tabs_header( $box ) {
            $html = array();

            // get tabs
            $tabs = isset($box['tabs']) ? $box['tabs'] : array();
 
            if (is_array($tabs) && count($tabs)>0) {
                $html[] = '<ul class="csb-settings-tabs">';
                foreach ($tabs as $key_tab => $value_tab) {
                    $html[] = '<li data-container="' . ( $key_tab ) . '"><a class="csb-tabs-link" href="#' . ( $key_tab ) . '">' . ( $value_tab['label']  ) . '</a></li>';
                }
                $html[] = '</ul>';
            }

            // return the $html
            return implode("\n", $html);
        }

        private function tabs_elements($box, $elemKey) {
            // get tabs
            $__tabs = isset($box['tabs']) ? $box['tabs'] : array();

            $__ret = '';
            if (is_array($__tabs) && count($__tabs)>0) {
                foreach ($__tabs as $tabClass => $tabElements) {

                    $tabElements = $tabElements['elements'];
                    $tabElements = trim($tabElements);
                    $tabElements = array_map('trim', explode(',', $tabElements));
                    if (in_array($elemKey, $tabElements)) 
                        $__ret .= ($tabClass.' '); //support element on multiple tabs!
                }
            }
            return ''.trim($__ret).' ';
        }
    }
}