<?php
 /**
 * Customizer module
 * http://www.aa-team.com
 * ======================
 *
 * @package		CSB_
 * @author		Andrei Dinca, AA-Team
 * @version		1.0
 */
! defined( 'ABSPATH' ) and exit;

if(class_exists('CSB_customizer') != true) {
	class CSB_customizer {
		
		const VERSION = '1.0';
		
		/**
		 * parent storage
		 *
		 * @var array
		 */
		public $parent = array();

		protected static $instance = null;

		private $layout_options = array();
		private $google_fonts = array();
		private $safe_fonts = array();
		
		/**
		 * The constructor
		 */
		public function __construct( $parent=array() )
		{
			// load parent
			$this->parent = $parent;  

			add_action( 'customize_register', array( $this, 'load_custom_controls' ) );
			add_action( 'customize_register', array( $this, 'customize_register' ) );

			// Control scripts
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'frontend_load_style' ) );

			add_action( 'customize_save_after', array( $this, 'customizer_save_after' ) );

			add_action('wp_ajax_' . ( $this->parent->alias ) . '_frontend_style', array( $this, 'frontend_style') );
			add_action('wp_ajax_nopriv_' . ( $this->parent->alias ) . '_frontend_style', array( $this, 'frontend_style') );

			if ( !is_admin() ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'add_styles' ), 100);
			}

			$this->default_fonts();
			$this->set_layout_options();
		}

		public function load_custom_controls()
		{
			foreach( glob( CSB()->path( 'CUSTOMIZER_DIR', "/controls/*/init.class.php" ) ) as $control ){
				require_once $control;
			}  
		}

		public function default_fonts()
		{
			array_push( $this->safe_fonts, "Arial, Helvetica, sans-serif" );
			array_push( $this->safe_fonts, "Arial Black, Gadget, sans-serif" );
			array_push( $this->safe_fonts, "Georgia, serif" );
			array_push( $this->safe_fonts, "Helvetica Neue" );
			array_push( $this->safe_fonts, "Impact, Charcoal, sans-serif" );
			array_push( $this->safe_fonts, "Tahoma, Geneva, sans-serif" );
			array_push( $this->safe_fonts, "Times New Roman, Times, serif" );
			array_push( $this->safe_fonts, "Verdana, Geneva, sans-serif" );
		}

		public function frontend_load_style()
		{
			wp_enqueue_style(
				$this->parent->alias . '-customizer-frontend',
				CSB()->path( 'CUSTOMIZER_URL', 'frontend.css' ),
				array( ),
				self::VERSION
			);
		}

		public function enqueue_control_scripts() 
		{
			/*wp_enqueue_script(
				$this->parent->alias . '-dom-outline',
				CSB()->path( 'CUSTOMIZER_URL', 'dom-outline.js' ),
				array( 'jquery' ,'customize-preview' ),
				self::VERSION,
				true
			);*/

			wp_enqueue_script(
				$this->parent->alias . '-customizer-controls',
				CSB()->path( 'CUSTOMIZER_URL', 'app.class.js' ),
				array( 'jquery' ,'customize-preview', $this->parent->alias . '-dom-outline' ),
				self::VERSION,
				true
			);

			wp_enqueue_style(
				$this->parent->alias . '-customizer-controls',
				CSB()->path( 'CUSTOMIZER_URL', 'styles.css' ),
				array( ),
				self::VERSION
			);
		}

		public static function getInstance( $parent=array() )
	    {
	        if (!isset(static::$instance)) {
	            static::$instance = new static( $parent );
	        }
	        return static::$instance;
	    }

	    public function add_styles()
		{
			$protocol = is_ssl() ? 'https' : 'http';
			$main_style = admin_url('admin-ajax.php?action=' . ( $this->parent->alias ) . '_frontend_style');

			if( is_array($this->google_fonts) && count($this->google_fonts) > 0 ){
				$google_fonts_url = 'https://fonts.googleapis.com/css?family=' . implode( "|", $this->google_fonts );
				$google_fonts_url = str_replace( " ", "+", $google_fonts_url);

				wp_enqueue_style( $this->parent->alias . '-google-fonts',	$google_fonts_url, array() );
			}

			wp_enqueue_style( $this->parent->alias . '-frontend-style',	$main_style, array() );
		}

	    public function frontend_style()
	    {
    		// Enable caching
			header('Cache-Control: public');
			 
			// Expire in one day
			header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
			 
			// Set the correct MIME type, because Apache won't set it for us
			header("Content-type: text/css");

			$css = array();
			if( $this->layout_options && is_array($this->layout_options) && count($this->layout_options) > 0){
				foreach ($this->layout_options as $selector => $props) {

					$css[] = $selector . "{";
					if( !empty($props) && is_array($props) && count($props) > 0 ){
						foreach ($props as $key => $value) {
							$css[] = $key . ": " . $value . ';';
						}
					}
					$css[] = "}";
				}
			}

			$css = implode( "\n", $css );

			//die( var_dump( "<pre>", $css  , "<pre>" ) . PHP_EOL .  __FILE__ . ":" . __LINE__  ); 

			// Remove whitespace
			$css = str_replace(array("\r\n", "\r", "\n", "\t", '    ', '    '), '', $css);

			echo $css;
			die;
		}

		private function set_layout_options()
		{
			$options = get_option( $this->parent->alias . '_layout' );
			if( $options && !empty($options) ){
				$options = json_decode( $options, true );
				if( $options && is_array($options) && count($options) > 0 ){

					// search for custom google fonts
					foreach ($options as $selector => $props) {
						if( $props && !empty($props) && count($props) > 0 ){
							foreach ($props as $key => $prop) {
								if( $key == 'font-family' ){
									$prop = trim( $prop, "'" );

									if( !in_array( $prop, $this->safe_fonts) ){
										array_push( $this->google_fonts, $prop );
									}
								}
							}
						}
					}
					$this->layout_options = $options;
				}
			}
		}

		public function customizer_save_after()
	    {
	    	$options  = json_decode( stripslashes_deep( $_REQUEST['customized'] ), true );
	    	$layout = isset($options[$this->parent->alias . '_layout']) ? $options[$this->parent->alias . '_layout'] : array();

	    	update_option( $this->parent->alias . '_layout', $layout );
	    }

		public function customize_register( $wp_customize ) 
		{
		    $wp_customize->add_section(
		    	$this->parent->alias . '_setup', array(
			        'title'         => $this->parent->plugin_name . " Setup",
			        'capability' => 'edit_theme_options', //Capability needed to tweak
            		'description' => __('Allows you to customize <span class="mg-plugin-name">' . ( $this->parent->plugin_name ) . '</span> templates.', 'mytheme'), //Descriptive tooltip
			        'priority'		=> 300,
		    	)
		    );

		    // adding setting for copyright text
		    $wp_customize->add_setting(
		    		$this->parent->alias . '_template_setup', array(
		        	'default'        => ''
		    	)
		    );

			$wp_customize->add_control( new CSB_Customize_Smart_Selector_Control( 
				$wp_customize, 
				'footer_credits_control', 
				array(
					'label'	=> 'Footer Credits',
					'section' => $this->parent->alias . '_setup',
					'settings' => $this->parent->alias . '_template_setup'
				) 
			));

			// adding setting for footer text area
			$wp_customize->add_setting( $this->parent->alias . '_layout', array(
				'default'        => '',
				'transport'		=> 'postMessage'
			));

			$wp_customize->add_control( $this->parent->alias . '_layout', array(
				'section' => $this->parent->alias . '_setup',
				'type'    => 'textarea',
				'ceva' => 'cvaaa'
			));
		}		
	}
}
//new CSB_customizer();