<?php 
if( class_exists( 'WP_Customize_Control' ) ){
	class CSB_Customize_Smart_Selector_Control extends WP_Customize_Control 
	{
		public $type = 'smart_selector';
 		
		public $set = array();

 		public function load_settings()
 		{

 			$this->set['tabs'] = array(
				CSB()->alias . '-text' => array(
					'label' 	=> '<i class="csb-icon-font-size"></i> Text',
					'elements' 	=> 'font-family,color,font-weight,font-size,line-height,font-style,text-align,text-decoration,text-transform,letter-spacing',
				),

				CSB()->alias . '-background' => array(
					'label' 	=> '<i class="csb-icon-bucket"></i> Background',
					'elements' 	=> 'background-color,background-image,background-position,background-size,background-repeat',
				),

				CSB()->alias . '-margin' => array(
					'label' 	=> '<i class="csb-icon-enlarge"></i> Margin',
					'elements' 	=> 'margin-top,margin-right,margin-bottom,margin-left',
				),

				CSB()->alias . '-padding' => array(
					'label' 	=> '<i class="csb-icon-shrink"></i> Padding',
					'elements' 	=> 'padding-top,padding-right,padding-bottom,padding-left',
				),

				CSB()->alias . '-border' => array(
					'label' 	=> '<i class="csb-icon-border"></i> Border',
					'elements' 	=> 'border-style,border-width,border-color',
				),

				CSB()->alias . '-borderRadius' => array(
					'label' 	=> '<i class="csb-icon-border-radius"></i> Rounded Borders',
					'elements' 	=> 'border-top-left-radius,border-top-right-radius,border-bottom-right-radius,border-bottom-left-radius',
				),
				
				CSB()->alias . '-other' => array(
					'label' 	=> '<i class="csb-icon-width"></i> Others',
					'elements' 	=> 'opacity,display,float,clear,visibility,overflow-x,overflow-y',
				),

				/*CSB()->alias . '-size' => array(
					'label' 	=> '<i class="csb-icon-width"></i> Size',
					'elements' 	=> 'primary_color2',
				)*/
			);

 			
			$this->set['elements']['font-family'] = array(
 				'type' => 'font_selector',
		        'std' => 'inherit',
		        'title' => 'Font Family:',
		        'desc' => 'The font-family property specifies the font for element.',
		        'fonts' => array()
 			);

			$this->set['elements']['font-weight'] = array(
 				'type' => 'select',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Font Weight:',
		        'options' => array(
		        	'300' => 'Light'.' 300',
					'400' => 'Normal'.' 400',
					'500' => 'Semi-Bold'.' 500',
					'600' => 'Bold'.' 600',
					'700' => 'Extra-Bold'.' 700'
		        ),
		        'desc' => 'The font-weight property sets how thick or thin characters in text should be displayed'
 			);

			$this->set['elements']['color'] = array(
 				'type' => 'color_picker',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Color:',
		        'desc' => 'The color property specifies the color of text.'
 			);

 			$this->set['elements']['font-size'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 72,
		        	'def' => 15,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Font Size:',
		        'desc' => 'The font-size property sets the size of text.'
 			);

 			$this->set['elements']['line-height'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 72,
		        	'def' => 15,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Line Height:',
		        'desc' => 'The line-height property specifies the line height.'
 			);

 			$this->set['elements']['font-style'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Font Style:',
		        'desc' => 'The font-style property specifies the font style for a text.',
		        'options' => array(
		        	array(
		        		'id' => 'normal',
		        		'name' => 'normal',
		        		'style' => 'font-style: normal;'
		        	),

		        	array(
		        		'id' => 'italic',
		        		'name' => 'italic',
		        		'style' => 'font-style: italic;'
		        	)
		        )
 			);

 			$this->set['elements']['text-align'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Text Align:',
		        'desc' => 'The text-align property specifies the horizontal alignment of text in an element.',
		        'options' => array(
		        	array(
		        		'id' => 'left',
		        		'name' => 'left',
		        		'style' => 'text-align: left;'
		        	),

		        	array(
		        		'id' => 'center',
		        		'name' => 'center',
		        		'style' => 'text-align: center;'
		        	),

		        	array(
		        		'id' => 'right',
		        		'name' => 'right',
		        		'style' => 'text-align: right;'
		        	),

		        	array(
		        		'id' => 'justify',
		        		'name' => 'justify',
		        		'style' => 'text-align: justify;letter-spacing: 1.5px;'
		        	),
		        )
 			);

 			$this->set['elements']['letter-spacing'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => -5,
		        	'max' => 10,
		        	'def' => 0,
		        	'step' => 0.1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Letter Spacing:',
		        'desc' => 'The letter-spacing property increases or decreases the space between characters in a text.'
 			);

 			$this->set['elements']['text-transform'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Text Transform:',
		        'desc' => 'The text-transform property controls the capitalization of text.',
		        'options' => array(
		        	array(
		        		'id' => 'none',
		        		'name' => 'none',
		        		'style' => 'text-transform: none;'
		        	),
		        	array(
		        		'id' => 'uppercase',
		        		'name' => 'uppercase',
		        		'style' => 'text-transform: uppercase;'
		        	),
		        	array(
		        		'id' => 'lowercase',
		        		'name' => 'lowercase',
		        		'style' => 'text-transform: lowercase;'
		        	),
		        	array(
		        		'id' => 'capitalize',
		        		'name' => 'capitalize',
		        		'style' => 'text-transform: capitalize;'
		        	),
		        )
 			);
 			
 			$this->set['elements']['text-decoration'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Text Decoration:',
		        'desc' => 'The text-decoration property specifies the decoration added to text.',
		        'options' => array(
		        	array(
		        		'id' => 'no',
		        		'name' => 'none',
		        		'style' => 'text-decoration: none;'
		        	),
		        	array(
		        		'id' => 'overline',
		        		'name' => 'overline',
		        		'style' => 'text-decoration: overline;'
		        	),
		        	array(
		        		'id' => 'through',
		        		'name' => 'through',
		        		'style' => 'text-decoration: line-through;'
		        	),
		        	array(
		        		'id' => 'underline',
		        		'name' => 'underline',
		        		'style' => 'text-decoration: underline;'
		        	),
		        )
 			);

 			/** 
			* Background panel here
 			**/
 			$this->set['elements']['background-color'] = array(
 				'type' => 'color_picker',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Background Color:',
		        'desc' => 'The background-color property sets the background color of an element.'
 			);

 			$this->set['elements']['background-image'] = array(
 				'type'      => 'upload_image',
 				'sub_type'	=> 'as_url',
 				'std' 		=> '',
	            'size'      => 'large',
	            'title'     => 'Background Image:',
	            'value'     => 'Upload Image',
	            'desc'      => 'The background-image property sets one or more background images for an element.'
 			);

 			$this->set['elements']['background-position'] = array(
 				'type' => 'select',
		        'std' => '400',
		        'size' => 'small',
		        'title' => 'Background Position:',
		        'options' => array(
		        	'0% 0%' => 'left top',
					'0% 50%' => 'left center',
					'0% 100%' => 'left bottom',
					'100% 0%' => 'right top',
					'100% 50%' => 'right center',
					'100% 100%' => 'right bottom',
					'50% 0%' => 'center top',
					'50% 50%' => 'center center',
					'50% 100%' => 'center bottom'
		        ),
		        'desc' => 'The background-position property sets the starting position of a background image.'
 			);

 			$this->set['elements']['background-size'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'title' => 'Background Size:',
		        'desc' => 'The background-size property specifies the size of the background images.',
		        'options' => array(
		        	array(
		        		'id' => 'auto',
		        		'name' => 'auto',
		        	),
		        	array(
		        		'id' => 'length',
		        		'name' => 'length',
		        	),
		        	array(
		        		'id' => 'cover',
		        		'name' => 'cover',
		        	),
		        	array(
		        		'id' => 'contain',
		        		'name' => 'contain',
		        	),
		        )
 			);

 			$this->set['elements']['background-repeat'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'title' => 'Background Repeat:',
		        'desc' => 'The background-repeat property sets if/how a background image will be repeated.',
		        'options' => array(
		        	array(
		        		'id' => 'repeat',
		        		'name' => 'repeat',
		        	),
		        	array(
		        		'id' => 'repeat-x',
		        		'name' => 'repeat-x',
		        	),
		        	array(
		        		'id' => 'repeat-y',
		        		'name' => 'repeat-y',
		        	),
		        	array(
		        		'id' => 'no-repeat',
		        		'name' => 'no-repeat',
		        	),
		        )
 			);

 			/** 
 			*	Margins
 			**/
 			foreach (array( 'top', 'right', 'bottom', 'left' ) as $loop) {
	 			$this->set['elements']['margin-' . $loop ] = array(
	 				'type' => 'slider',
			        'options' => array(
			        	'min' => -50,
			        	'max' => 100,
			        	'def' => 0,
			        	'step' => 1,
			        	'units' => array(
			        		'px',
			        		'%',
			        		'em',
			        		'rem',
			        	)
			        ),
			        'title' => 'Margin ' . ( $loop ) . ':',
			        'desc' => 'The CSS margin properties are used to generate space around elements.'
	 			);
	 		}

	 		/** 
 			*	Padding
 			**/
 			foreach (array( 'top', 'right', 'bottom', 'left' ) as $loop) {
	 			$this->set['elements']['padding-' . $loop ] = array(
	 				'type' => 'slider',
			        'options' => array(
			        	'min' => -50,
			        	'max' => 100,
			        	'def' => 0,
			        	'step' => 1,
			        	'units' => array(
			        		'px',
			        		'%',
			        		'em',
			        		'rem',
			        	)
			        ),
			        'title' => 'Padding ' . ( $loop ) . ':',
			        'desc' => 'The CSS padding properties are used to generate space around content.'
	 			);
	 		}

	 		$this->set['elements']['border-style'] = array(
 				'type' => 'radio_toggle',
		        'std' => '',
		        'title' => 'Border Style:',
		        'desc' => 'The border-style property specifies what kind of border to display.',
		        'options' => array(
		        	array(
		        		'id' => 'none',
		        		'name' => 'none',
		        	),
		        	array(
		        		'id' => 'dotted',
		        		'name' => 'dotted',
		        	),
		        	array(
		        		'id' => 'dashed',
		        		'name' => 'dashed',
		        	),
		        	array(
		        		'id' => 'solid',
		        		'name' => 'solid',
		        	),
		        	array(
		        		'id' => 'hidden',
		        		'name' => 'hidden',
		        	)
		        )
 			);

	 		$this->set['elements']['border-width'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 20,
		        	'def' => 0,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Border Width:',
		        'desc' => 'The border-width property specifies the width of the four borders.'
 			);

 			$this->set['elements']['border-color'] = array(
 				'type' => 'color_picker',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Border Color:',
		        'desc' => 'The border-color property is used to set the color of the four borders.'
 			);

 			$this->set['elements']['border-top-left-radius'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 50,
		        	'def' => 0,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Border top left Width:',
		        'desc' => 'The border top left radius.'
 			);

 			$this->set['elements']['border-top-right-radius'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 50,
		        	'def' => 0,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Border top right Width:',
		        'desc' => 'The border top right radius.'
 			);

 			$this->set['elements']['border-bottom-left-radius'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 50,
		        	'def' => 0,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Border bottom left Width:',
		        'desc' => 'The border bottom left radius.'
 			);

 			$this->set['elements']['border-bottom-right-radius'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 50,
		        	'def' => 0,
		        	'step' => 1,
		        	'units' => array(
		        		'px',
		        		'%',
		        		'em',
		        		'rem',
		        	)
		        ),
		        'title' => 'Border bottom right Width:',
		        'desc' => 'The border bottom right radius.'
 			);


 			$this->set['elements']['opacity'] = array(
 				'type' => 'slider',
		        'options' => array(
		        	'min' => 0,
		        	'max' => 1,
		        	'def' => 1,
		        	'step' => 0.01,
		        	'units' => array(
		        		'',
		        	)
		        ),
		        'title' => 'Opacity:',
		        'desc' => 'The opacity property specifies the opacity/transparency of an element.'
 			);

 			$this->set['elements']['display'] = array(
 				'type' => 'select',
		        'std' => '',
		        'size' => 'small',
		        'title' => 'Display:',
		        'options' => array(
		        	'inline' => 'inline',
		        	'block' => 'block',
		        	'inline-block' => 'inline-block',
		        	'inline-flex' => 'inline-flex',
		        	'table-cell' => 'table-cell',
		        	'none' => 'none'
		        ),
		        'desc' => 'The display property specifies the type of box used for an HTML element.'
 			);

 			$this->set['elements']['float'] = array(
 				'type' => 'select',
		        'std' => '',
		        'title' => 'Float:',
		        'desc' => 'The float property specifies whether or not an element should float.',
		        'options' => array(
		        	'none' => 'none',
		        	'left' => 'left',
		        	'right' => 'right',
		        	'initial' => 'initial',
		        	'inherit' => 'inherit'
		        )
 			);

 			$this->set['elements']['clear'] = array(
 				'type' => 'select',
		        'std' => '',
		        'title' => 'Clear:',
		        'desc' => 'The clear property specifies on which sides of an element floating elements are not allowed to float.',
		        'options' => array(
		        	'none' => 'none',
		        	'left' => 'left',
		        	'right' => 'right',
		        	'both' => 'both',
		        	'initial' => 'initial',
		        	'inherit' => 'inherit'
		        )
 			);

 			$this->set['elements']['visibility'] = array(
 				'type' => 'select',
		        'std' => '',
		        'title' => 'Visibility:',
		        'desc' => 'The visibility property specifies whether or not an element is visible.',
		        'options' => array(
		        	'visible' => 'visible',
		        	'hidden' => 'hidden',
		        	'collapse' => 'collapse',
		        	'initial' => 'initial',
		        	'inherit' => 'inherit'
		        )
 			);

 			$this->set['elements']['overflow-x'] = array(
 				'type' => 'select',
		        'std' => '',
		        'title' => 'overflow-x:',
		        'desc' => 'The overflow-x property specifies what to do with the left/right edges of the content - if it overflows the element\'s content area.',
		        'options' => array(
		        	'visible' => 'visible',
		        	'hidden' => 'hidden',
		        	'scroll' => 'scroll',
		        	'auto' => 'auto',
		        	'initial' => 'initial',
		        	'inherit' => 'inherit'
		        )
 			);

 			$this->set['elements']['overflow-y'] = array(
 				'type' => 'select',
		        'std' => '',
		        'title' => 'overflow-y:',
		        'desc' => 'The overflow-y property specifies what to do with the left/right edges of the content - if it overflows the element\'s content area.',
		        'options' => array(
		        	'visible' => 'visible',
		        	'hidden' => 'hidden',
		        	'scroll' => 'scroll',
		        	'auto' => 'auto',
		        	'initial' => 'initial',
		        	'inherit' => 'inherit'
		        )
 			);
 		}

		public function render_content() {
			$this->load_settings();
		?>	
			<!--div class="<?php echo CSB()->alias?>-activate-selector">
				<a href="#" class="<?php echo CSB()->alias?>-crosshairs" data-container="body"><i class="csb-icon-touch"></i> Activate selector</a>
			</div-->

			<div class="<?php echo CSB()->alias?>-activate-selector">
				<div class="<?php echo CSB()->alias?>-name"></div>
				<div class="<?php echo CSB()->alias?>-trigger">

					<a href="#"><i class="csb-icon-touch"></i></a>

					<div class="csb-switch-field-state-change">
						<a href="#normal">Normal</a>
						<a href="#hover">Hover</a>
					</div>
				</div>
				<a href="#" class="<?php echo CSB()->alias?>-full-reset">
					<i class="csb-icon-reset"></i>
					RESET
				</a>
			</div>
		<?php
			echo '<div class="' . ( CSB()->alias ) . '-customizer-setup">';
			echo CSB_Settings()->build_options( $this->set, 'CSB_Import_Settings', false );
			echo '</div>';
		}
	}
}