var csb_safe_fonts = [];
csb_safe_fonts.push( "Arial, Helvetica, sans-serif" );
csb_safe_fonts.push( "Arial Black, Gadget, sans-serif" );
csb_safe_fonts.push( "Georgia, serif" );
csb_safe_fonts.push( "Helvetica Neue" );
csb_safe_fonts.push( "Impact, Charcoal, sans-serif" );
csb_safe_fonts.push( "Tahoma, Geneva, sans-serif" );
csb_safe_fonts.push( "Times New Roman, Times, serif" );
csb_safe_fonts.push( "Verdana, Geneva, sans-serif" );


CSB = (function ($) {
    "use strict";

    var customizer              = null,
        mode                    = 'customizer',
        hexDigits               = new Array("0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"),
        _precompile_regs        = [],
        tabs                    = null,
        container               = null,
        plugin_container        = null,
        dom_current_elm         = null,
        allow_browse_dom        = null,
        customizer_setup        = null,
        current_css_path        = null,
        file_frame              = null,
        selector_preview_css    = null,
        iframe                  = null,
        css_style               = {},
        db_styles               = [],
        DOM_overlay             = null,
        selector_elm            = null,
        show_edit               = false,
        custom_style            = null,
        enter_in_edit_mode      = false,
        default_styles          = {},
        google_fonts            = [],
        markers                 = [],
        custom_web_fonts        = null,
        textarea                = null,
        collector               = [],
        edit_selector           = '',
        the_content             = null,
        selector_dom_wrapper    = null;
    
    // init function, autoload
    function init() {
        // load the triggers
        $(document).ready(function(){

            console.log('Beautify - Init!' );

            customizer = $("#customize-controls");
            tabs = customizer.find(".csb-settings-tabs");
            selector_dom_wrapper = customizer.find(".csb-selector-dom-wrapper");
            dom_current_elm = customizer.find(".csb-selector-dom-current_elm");
            customizer_setup = customizer.find(".csb-customizer-setup");
            current_css_path = customizer.find(".csb-selector-dom-current_css_path");
            textarea = customizer.find("#customize-control-csb_layout textarea");

            if( textarea.val() == "" ){
                default_styles = {};
            }else{
                //default_styles = $.parseJSON( textarea.val() );
                default_styles = csb_layout_options;

                // setup as default
                $.each( default_styles, function( key, value ){
                    css_style[key] = value;
                });
            }

            //textarea.hide();

            if( customizer.size() == 0 ){
                //mode = 'direct';
            }

            custom_style = $('<style />', {
                'type'  : 'text/css',
                'id'    : "csb-custom-style" 
            });

            custom_web_fonts = $('<link  />', {
                'rel'  : 'stylesheet',
                'id'    : "csb-custom-webfont" 
            });

            //filters_rules();

            create_acc();

            triggers();

            if( mode == 'direct' ){
                $(window).on('load', function(){
                    setTimeout( function(){
                        console.time();
                        temp_build();
                        generate_selector_map();
                        console.timeEnd();
                    }, 100);
                });
            }

            mark_selectors();
        });
    }

    $(window).on("load", function() {
        monitor_events('wp.customize.previewer');
     
        function monitor_events( object_path ) {
            var p = eval(object_path);
            var k = _.keys(p.topics);
            //console.log( object_path + " has events ", k);
            _.each(k, function(a) {
                p.bind(a, function() {
                    if( object_path == 'wp.customize.previewer' ){
                        //console.log( object_path + ' event ' + a, arguments );
                        if( a == 'documentTitle' ){
                            //console.log( object_path + ' event ' + a, arguments );

                            markers = [];
                            init();
                        }
                    }
                });
            });
        }
    });

    function temp_build()
    {
        load_plugin_container();

        container = 'body';

        selector_dom_wrapper.show();
        DOM_overlay = DOM_overlay_fn(); 
    }

    function create_acc()
    {
        customizer.find(".csb-form-row").each(function(){
            var that = $(this),
                name = $.trim(that.data('name'));

            //that.find(">label").append("<span class='csb-current-value'>inherit</span>");
            var li = tabs.find("li[data-container='" + ( name ) + "']");

            li.append( that );
        });
    }

    function load_plugin_container()
    {
        plugin_container = $("body");
    }


    function css_path(el) 
    {
        el = el[0];
        var useNthChild = 0,  // Set to 1 to use ":nth-child()" pseudo-selectors to match the given element
            cssPathStr = '',
            testPath = '',
            parents = [],
            parentSelectors = [],
            tagName,
            cssId,
            cssClass,
            tagSelector,
            vagueMatch,
            nth,
            i,
            c;
        
        // Go up the list of parent nodes and build unique identifier for each:
        while ( el ) {
            vagueMatch = 0;

            // Get the node's HTML tag name in lowercase:
            tagName = el.nodeName.toLowerCase();
            
            // Get node's ID attribute, adding a '#':
            cssId = ( el.id ) ? ( '#' + el.id ) : false;
            
            if( tagName == 'body' ){
                var _className = el.className.split(" ");
                el.className = _className[0];
            }
            // Get node's CSS classes, replacing spaces with '.':
            cssClass = ( el.className ) ? ( '.' + el.className.replace(/\s+/g,".") ) : '';

            // Build a unique identifier for this parent node:
            if ( cssId ) {
                // Matched by ID:
                tagSelector = tagName + cssId + cssClass;
            } else if ( cssClass ) {
                // Matched by class (will be checked for multiples afterwards):
                tagSelector = tagName + cssClass;
            } else {
                // Couldn't match by ID or class, so use ":nth-child()" instead:
                vagueMatch = 1;

                var _type = $(el).attr('type');
                if( typeof(_type) == "undefined" ){
                    tagSelector = tagName;
                }else{
                    tagSelector = tagName + "[type=" + ( _type ) + "]";
                }
            }
            
            // Add this full tag selector to the parentSelectors array:
            parentSelectors.unshift( tagSelector )

            if( tagSelector.indexOf(container) > -1  ){
                break;
            }
            
            // Go up to the next parent node:
            el = el.parentNode !== document ? el.parentNode : false;
            
        } // endwhile

        // Build the CSS path string from the parent tag selectors:
        for ( i = 0; i < parentSelectors.length; i++ ) {
            cssPathStr += ' ' + parentSelectors[i];// + ' ' + cssPathStr;
            
            // If using ":nth-child()" selectors and this selector has no ID / isn't the html or body tag:
            if ( useNthChild && !parentSelectors[i].match(/#/) && !parentSelectors[i].match(/^(html|body)$/) ) {
                
                // If there's no CSS class, or if the semi-complete CSS selector path matches multiple elements:
                if ( !parentSelectors[i].match(/\./) || $( cssPathStr ).length > 1 ) {
                    
                    // Count element's previous siblings for ":nth-child" pseudo-selector:
                    for ( nth = 1, c = el; c.previousElementSibling; c = c.previousElementSibling, nth++ );
                    
                    // Append ":nth-child()" to CSS path:
                    cssPathStr += ":nth-child(" + nth + ")";
                }
            }
            
        }
        
        // Return trimmed full CSS path:
        return cssPathStr.replace(/^[ \t]+|[ \t]+$/, '');
    }

    function isDefined(a)
    {
        if(typeof a !== typeof undefined && a !== false && a != '' && a != ' ' && a != 'undefined' && a !== null){
            return true;
        }else{
            return false;
        }
    }

    function isUndefined(a)
    {
        if(typeof a === typeof undefined || a === false || a === '' || a == ' ' || a == 'undefined' || a === null){
            return true;
        }else{
            return false;
        }
    }

    function identifier( ele_obj )
    {
        var excluded_classes = ['editable', 'clearfix', 'clear', 'hfeed', 'animatedParent', 'animate', 'animated', 'clr', 'fa-', 'lazy', 'js', 'sf-', 'type-', 'format-', 'category-', 'tag-', 'status', 'post-', 'cat-item', 'page-item', 'widget-', 'widget_', 'menu-item', 'odd', 'even', 'page_item', 'cat_item', 'menu_item', 'byuser', 'col-', 'portrait', 'landscape'];
        var excluded_ids = ['menu-', 'comment-'];

        excluded_classes = [];

        function findValid(c, array) {
            for (var i = 0, len = array.length; i < len; i++) {
                if (c.indexOf(array[i]) > -1) {
                    return null;
                    break;
                }
            }
            return c;
        }

        var TAG = ele_obj.prop('tagName');
        var ID = ele_obj.attr('id');
        var classes = [];
        var CLASS = ele_obj.attr('class');
        var DESC = '';
        if (CLASS) {
            CLASS = CLASS.split(' ');
            if (CLASS.length < 100) {
                jQuery(CLASS).each(function(i, cl) {
                    var valid_class = findValid(cl, excluded_classes);
                    if (cl && cl != '' && valid_class) classes.push(cl)
                })
                CLASS = '.' + classes.join('.');
                DESC = classes.join(' ');
            } else {
                CLASS = '';
            }
        } else {
            CLASS = '';
        }
        if (CLASS == '.') CLASS = '';
        if (ID && ID != '' && findValid(ID, excluded_ids)) {
            DESC = ID;
            ID = '#' + ID;
            CLASS = '';
        } else {
            ID = '';
        }
        if (ID.indexOf('post-') > -1) {
            ID = '';
            DESC = 'Post';
        }
        if (ID.indexOf('product-') > -1) {
            ID = '';
            DESC = 'WooCommerce Product';
        }
        var scope = TAG + CLASS + ID
        var DESC_TAG = TAG;
        if (TAG == 'A') DESC_TAG = 'Link';
        if (TAG == 'UL') DESC_TAG = 'List';
        if (TAG == 'OL') DESC_TAG = 'Ordered List';
        if (TAG == 'IMG') DESC_TAG = 'Image';
        if (TAG == 'LI') DESC_TAG = 'Item';
        if (TAG == 'I') DESC_TAG = 'Icon';
        if (TAG == 'P') DESC_TAG = 'Paragraph'
        if (TAG == 'BUTTON') DESC_TAG = 'Button'
        if (TAG == 'H1') DESC_TAG = 'Heading (Level 1)'
        if (TAG == 'H2') DESC_TAG = 'Heading (Level 2)'
        if (TAG == 'H3') DESC_TAG = 'Heading (Level 3)'
        if (TAG == 'H4') DESC_TAG = 'Heading (Level 4)'
        if (TAG == 'H5') DESC_TAG = 'Heading (Level 5)'
        if (TAG == 'H6') DESC_TAG = 'Heading (Level 6)'
        if (ele_obj.hasClass('widget')) {
            scope = TAG;
            DESC = DESC_TAG;
        }
        if (CLASS == '' && ID == '') {
            var PARENT_DESC = ele_obj.parent().attr('editablesuggestion');
            if (!PARENT_DESC) PARENT_DESC = '';
            DESC = PARENT_DESC + ' ' + DESC_TAG;
        }
        if (TAG == 'HTML' || TAG == 'BODY') {
            scope = TAG;
            DESC = TAG;
        }
        
        var full_css_path = css_path( ele_obj );
        //var css_path_obj = filter_to_deep_path( full_css_path );
        var css_path_obj = ele_obj.attr('data-csspath');
        //console.log(css_path_obj );

        if( mode == 'direct' ){
            var count_elements = $(css_path_obj).size();
        }else{
            var count_elements = iframe.find(css_path_obj).size();
        }
        //console.log(css_path_obj, '      ---------    ', full_css_path );

        return {
            scope: scope,
            tag: TAG,
            desc_tag: DESC_TAG,
            desc: DESC,
            count: count_elements,
            full_path: full_css_path,
            small_path: css_path_obj
        };
    }
    function filters_rules()
    {
        var filterBadClassesBasic = [
        ];

        _precompile_regs = [];
        $.each( filterBadClassesBasic, function(key, the_rule){
            _precompile_regs.push( new RegExp(the_rule) )
        });
    }


    function filter_to_deep_path( string )
    {
        var classes_array = get_classes_array(string);
        var __nice_css_selector = [];
        $.each( classes_array, function( key, row ){

            if( key > 0 ){
                $.each( _precompile_regs, function(key, this_egex){
                    
                    var _row = row.split( "." );
                    _row = cleanArray(_row);

                    if( _row.length > 1 ){
                        //if( this_egex.test(row) ){
                            row = row.replace( this_egex, '' );
                            //console.log(row, this_egex );
                        //}
                    }
                });

                row = row.split( "." );
                row = cleanArray(row);

                if( row.length > 1 || row[0] != 'div' || key == (classes_array.length - 1) ){
                    row = row.join(".");

                    row = row.replace("#.", ".");
                    __nice_css_selector.push( row );
                }
            }
        });
        
        return __nice_css_selector.join(" ");
    }

    function cleanArray(actual) 
    {
      var newArray = new Array();
      for (var i = 0; i < actual.length; i++) {
        if (actual[i]) {
          newArray.push(actual[i]);
        }
      }
      return newArray;
    }

    function get_classes_array(classes)
    {
        var classesArray = [];
        classes = $.trim(classes);
        classes = classes.replace(/\s\s+/g, ' ');

        if(classes.indexOf(" ") != -1){
            var classessplit = classes.split(" ");

            var v;
            for(var i = 0; i < classessplit.length; i++){
                v = $.trim(classessplit[i]);
                classesArray.push(v);
            }
        }else{
            classesArray.push(classes);
        }

        return classesArray;
    }

    function show_preview( the_path )
    {
        var path_to_element = the_content.find(the_path).slice(0,100),
            body = the_content.find("body");

        body.find(".csb-preview").remove();

        var html = [];

        console.log(path_to_element.size(), the_path );
        //return false;
        path_to_element.each(function(){
            var that    = $(this),
                offset  = that.offset();

            var preview = $('<span>', {
                'class': 'csb-preview',
                'css'   : {
                    'top': offset.top,
                    'left': offset.left,
                    'width': that.outerWidth(),
                    'height': that.outerHeight()
                }
            });

            //console.log('ceva' );
            body.append( preview );
        });
    }

    function DOM_overlay_fn()
    {
        if( mode == 'direct' ){
            iframe = $(document);
        }else{
            iframe = $('#customize-preview iframe').contents();
        }

        iframe.find('head').append( custom_style );
        iframe.find('head').append( custom_web_fonts );

        //selector_elm = iframe.find( container );
        selector_elm = iframe.find( container );

        var iframe_body = iframe.find("body");
        var extra_offset = 6;
        var $target = null;

        function clear_old_overlays()
        {
            iframe.find(".csb-overlay-selector").remove();
        }

        function build_overlay( elm )
        {
            var offset = elm.offset();

            var overlay = $('<div>', {
                'class' : 'csb-overlay-selector',
                'css'   : {
                    'top': ( offset.top - extra_offset ),
                    'left': ( offset.left - extra_offset ),
                    'width': ( elm.outerWidth() + extra_offset * 2 ),
                    'height': ( elm.outerHeight() + extra_offset * 2)
                }
            });
            
            var labels = [];
            labels.push('<div class="csb-overlay-headline">');
            labels.push(    '<div class="csb-overlay-choose-menu">');
            labels.push(        '<span class="csb-overlay-choose-menu-selected"><i class="csb-icon-menu"></i></span>');
            labels.push(        '<ul class="csb-overlay-choose-menu-options">');
            labels.push(            '<li data-title="Select a wider area. For instance, if you have selected a table cell, pressing W will select the table row"><span>W</span><a href="#" data-action="wider">Select wider element</a></li>');
            labels.push(            '<li data-title="Undo the last Wider command"><span>N</span><a href="#" data-action="narrower">Select Narrower element</a></li>');
            labels.push(            '<li data-title="Quit this element selection" class="choose-menu-quit"><span>Q</span><a href="#" data-action="quit">Quit</a></li>');
            labels.push(            '<li class="choose-delimitter">Selectors</li>');
            labels.push(            '<li data-title="Set :hover element selector" class="choose-menu-quit"><span>H</span><a href="#">:hover</a></li>');
            labels.push(            '<li data-title="Set :focus element selector" class="choose-menu-quit"><span>F</span><a href="#">:focus</a></li>');
            labels.push(            '<li data-title="Set :active element selector" class="choose-menu-quit"><span>A</span><a href="#">:active</a></li>');
            labels.push(            '<li data-title="Set :visited element selector" class="choose-menu-quit"><span>V</span><a href="#">:visited</a></li>');
            labels.push(        '</ul>');
            labels.push(    '</div>');
            labels.push(    '<div class="csb-overlay-element-name">');
            labels.push(        'Paragraph');
            labels.push(    '</div>');
            labels.push(    '<div class="csb-overlay-number">');
            labels.push(        '<span>0</span> on this page');
            labels.push(    '</div>');
            labels.push(    '<div class="csb-overlay-path">');
            labels.push(        '<span><span></span></span>');
            labels.push(    '</div>');
            labels.push('</div>');
            overlay.append( labels.join("\n") );

            var paddings = [];
            paddings.push('<span class="csb-overlay-padding-top"></span>');
            paddings.push('<span class="csb-overlay-padding-bottom"></span>');
            paddings.push('<span class="csb-overlay-padding-right"></span>');
            paddings.push('<span class="csb-overlay-padding-left"></span>');
            overlay.append( paddings.join("\n") );

            var margins = [];
            margins.push('<span class="csb-overlay-margin-top"></span>');
            margins.push('<span class="csb-overlay-margin-bottom"></span>');
            margins.push('<span class="csb-overlay-margin-right"></span>');
            margins.push('<span class="csb-overlay-margin-left"></span>');
            overlay.append( margins.join("\n") );

            iframe.find("body").append( overlay );

            return overlay;
        }

        function on_mouse_move( event )
        {
            if( allow_browse_dom === false ) return false;
            //if(event.target.id.indexOf('selector') !== -1 || event.target.tagName === 'BODY' || event.target.tagName === 'HTML') return;

            iframe.find('.csb-preview').remove();

            $target = $(event.target);

            var offset = $target[0].getBoundingClientRect();
            var _top = offset.top + iframe.scrollTop();
            overlay_selector_elm.css({
                'top': ( _top - extra_offset ),
                'left': ( offset.left - extra_offset ),
                'width': ( offset.width + extra_offset * 2 ),
                'height': ( offset.height + extra_offset * 2)
            });

            var paddings = {
                'top': $target.css('padding-top'),
                'bottom': $target.css('padding-bottom'),
                'left': $target.css('padding-left'),
                'right': $target.css('padding-right')
            };

            var elm_padding_top = overlay_selector_elm.find(".csb-overlay-padding-top");
            elm_padding_top.css( 'height', paddings['top'] );
            var elm_padding_bottom = overlay_selector_elm.find(".csb-overlay-padding-bottom");
            elm_padding_bottom.css( 'height', paddings['bottom'] );

            
            var elm_padding_right = overlay_selector_elm.find(".csb-overlay-padding-right");
            elm_padding_right.css( 'width', paddings['right'] );
            
            var elm_padding_right = overlay_selector_elm.find(".csb-overlay-padding-left");
            elm_padding_right.css( 'width', paddings['left'] );

            // in left fix overlap
            if( parseInt(paddings['left']) > 0 ){
                if( parseInt(paddings['top']) > 0 ){
                    elm_padding_top.css('left', paddings['left']);
                }

                if( parseInt(paddings['bottom']) > 0 ){
                    elm_padding_bottom.css('left', paddings['left']);
                }
            }

            // in right fix overlap
            if( parseInt(paddings['right']) > 0 ){
                if( parseInt(paddings['top']) > 0 ){
                    elm_padding_top.css('right', paddings['right']);
                }

                if( parseInt(paddings['bottom']) > 0 ){
                    elm_padding_bottom.css('right', paddings['right']);
                }
            }
            
            var margins = {
                'top': $target.css('margin-top'),
                'bottom': $target.css('margin-bottom'),
                'left': $target.css('margin-left'),
                'right': $target.css('margin-right')
            };

            overlay_selector_elm.find(".csb-overlay-margin-top").css( 'height', margins['top'] );
            overlay_selector_elm.find(".csb-overlay-margin-bottom").css( 'height', margins['bottom'] );
            overlay_selector_elm.find(".csb-overlay-margin-right").css( 'width', margins['right'] );
            overlay_selector_elm.find(".csb-overlay-margin-left").css( 'width', margins['left'] );

            //var headline = overlay_selector_elm.find(".csb-overlay-headline");

            var identifier_obj = identifier( $target );

            overlay_selector_elm.find(".csb-overlay-element-name").text( identifier_obj.desc_tag );

            var the_count = overlay_selector_elm.find(".csb-overlay-number");
            the_count.find("span").text( identifier_obj.count );
            the_count.data( 'path', identifier_obj.small_path );
            overlay_selector_elm.find(".csb-overlay-path span span").text( identifier_obj.small_path );
        }

        recreateNode( selector_elm[0], true);
        selector_elm = iframe.find( container );

        var overlay_selector_elm = build_overlay( selector_elm );

        on_element_top_change( function(){
            clear_old_overlays();
            overlay_selector_elm = build_overlay( selector_elm );
        });

        overlay_selector_elm.find(".csb-overlay-path > span").mouseenter( function(){
            var that = $(this),
                child = that.find("span").eq(0),
                container_width = that.width(),
                child_width = child.width();

            child.animate({
                "left": ("-" + ( child_width - container_width ) + "px")
            }, 1000);
        });

        overlay_selector_elm.find(".csb-overlay-path > span").mouseleave( function(){
            var that = $(this),
                child = that.find("span").eq(0);

            child.css('left', '0px');
        });

        var delay = function (elem, callback) {
            var timeout = null;
            elem.onmouseover = function(event) {
                timeout = setTimeout(callback(event), 2000);
            };

            elem.onmouseout = function() {
                clearTimeout(timeout);
            }
        };

        delay( selector_elm[0], function(event) {
            on_mouse_move( event );
        });
        
        selector_elm.click(function(e){
            e.preventDefault();

            if( show_edit === true ){
                return true;
            }
            
            var that = $target;

            selector_dom_wrapper.find(".csb-selector-info").hide();

            allow_browse_dom = false;

            //var _css_path = css_path( $target );
          
            //print_css_path( _css_path );
            customizer.find(".csb-selector-current").css('display', 'block');

            overlay_selector_elm.css( 'pointer-events', 'auto' );

            //show_preview( overlay_selector_elm.find('.csb-overlay-number').data('path') );

            setTimeout(function(){
                show_edit = true;
            }, 200);
        });

        selector_elm.on('click', 'a[data-action="quit"]', function(e){
            e.preventDefault();
            
            setTimeout(function(){
                quit_from_selector();
            }, 200);
        });

        selector_elm.on('click', 'a[data-action="wider"]', function(e){
            e.preventDefault();
            
            setTimeout(function(){
                select_wider_element();
            }, 200);
        });

        selector_elm.on('click', 'a[data-action="narrower"]', function(e){
            e.preventDefault();
            
            setTimeout(function(){
                select_narrower_element()
            }, 200);
        });

        iframe.keyup(function(e){

            if( show_edit === true ){
                if( e.key == 'q' ){
                    quit_from_selector();
                }

                if( e.key == 'w' ){
                    select_wider_element();
                }

                if( e.key == 'n' ){
                    select_narrower_element();
                }
            }
        });

        iframe.on('click', function(event){
            var $target     = $(event.target),
                in_selector = false;

            if( show_edit === true ){
                if( $target.hasClass('csb-overlay-selector')){
                    in_selector = true;
                }

                // try one more time here, mayby is in padding, margin or headline
                if( in_selector === false ){
                    $target.parents('.csb-overlay-selector').eq(0).each(function(){
                        in_selector = true;
                    });
                }
                
                // exit from selector
                if( in_selector === false ){
                    quit_from_selector();
                }

                //console.log(in_selector );
            }
        });

        function select_wider_element()
        {
            var event = [];
            event.target = $target.parent()[0];
            if( typeof(event.target) != "undefined" ){
                allow_browse_dom = true;
                on_mouse_move( event );
                allow_browse_dom = false;
            }
        }

        function select_narrower_element()
        {
            var event = [];
            event.target = $target.children()[0];
            if( typeof(event.target) != "undefined" ){
                allow_browse_dom = true;
                on_mouse_move( event );
                allow_browse_dom = false;
            }
        }

        function quit_from_selector()
        {
            overlay_selector_elm.remove();
            show_edit = false;
            allow_browse_dom = true;
            DOM_overlay = DOM_overlay_fn(); 
        }

        return {
            "build_overlay": build_overlay,
            "clear_old_overlays": clear_old_overlays
        };
    }
    
    function print_css_path( str_path )
    {
        var children = str_path.split(" ");

        var html = [];
        $.each(children, function( key, val ){

            html.push("<li class='csb-css-path-group'>");

                val = val.replace( /\./g, "$." );
                val = val.replace( /\#/g, "$#" );

                var _selectors = val.split("$");

                // pseudo selector type starting with ... e.g.: abc-[0-9]

                $.each(_selectors, function(selector_key, selector_value){
                    if( selector_key == 0 ){
                        html.push( "<span class='csb-elm-type'>" + ( selector_value ) + "</span>" );
                    }else{
                        if( _selectors[0] + selector_value == container ){
                            html.push( "<span class='csb-elm-selector csb-elm-level0-selector'>" + ( selector_value ) + "</span>" );
                        }else{
                            html.push( "<span class='csb-elm-selector'>" + ( selector_value ) + " <i></i></span>" );
                        }
                    }
                })

                //return false;

            html.push("</li>");
        });

        current_css_path.html( html.join("\n") );
    }

    function recreateNode(el, withChildren) 
    {
        if (withChildren) {
            el.parentNode.replaceChild(el.cloneNode(true), el);
        } else {
            var newEl = el.cloneNode(false);
            while (el.hasChildNodes()) newEl.appendChild(el.firstChild);
            el.parentNode.replaceChild(newEl, el);
        }
    }

    function hex(x) {
        return isNaN(x) ? "00" : hexDigits[(x - x % 16) / 16] + hexDigits[x % 16];
    }

    function rgb2hex(rgb) 
    {
        rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);

        // avoid errors
        if( rgb == null ) {
            return rgb;
        }
        return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
    }

    function load_element_style( elm, css_path, panels )
    {
        var styles = {};

        // improve 
        elm = elm.eq(0);

        elm.each( function(){

            if( panels.text == "true" ){
                styles['text'] = {};
                styles['text']['font-family'] = elm.css('font-family');
                styles['text']['color'] = rgb2hex(elm.css('color'));
                styles['text']['font-weight'] = elm.css('font-weight');
                styles['text']['font-size'] = elm.css('font-size');
                styles['text']['line-height'] = elm.css('line-height');
                styles['text']['font-style'] = elm.css('font-style');
                styles['text']['text-align'] = elm.css('text-align');
                styles['text']['text-decoration'] = elm.css('text-decoration');
                styles['text']['text-transform'] = elm.css('text-transform');
                styles['text']['letter-spacing'] = elm.css('letter-spacing');
            }

            if( panels.background == "true" ){
                styles['background'] = {};
                styles['background']['background-color'] = rgb2hex(elm.css('background-color'));
                styles['background']['background-image'] = elm.css('background-image');
                styles['background']['background-position'] = elm.css('background-position');
                styles['background']['background-size'] = elm.css('background-size');
                styles['background']['background-repeat'] = elm.css('background-repeat');
            }

            if( panels.margin == "true" ){
                styles['margin'] = {};
                styles['margin']['margin-top'] = elm.css('margin-top');
                styles['margin']['margin-right'] = elm.css('margin-right');
                styles['margin']['margin-bottom'] = elm.css('margin-bottom');
                styles['margin']['margin-left'] = elm.css('margin-left');
            }

            if( panels.padding == "true" ){
                styles['padding'] = {};
                styles['padding']['padding-top'] = elm.css('padding-top');
                styles['padding']['padding-right'] = elm.css('padding-right');
                styles['padding']['padding-bottom'] = elm.css('padding-bottom');
                styles['padding']['padding-left'] = elm.css('padding-left');
            }

            if( panels.border == "true" ){
                styles['border'] = {};
                styles['border']['border-style'] = elm.css('border-style');
                styles['border']['border-width'] = elm.css('border-width');
                styles['border']['border-color'] = elm.css('border-color');
            }

            if( panels.borderRadius == "true" ){
                styles['border'] = {};
                styles['border']['border-top-left-radius'] = elm.css('border-top-left-radius');
                styles['border']['border-top-right-radius'] = elm.css('border-top-right-radius');
                styles['border']['border-bottom-left-radius'] = elm.css('border-bottom-left-radius');
                styles['border']['border-bottom-right-radius'] = elm.css('border-bottom-right-radius');
            }

            if( panels.other == "true" ){
                styles['border'] = {};
                styles['border']['opacity'] = elm.css('opacity');
                styles['border']['float'] = elm.css('float');
                styles['border']['clear'] = elm.css('clear');
                styles['border']['visibility'] = elm.css('visibility');
                styles['border']['overflow-x'] = elm.css('overflow-x');
                styles['border']['overflow-y'] = elm.css('overflow-y');
            }
            
            update_setup_styles( styles, css_path, panels );
        });
    }

    function update_setup_styles( styles, css_path, panels )
    {
        $.each( styles, function(blocks_key, blocks){
            $.each( blocks, function(key, value){

                var elm = customizer_setup.find("[name='CSB_Import_Settings[" + ( key ) + "]']");
                elm.addClass('CSB_main_class_selector');

                var data = elm.data("type");
                
                if( typeof(data) != "undefined" ){
                    elm.attr( 'data-own', data );
                }
                if( elm.length > 0 ){
                    var type = data || 'none';

                    if( type == 'font_selector' ){
                        value = value.split(',');
                        value = value[0];
                        elm.val( value );

                        elm.trigger( 'change_font' );
                    }

                    if( type == 'slider' ){
                        var _value = value.match(/[a-zA-Z]+|[0-9]+/g);

                        elm.parents(".csb-slider-wrapper").eq(0).find(".csb-slider-container").slider( 'value', _value[0] );
                        elm.val( _value[0] );

                        if( typeof(_value[1]) != "undefined" ){
                            elm.next('select').val( _value[1] );
                        }else{
                            elm.next('select').hide();
                            elm.addClass('csb-rounded-input');
                        }
                    }

                    if( type == 'radio_toggle' ){
                        //elm.val( value );

                        elm.each(function(i){
                            if( $(this).val() == value ){
                                $(this).attr('checked', "checked");
                            }else{
                                $(this).removeAttr('checked');
                            }
                        });
                    }

                    if( type == 'none' ){

                        if( value == 'bold' ) value = '600';
                        elm.val( value );

                        if( elm.hasClass('csb-wp-color-picker') ){
                            elm.trigger('change');
                        }
                    }

                }else{
                    console.log( "unable to find: ", "[name='csb_Import_Settings[" + ( key ) + "]']" );
                }
            });
            //console.log( key, customizer_setup.find("[name='csb_Import_Settings[" + ( key ) + "]']").length  );
        } );

        tabs.data( 'css_path', css_path );

        $.each( css_style, function( blocks_key, value ){
            
            $.each( value, function(key, prop){
                if( blocks_key == css_path ){
                    //console.log( customizer.find(".csb-form-row[data-own='" + ( key ) + "']") );
                    customizer.find(".csb-form-row[data-own='" + ( key ) + "']").addClass("csb-mod-prop");
                }
            });
        });

        if( panels != false ){

            customizer_setup.find(".csb-settings-tabs > li").hide();

            $.each(panels, function(key, value){
                if( value == "true" ){
                    customizer_setup.find('li[data-container="csb-' + ( key ) + '"]').show();
                }
            });
            customizer_setup.show();

            enter_in_edit_mode = false;
        }
    }

    function update_custom_style_iframe()
    {
        var EOL = "\n";
        var _css = [];

        var css_path = tabs.data( 'css_path' );
        $.each( css_style, function( selector, props ){

            var attrs = [];
            $.each(props, function(key, value){

                if( selector == css_path ){
                    customizer.find(".csb-form-row[data-own='" + ( key ) + "']").addClass("csb-mod-prop");
                }

                if( key == 'font-family' ){
                    var __ = value.replace(/'/g, "");                   
                    if( $.inArray(__, csb_safe_fonts) == -1 ){
                        __ = __.split(' ').join('+');
                        if( $.inArray(__, google_fonts) == -1 ){
                            google_fonts.push( __ );
                        }
                    }
                }
                
                attrs.push( key + ': ' + value + " !important;" + EOL );
            });

            if( selector.indexOf('is_hover') > 0 ){
                selector = selector.replace( ".is_hover", ":hover" ) + ", " + selector;
            }

            if( selector.indexOf('body') >= 0 ){
             _css.push( "html " + selector + "{" + EOL );
            }else{
             _css.push( "html body " + selector + "{" + EOL );
            }
            _css.push( attrs.join( "" ) );
            _css.push( "}" + EOL );
        });

        _css =  _css.join("");

        load_web_fonts();
        save_customize_options( _css );

        custom_style.html( _css );

        //console.log(_css );
    }

    function save_customize_options()
    {
        /*var save_btn = customizer.find("#save");
        save_btn.removeAttr('disabled');
        save_btn.val("Save & Publish");
        */
        $.extend( css_style, default_styles );

        //console.log(css_style);
        textarea.val( JSON.stringify( css_style ) );

        textarea.trigger('change');

        //console.log(textarea.val() );
    }

    function load_web_fonts()
    {
        if( google_fonts.length > 0 ){
            var url = 'https://fonts.googleapis.com/css?family=' + google_fonts.join("|");
            custom_web_fonts.attr( 'href', url );
        }
    }

    function update_styles_from_customizer()
    {

        tabs.on('change keyup keydown paste csb_change_color', 'input, select', function( e ){
            
            if( enter_in_edit_mode == true ){
                //console.log('try to enter in observer' );
                return true;
            }
            
            //console.log('in observer' );

            var that = $(this);

            var css_path = tabs.data( 'css_path' );
            
            if( typeof(css_style[css_path]) == "undefined" ){
                css_style[css_path] = {};
            }
            
            if( typeof(default_styles[css_path]) != "null" && typeof(default_styles[css_path]) != "undefined" ){
                css_style[css_path] = default_styles[css_path];
            }

            if( that.hasClass('csb_slider_size_selector') ){
                that = that.prev('input');
            }

            var name = that.attr('name'),
                name = name.split("["),
                name = name[1],
                name = name.replace("]", ''),
                _css = "",
                type = that.data("type") || 'none';
            
            if( name == 'font-family' ){
                _css = "'" + ( that.val() ) + "'";
            }

            else if( name == 'background-image' ){
                _css = "url('" + ( that.val() ) + "')";
            }

            else if( type == 'slider' ){
                _css = that.val() + that.next('select').val();
            }
            else if( type == 'radio_toggle' ){
                _css = (that.val() == 'no' ? 'none' : that.val() );
            }
            else{
                _css = that.val();
            }

            css_style[css_path][name] = _css;

            update_custom_style_iframe();
        });
    }

    function open_tab( that )
    {
        var parent = that.parent('li');

        if( parent.hasClass('csb-tab-open') ){
            parent.removeClass("csb-tab-open");
            return;
        }
        tabs.find(".csb-tab-open").removeClass("csb-tab-open");

        parent.addClass("csb-tab-open");
    }

    function buid_new_css_path( action )
    {
        var css_path = [];
        var _l = current_css_path.find("li").length - 1;
        
        current_css_path.find("li").each(function(i){

            var li = $(this);
            var sub_selectors = li.find('span:not(:first-child):not(.csb-elm-disabled)');

            if( sub_selectors.length >= 1 ){
                css_path.push( li.find('.csb-elm-type').text() );
            }else{
                
                if( i == _l ){
                    css_path.push( li.find('.csb-elm-type').text() );
                }
            }

            sub_selectors.each(function(){
                var span = $(this).clone();
                span.remove('i');

                css_path.push( $.trim(span.text()) );
            });

            if( sub_selectors.length >= 1 ){
                css_path.push(" ");
            }
        });

        css_path = css_path.join("");

        if( action == 'highlight' ){
            highlight_elm( css_path );
        }else{
            return css_path;
        }
    }

    function on_element_top_change(callback){
        var pos = selector_elm.position();
        var last_pos = selector_elm.top, new_top;
        (function run(){
            pos = selector_elm.position();
            new_top = pos.top;
            if( last_pos != new_top )
                callback();
            last_pos = new_top;

            if( selector_elm.onElementTopChangeTimer )
                clearTimeout(selector_elm.onElementTopChangeTimer);

            selector_elm.onElementTopChangeTimer = setTimeout(run, 20);
        })();
    }

    function highlight_elm( css_path )
    {
        DOM_overlay.clear_old_overlays();
        iframe.find( css_path ).each(function(){
            DOM_overlay.build_overlay( $(this) );
        });

        on_element_top_change( function(){
            DOM_overlay.clear_old_overlays();
            iframe.find( css_path ).each(function(){
                DOM_overlay.build_overlay( $(this) );
            });
        });
    }

    function walkDOM(main) 
    {
        var arr = [];
        var loop = function(main) {
            do {
                if(main.nodeType == 1)
                    arr.push(main);
                if(main.hasChildNodes())
                    loop(main.firstChild);
            }
            while (main = main.nextSibling);
        }
        loop(main);
        return arr;
    }

    function generate_selector_map()
    {
        var all_elements = walkDOM( iframe.find('body')[0] )
        $.each( all_elements, function(){
            var elm = $(this);

            var full_css_path = css_path(elm );

            //collector.push( full_css_path );

            //console.log(full_css_path );
            var css_path_obj = filter_to_deep_path( full_css_path );

            elm.attr( "data-csspath", css_path_obj );

            //console.log(elm, ': ', full_css_path , " ----------   ", css_path_obj );
        });

        //var css_path_obj = filter_to_deep_path( collector.join("|") );
        //console.log(css_path_obj );
    }

    function repositioning_marker( force_repos )
    {
        if( force_repos == true ){
            the_content.find('.csb-edit-element-style').removeData('is_pos');
        }

        the_content.find('.csb-edit-element-style').each(function(){
            var marker = $(this);

            if( typeof(marker.data('is_pos')) == "undefined" ){
                var obj_marker = marker.data('obj_marker'),
                    offset = obj_marker.offset(),
                    position = 'left',
                    values = marker.data( 'values');

                if( typeof(values.position) != "undefined" ){

                    if( typeof(values.position.where) != "undefined" && values.position.where == 'right' ){
                        position = 'right';
                    }
                }

                // fix for elements with full page width
                if( offset.left <= 100 ){
                    offset.left = 100;
                }

                var _pos = {
                    'top': offset.top + "px",
                    'left': offset.left + "px"
                };

                if( typeof(values.position) != "undefined" && typeof(values.position.offsetX) != "undefined" ){
                    offset.left = offset.left + parseInt(values.position.offsetX);
                }

                if( typeof(values.position) != "undefined" && typeof(values.position.offsetY) != "undefined" ){
                    offset.top = offset.top + parseInt(values.position.offsetY);
                    _pos['top'] = offset.top + "px";
                }

                if( position == 'right' ){
                    //_pos['left'] = 'auto';

                    _pos['left'] = (offset.left + obj_marker.width() - 50) + "px";

                    //console.log(marker.data('selector'), _pos );
                }else{
                    _pos['left'] = offset.left + "px";
                }

                marker.css(_pos);
                marker.data('is_pos', 'true');

                //console.log(marker.data('selector'));
            }
        });
    }

    function build_selector( selector, values )
    {
        if( typeof(values.only_one) == "string" && values.only_one == "false" ){
            var selector_elm = the_content.find( selector );
        }else{
            var selector_elm = the_content.find( selector ).eq(0);
        }

        var marker  = $("<div />", {
            'class': 'csb-edit-element-style',
            'title': 'Click to edit style for this element.'
        });

        selector_elm.each(function(){
            var that = $(this);

            marker.data('selector', selector );
            marker.data('values', values );

            marker.data( 'obj_marker', that );
            marker.data( 'css_path', selector );

            markers.push( marker );
            //_body.append(marker);
        });
    }

    function apply_the_selector( that, selector, values )
    {
        edit_selector = selector;

        repositioning_marker( true );
        enter_in_edit_mode = true;
        
        var elm_selector = the_content.find(selector),
            menu_item = customizer.find("#accordion-section-csb_setup h3");

        //console.log(customizer );

        //menu_item.click();
        customizer.addClass('csb-editor-active');
        
        var marquee = $('<div class="csb-marquee" />');
        marquee.html( selector );
        customizer.find(".csb-activate-selector").find(".csb-name").html( marquee );

        var close_btn = $("<a class='csb-close-panel' href='#'><i class='csb-icon-cross2'></i></a>");
        customizer.find(".csb-activate-selector").parents('.customize-pane-child').eq(0).find(".customize-section-title").append(close_btn);

        //console.log( selector, selector.indexOf('hover') );
        customizer.find(".csb-switch-field-state-change a.is_on").removeClass('is_on');
        if( selector.indexOf('hover') >= 0 ){
            customizer.find(".csb-switch-field-state-change a").eq(1).addClass('is_on');
        }else{
            customizer.find(".csb-switch-field-state-change a").eq(0).addClass('is_on');
        }

        customizer.data( 'selector_obj', elm_selector );
        customizer.data( 'panels', values.panels );

        //console.log(elm_selector, selector, values.panels );

        //elm_selector.trigger('hover');
        load_element_style( elm_selector, selector, values.panels );

        the_content.find(".csb-edit-element-style").removeClass('csbInEditMode');

        that.addClass('csbInEditMode');
    }

    function mark_selectors()
    {
        the_content = $('#customize-preview iframe').contents();
        if( mode == 'direct' ){
            the_content = $(document);
        }

        if( csb_selectors.length == 0 ){
            the_content.find(".csb-loader").fadeOut(240);
            alert('Invalid customizer-beautify.json format!');
            return true;
        }

        the_content.find('head').append( custom_style );
        the_content.find('head').append( custom_web_fonts );

        // remove static css builder, and add styles into dynamic inline style
        the_content.find("#csb-frontend-style-css").remove();
        update_custom_style_iframe();
        
        $.each( csb_selectors, function(selector, values){
            build_selector( selector, values );
        } );

        // appending the body markers all at once
        var all_markers_wrapper = $("<div />");
        $.each( markers, function(ii){
            var _that = $(this);
            _that.append("<i class='csb-icon-pencil'></i>");
            all_markers_wrapper.append(_that);
        } );
        the_content.find('body').append( all_markers_wrapper );

        the_content.find(".csb-loader").fadeOut(240);

        repositioning_marker( true );
        setInterval( function(){
           repositioning_marker( true );
        }, 2500 );

        the_content.on('click', ".csb-edit-element-style:not(.csbInEditMode)", function(){

            var that = $(this),
                selector = that.data('selector'),
                values = that.data('values');

            tabs.data('values', values);
            tabs.data('edit-element', that);

            apply_the_selector( $(this), selector, values );
        });

        /*the_content.on('mouseenter', '.csb-edit-element-style', function(){
            var that = $(this),
                selector = that.data('selector');

            show_preview( selector );
        });*/
        

        /*setTimeout( function(){
            the_content.find('.csb-edit-element-style').eq(0).click();
        }, 300)*/
    }


    function triggers() 
    {
        update_styles_from_customizer();

        customizer.find("#sub-accordion-section-csb_setup").off().on('click', '.csb-close-panel', function(e){
            e.preventDefault();
            customizer.removeClass('csb-editor-active');
            the_content.find(".csbInEditMode").removeClass('csbInEditMode');
            //repositioning_marker();
        });

        
        $("body").on('click', 'a.csb-crosshairs', function(e){
            e.preventDefault();

            var that = $(this);
            
            if( allow_browse_dom === false ){
                allow_browse_dom = true;
            }else{
                load_plugin_container();

                container = that.data('container');

                //selector_dom_wrapper.show();
                DOM_overlay = DOM_overlay_fn(); 
                //that.hide();
            }
        });

        current_css_path.on('click', '.csb-elm-selector i', function(){
            var that = $(this).parent('span');

            var selected_elements = current_css_path.find("li span:not(:first-child):not(.csb-elm-disabled)").length;
            if( selected_elements <= 2 && !that.hasClass("csb-elm-disabled") ){
                alert("You need to select at least one active selector!");
                return;
            }

            that.toggleClass("csb-elm-disabled");

            buid_new_css_path( 'highlight' );
        });

        tabs.on('click', 'a.csb-tabs-link', function(e){
            e.preventDefault();
            open_tab( $(this) );
        });

        customizer.on('click', '.csb-selector-dom h2 a', function(e){
            e.preventDefault();
            customizer.find(".csb-selector-current").toggleClass("csb-hidden");
        });

        $(".csb-slider-container").each(function(){

            var slider = $(this),
                parent = slider.parents('.csb-form-row').eq(0),
                input = parent.find("input");

            slider.slider({
                orientation: "horizontal",
                range: "min",
                min: slider.data("min"),
                max: slider.data("max"),
                value: slider.data("def"),
                step: slider.data("step") || 1,
                slide: function( event, ui ) {
                    input.val( ui.value );
                    input.trigger('change');
                }
            });

            input.keyup(function(){
                var that = $(this),
                    val = parseInt(that.val());

                slider.slider( "value", val );
            })
        });

        $(".csb-font-selector").each(function(){
            var that = $(this);
            
            that.CSB_FontSelect();
        });

        $('.csb-wp-color-picker').wpColorPicker({
            change: function(event, ui) {
                $(this).trigger('csb_change_color');
            }
        });

        $(".csb-wp-color-picker-material").materialColorPicker({
            container_size: {
                'width': '267px',
                'height': '150px'
            },
            onChange: function( color, elm_obj ){
                var prev_parent_container = elm_obj.prev('.wp-picker-container'),
                    the_picker = prev_parent_container.find(".csb-wp-color-picker");

                prev_parent_container.find(".wp-color-result").css('background-color', color);

                the_picker.val( color );
                the_picker.trigger('csb_change_color');
            }
        });

        customizer.on('click', ".csb-btn-upload", function(e){
            e.preventDefault();

            var that = $(this),
                parent = that.parents(".csb-upload-box-wrapper").eq(0),
                parent_img = parent.find('.csb-upload-image');

            file_frame = wp.media.frames.file_frame = wp.media({
                title: 'Insert a media',
                library: {type: 'image'},
                multiple: false,
                button: {text: 'Insert new image'}
            });

            file_frame.open();

            file_frame.on( 'select', function() {
                // Get media attachment details from the frame state
                var attachment = file_frame.state().get('selection').first().toJSON();

                var img = $("<img />"),
                input = parent.find("input");

                if( parent.data('type') == 'image_preview' ){
                    img.attr( 'src', attachment.sizes.thumbnail.url );
                    input.val( attachment.id );
                }

                if( parent.data('type') == 'as_url' ){
                    input.val( attachment.sizes.full.url);
                    input.trigger('change');
                }

                parent_img.html( img );
            });
        });

        customizer.on('click', ".csb-btn-upload-delete", function(e){
            e.preventDefault();

            if( confirm("Are you sure you want to delete this image?") ){
                var that = $(this),
                    parent = that.parents(".csb-upload-box-wrapper").eq(0),
                    parent_img = parent.find('.csb-upload-image img');

                parent_img.remove();
                parent.find("input").val('none');
                parent.find("input").trigger('change');
            }
        });

        $('body').on("mouseenter", ".csb-customizer-setup .csb-settings-tabs li .csb-form-row > label span:not(.csb-remove-attributes)", function(){
            var that = $(this);

            that.parent().next('div').find(".csb-form-note").css({
                'z-index': 999,
                'display': 'block',
                'opacity': 1
            });
        });

        $('body').on("mouseleave", ".csb-customizer-setup .csb-settings-tabs li .csb-form-row > label span:not(.csb-remove-attributes)", function(){
            var that = $(this);

            that.parent().next('div').find(".csb-form-note").css({
                'z-index': 0,
                'opacity': 0,
                'display': 'none'
            });
        });

        $('body').on('click', '.csb-remove-attributes', function(e){
            e.preventDefault();

            var that            = $(this),
                parent          = that.parents('.csb-form-row'),
                prop            = parent.data('own'),
                curr_selector    = tabs.data( 'css_path' );

            $.each( css_style, function( selector, props ){
                if( curr_selector == selector ){
                    delete css_style[selector][prop];
                }
            });

            //load_element_style( customizer.data('selector_obj').eq(0), curr_selector, false );
            update_custom_style_iframe();

            // refresh the style in configurator 
            var curr_element_selector = the_content.find(curr_selector).eq(0);
            load_element_style( curr_element_selector, curr_selector, customizer.data('panels') );

            parent.removeClass('csb-mod-prop');
            //that.hide();
        });

        $('body').on('click', '.csb-switch-field-state-change a', function(e){
            e.preventDefault();

            var that = $(this),
                parent = that.parent('div'),
                href = that.attr('href').replace("#", ""),
                curr_selector  = tabs.data( 'css_path' );

            /*parent.find('a.is_on').removeClass("is_on");
            parent.find(".csbInEditMode").removeClass("csbInEditMode");
            that.addClass('is_on');
            console.log(parent );*/

            if( href == 'hover' ){
                if( !the_content.find(curr_selector).hasClass('is_hover') ){
                    the_content.find(curr_selector).addClass("is_hover");
                }
                curr_selector = curr_selector + ".is_hover";
            }

            if( href == 'normal' ){
                the_content.find(".is_hover").removeClass("is_hover");
                curr_selector = curr_selector.replace( ".is_hover", "", );
            }
            
            var values = tabs.data('values');

            apply_the_selector( tabs.data('edit-element' ), curr_selector, values );
        });

        $('body').on('click', 'a.csb-full-reset', function(e){
            e.preventDefault();

            var curr_selector  = tabs.data( 'css_path' );
            if( confirm('Properties of element: ' + ( curr_selector ) + ' will be reset to Theme Defaults after saving?') ){
                $.each( css_style, function( selector, props ){
                    if( curr_selector == selector ){
                        delete css_style[selector];
                    }
                });

                 $.each( default_styles, function( selector, props ){
                    if( curr_selector == selector ){
                        delete default_styles[selector];
                    }
                });

                update_custom_style_iframe();

                // refresh the style in configurator 
                var curr_element_selector = the_content.find(curr_selector).eq(0);
                load_element_style( curr_element_selector, curr_selector, false );

                customizer.find('.csb-mod-prop').removeClass('csb-mod-prop');
            }
        });
    }

    // external usage
    return {
    }
})(jQuery);