<?php
/*
Plugin Name: Customizer Site Beautify - Beta
Plugin URI: http://www.aa-team.com
Description: Beautify your theme using wordpress customizer in just a few clicks! This plugin was created by AA-Team specially for customizing AA-Team Themes & Plugins.
Version: 1.1
Author: AA-Team
Author URI: http://www.aa-team.com
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if(class_exists('CSB') != true) {
	class CSB {
		
		const VERSION = '1.0';

		public $alias = 'csb';
		public $updater_dev = null;
		public $plugin_name = 'Customizer Site Beautify';
		
		/**
		 * parent storage
		 *
		 * @var array
		 */
		public $parent = array();

		protected static $instance = null;

		private $layout_options = array();
		private $google_fonts = array();
		private $safe_fonts = array();

		/**
		 * The wp_filesystem object
		 */
		public $wp_filesystem = null;

		public $theme_selectors = array();
		
		/**
		 * The constructor
		 */
		public function __construct()
		{
			if( defined('UPDATER_DEV') ) {
				$this->updater_dev = (string) UPDATER_DEV;
			}
			$dir = dirname( __FILE__ );
			$upload_dir = wp_upload_dir();

			$this->setPaths( array(
				'APP_ROOT' 				=> $dir,
				'WP_ROOT' 				=> preg_replace( '/$\//', '', ABSPATH ),
				'APP_DIR' 				=> basename( $dir ),
				'CONFIG_DIR' 			=> $dir . '/config',
				'ASSETS_DIR' 			=> $dir . '/assets',
				'ASSETS_URL'  			=> plugin_dir_url( __FILE__ ) . '/assets',
				'ASSETS_DIR_NAME' 		=> 'assets',
				'TEMPLATES_DIR_NAME' 	=> 'templates',
				'APP_URL'  				=> plugin_dir_url( __FILE__ ),
				'UPLOAD_BASE_DIR'  		=> $upload_dir['basedir'],
				'UPLOAD_BASE_URL'  		=> $upload_dir['baseurl'],
				'CUSTOMIZER_DIR' 		=> $dir . '/include/customizer',
				'CUSTOMIZER_URL'  		=> plugin_dir_url( __FILE__ ) . 'include/customizer',
				'INCLUDE_DIR' 			=> $dir . '/include',
			) );

			// load WP_Filesystem 
			include_once ABSPATH . 'wp-admin/includes/file.php';
		   	WP_Filesystem();
			global $wp_filesystem;
			$this->wp_filesystem = $wp_filesystem;

			require_once $this->path( 'INCLUDE_DIR', 'helpers.php' );
			require_once $this->path( 'INCLUDE_DIR', 'settings.class.php' );

			add_action( 'customize_register', array( $this, 'load_custom_controls' ) );
			add_action( 'customize_register', array( $this, 'customize_register' ) );

			// Control scripts
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ) );
			//add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_control_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'frontend_load_style' ) );


			add_action( 'wp_head', array( $this, 'loader' ) );
			add_action( 'customize_save_after', array( $this, 'customizer_save_after' ) );

			add_action('wp_ajax_' . ( $this->alias ) . '_frontend_style', array( $this, 'frontend_style') );
			add_action('wp_ajax_nopriv_' . ( $this->alias ) . '_frontend_style', array( $this, 'frontend_style') );

	        // product updater
			add_action( 'admin_init', array($this, 'product_updater') );

				if ( !is_admin() ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'add_styles' ), 100);
			}

			require_once( $this->path( 'CUSTOMIZER_DIR', "/init.class.php" ) );


			$this->default_fonts();
			$this->set_layout_options();

			$this->get_theme_selectors();
			$this->get_plugins_selectors();
		}

		 /**
		 * Gets updater instance.
		 *
		 * @return AATeam_Product_Updater
		 */
		public function product_updater() {
			require_once( 'assets/class-updater.php' );
			
			if( class_exists('Beautify_AATeam_Product_Updater') ){
				$product_data = get_plugin_data( __FILE__, false ); 
				new Beautify_AATeam_Product_Updater( $this, $product_data['Version'], 'customizer-site-beautify', 'customizer-site-beautify/beautify.php' );
			}
		}

		/**
		 * Get current mode for MG.
		 *
		 * @since  1.0
		 * @access public
		 *
		 * @return string
		 */
		public function mode() {
			return $this->mode;
		}

		/**
		 * Setter for paths
		 *
		 * @since  1.0
		 * @access protected
		 *
		 * @param $paths
		 */
		protected function setPaths( $paths ) {
			$this->paths = $paths;
		}

		/**
		 * Gets absolute path for file/directory in filesystem.
		 *
		 * @since  1.0
		 * @access public
		 *
		 * @param $name - name of path dir
		 * @param string $file - file name or directory inside path
		 *
		 * @return string
		 */
		public function path( $name, $file = '' ) {
			$path = $this->paths[ $name ] . ( strlen( $file ) > 0 ? '/' . preg_replace( '/^\//', '', $file ) : '' );

			return apply_filters( 'MG_path_filter', $path );
		}

		public function load_custom_controls()
		{
			foreach( glob( $this->path( 'CUSTOMIZER_DIR', "/controls/*/init.class.php" ) ) as $control ){
				require_once $control;
			}  
		}

		public function default_fonts()
		{
			array_push( $this->safe_fonts, "Arial, Helvetica, sans-serif" );
			array_push( $this->safe_fonts, "Arial Black, Gadget, sans-serif" );
			array_push( $this->safe_fonts, "Georgia, serif" );
			array_push( $this->safe_fonts, "Helvetica Neue" );
			array_push( $this->safe_fonts, "Impact, Charcoal, sans-serif" );
			array_push( $this->safe_fonts, "Tahoma, Geneva, sans-serif" );
			array_push( $this->safe_fonts, "Times New Roman, Times, serif" );
			array_push( $this->safe_fonts, "Verdana, Geneva, sans-serif" );
		}

		public function frontend_load_style()
		{
			wp_enqueue_style(
				$this->alias . '-frontend',
				$this->path( 'CUSTOMIZER_URL', 'frontend.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_style(
				$this->alias . '-icons',
				$this->path( 'ASSETS_URL', 'csb-icons.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_style(
				$this->alias . '-loader',
				$this->path( 'ASSETS_URL', 'loader.css' ),
				array( ),
				self::VERSION
			);
		}

		public function enqueue_control_scripts() 
		{
			wp_enqueue_script(
				$this->alias . '-controls',
				$this->path( 'CUSTOMIZER_URL', 'app.class.js' ),
				array( 'jquery' ,'customize-preview' ),
				self::VERSION,
				true
			);

			wp_enqueue_script(
				$this->alias . '-color-picker-extends',
				$this->path( 'ASSETS_URL', 'color-picker.js' ),
				array( 'jquery', $this->alias . '-controls' ),
				self::VERSION,
				true
			);

			wp_enqueue_style(
				$this->alias . '-controls',
				$this->path( 'CUSTOMIZER_URL', 'styles.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_style(
				$this->alias . '-color-picker-extends',
				$this->path( 'ASSETS_URL', 'color-picker.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_style(
				$this->alias . '-settings',
				$this->path( 'ASSETS_URL', 'settings.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_style(
				$this->alias . '-icons',
				$this->path( 'ASSETS_URL', 'csb-icons.css' ),
				array( ),
				self::VERSION
			);

			wp_enqueue_script( $this->alias . '-font-selector', $this->path( 'ASSETS_URL', 'fonts.class.js' ), array(), '1.0.0' );

			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-slider' );
			wp_enqueue_style( 'jquery-style', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css' );

			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker');

			// Register the script
			wp_localize_script( $this->alias . '-controls', $this->alias . '_selectors', $this->theme_selectors);
			wp_enqueue_script( $this->alias . '_selectors' );
			
			wp_localize_script( $this->alias . '-controls', $this->alias . '_layout_options', $this->layout_options);
			wp_enqueue_script( $this->alias . '_layout_options' );

			//wp_add_inline_script( $this->alias . '-controls', 'jQuery(document).ready(function(){CSB.mark_selectors( jQuery(this) );});' );
		}

		public static function getInstance()
	    {
	        if (!isset(static::$instance)) {
	            static::$instance = new static();
	        }
	        return static::$instance;
	    }

	    public function add_styles()
		{
			$protocol = is_ssl() ? 'https' : 'http';
			$main_style = admin_url('admin-ajax.php?action=' . ( $this->alias ) . '_frontend_style');

			if( is_array($this->google_fonts) && count($this->google_fonts) > 0 ){
				$google_fonts_url = 'https://fonts.googleapis.com/css?family=' . implode( "|", $this->google_fonts );
				$google_fonts_url = str_replace( " ", "+", $google_fonts_url);

				wp_enqueue_style( $this->alias . '-google-fonts',	$google_fonts_url, array() );
			}

			wp_enqueue_style( $this->alias . '-frontend-style',	$main_style, array() );
		}

	    public function frontend_style()
	    {
    		// Enable caching
			header('Cache-Control: public');
			 
			// Expire in one day
			header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
			 
			// Set the correct MIME type, because Apache won't set it for us
			header("Content-type: text/css");

			$css = array();
			if( $this->layout_options && is_array($this->layout_options) && count($this->layout_options) > 0){
				foreach ($this->layout_options as $selector => $props) {

					if( strpos( $selector, '.is_hover') ){
						$selector = str_replace( ".is_hover", ":hover", $selector ) . ", " . $selector;
					}

					$selector = str_replace( "body", "", $selector );

					//die( var_dump( "<pre>", $selector  , "<pre>" ) . PHP_EOL .  __FILE__ . ":" . __LINE__  ); 

					$css[] = "html body " . $selector . "{";
					if( !empty($props) && is_array($props) && count($props) > 0 ){
						foreach ($props as $key => $value) {
							$css[] = $key . ": " . $value . ' !important;';
						}
					}
					$css[] = "}";
				}
			}

			$css = implode( "\n", $css );

			//die( var_dump( "<pre>", $css  , "<pre>" ) . PHP_EOL .  __FILE__ . ":" . __LINE__  ); 

			// Remove whitespace
			$css = str_replace(array("\r\n", "\r", "\n", "\t", '    ', '    '), '', $css);

			echo $css;
			die;
		}

		private function set_layout_options()
		{
			$options = get_option( $this->alias . '_layout' );
			if( $options && !empty($options) ){
				$options = json_decode( $options, true );
				if( $options && is_array($options) && count($options) > 0 ){

					// search for custom google fonts
					foreach ($options as $selector => $props) {
						if( $props && !empty($props) && count($props) > 0 ){
							foreach ($props as $key => $prop) {
								if( $key == 'font-family' ){
									$prop = trim( $prop, "'" );

									if( !in_array( $prop, $this->safe_fonts) ){
										array_push( $this->google_fonts, $prop );
									}
								}
							}
						}
					}
					$this->layout_options = $options;
				}
			}
		}

		public function customizer_save_after()
	    {
	    	
	    	$options  = json_decode( stripslashes_deep( $_REQUEST['customized'] ), true );

	    	if( !isset($options['csb_layout']) ){
	    		return false;
	    	}

	    	$layout = isset($options[$this->alias . '_layout']) ? $options[$this->alias . '_layout'] : array();
	    	update_option( $this->alias . '_layout', $layout );
	    }

		public function customize_register( $wp_customize ) 
		{
		    $wp_customize->add_section(
		    	$this->alias . '_setup', array(
			        'title'         => $this->plugin_name . " Setup",
			        'capability' => 'edit_theme_options',
            		'description' => '',
			        'priority'		=> 5,
		    	)
		    );

		    // adding setting for copyright text
		    $wp_customize->add_setting(
		    		$this->alias . '_template_setup', array(
		        	'default'        => ''
		    	)
		    );

			$wp_customize->add_control( new CSB_Customize_Smart_Selector_Control( 
				$wp_customize, 
				'footer_credits_control', 
				array(
					'label'	=> 'Footer Credits',
					'section' => $this->alias . '_setup',
					'settings' => $this->alias . '_template_setup'
				) 
			));

			//adding setting for footer text area
			$wp_customize->add_setting( $this->alias . '_layout', array(
				'default'        => 'Default Text For Footer Section',
				'transport'		=> 'postMessage'
			));

			$wp_customize->add_control( $this->alias . '_layout', array(
				'section' => $this->alias . '_setup',
				'type'    => 'textarea',
			));
		}

		public function getAllGfonts( $what='all' ) 
		{
			$file = $this->path( 'ASSETS_DIR', 'fonts/google-webfonts.json' );
			$fonts = json_decode( $this->wp_filesystem->get_contents( $file ), true);
	 
			$ret_fonts = array();
			//$ret_fonts['none'] = 'Theme default font';
			if(count($fonts) > 0 ){ 
				foreach ( $fonts as $font ) {
					$ret_fonts[] = $font;
				}
			}
			
			if( $what == 'all' ){ 
				return $ret_fonts;
			}
		}

		public function get_plugins_selectors()
		{
			$active_plugins = get_option('active_plugins'); 
			$plugins_dir = str_replace( basename(__DIR__) . "/", "", plugin_dir_path( __FILE__ ) );
			
			if( $active_plugins ){
				if( is_array($active_plugins) && count($active_plugins) > 0 ){
					foreach ($active_plugins as $plugin) {
						//$plugins_dir = 
						$plugin = explode( "/", $plugin );
						$plugin_folder = $plugins_dir . $plugin[0];

						// check if your theme has selectors 
						$_cb_json = $plugin_folder . '/' . 'customizer-beautify.json';
						if( is_file($_cb_json) ){
							$content = $this->wp_filesystem->get_contents( $_cb_json );
							if( trim($content) !=  "" ){
								$content = json_decode( $content, true );
								if( $content && is_array($content) ){
									//$this->theme_selectors = $content;
									$this->theme_selectors = array_merge( $this->theme_selectors, $content );
								}
							}
						}
					}
				} 
			}
		}

		public function get_theme_selectors()
		{
			$current_theme = wp_get_theme();

			// check if your theme has selectors 
			$_cb_json = get_template_directory() . '/' . 'customizer-beautify.json';
			if( is_file($_cb_json) ){
				$content = $this->wp_filesystem->get_contents( $_cb_json );
				if( trim($content) !=  "" ){
					$content = json_decode( $content, true );
					if( $content && is_array($content) ){
						$this->theme_selectors = array_merge( $this->theme_selectors, $content );
					}
				}
			}
		}

		public function loader()
		{
			if( isset($_REQUEST['customize_theme']) && trim($_REQUEST['customize_theme']) != "" ){
				$html = array();
				$html[] = '<div class="' . ( $this->alias ) . '-loader">';
				$html[] = 	'<span> Customizer Site Beautify Loading ...</span>';
				//$html[] = 	'<span> <img src="' . ( $this->path( 'ASSETS_URL', '/images/beautify.gif' ) ) . '"/></span>';
				$html[] = '</div>';
				echo implode( "\n", $html );
			}
		}
	}
}

/**
 * Main MG manager.
 * @var MG $MG - instance of composer management.
 * @since 1.0
 */
global $CSB;
$CSB = CSB::getInstance();