<?php
/**
 * Variable product add to cart
 *
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
$kingdom = kingdom();
$kingdom_core = kingdom()->coreFunctions;
$enable_color_insteadofdropdown = get_theme_mod('enable_color_insteadofdropdown', $kingdom_core->defaults_theme["enable_color_insteadofdropdown"]);

$attribute_keys = array_keys( $attributes );

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<form class="variations_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo esc_attr( json_encode( $available_variations ) ) ?>">
	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
		<p class="stock out-of-stock"><?php _e( 'This product is currently out of stock and unavailable.', 'kingdom' ); ?></p>
	<?php else : ?>
		<div class="variations">
			<?php $loop = 0; foreach ( $attributes as $attribute_name => $options ) : $loop++;?>
					<div class="kd_pick_up_color kd_size">
						<p><?php echo wc_attribute_label( $attribute_name ); ?></p>
						<div class="kd_dropdown_pick_up_color kd_choosesize btn-group kd_custom_select <?php if( $enable_color_insteadofdropdown == 'YES' && $attribute_name == 'pa_color' ) echo 'kd_pick_up_color_select'; ?>">
							<?php
								$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) : $product->get_variation_default_attribute( $attribute_name );
								wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected ) );

							?>
						</div>
						<?php

							// construct colors views
							if( $enable_color_insteadofdropdown == 'YES' && $attribute_name == 'pa_color' ) {
								//echo 'TODO: Work in progress...';
								echo '<div class="kd_pickup_color_images">';

								foreach ( $available_variations as $available_variation ) {
									echo '<a href="#" class="kd_pickup_color_image_variation_container" data-variation_color="' . $available_variation['attributes']['attribute_pa_color'] .'">';
									echo 	'<img src="' . $available_variation['image']['thumb_src'] .'" class="kd_pickup_color_image_variation" />';
									echo '</a>';
								}

								echo '</div>';

							}

						?>

					</div>
				<?php
				if ( sizeof( $attributes ) === $loop )
					echo '<div class="kd_variations"><a class="reset_variations" href="#reset">' . esc_html__( 'Clear selection', 'kingdom' ) . '</a></div>';
				?>
	        <?php endforeach;?>
		</div>
		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<div class="single_variation_wrap" style="display:none;">
			<?php do_action( 'woocommerce_before_single_variation' ); ?>

			<div class="single_variation"></div>

			<div class="variations_button">
				<?php woocommerce_quantity_input(); ?>
				<button type="submit" class="btn_addcart alt"><?php echo $product->single_add_to_cart_text(); ?></button>
			</div>

			<input type="hidden" name="add-to-cart" value="<?php echo absint( $product->get_id() ); ?>" />
			<input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
			<input type="hidden" name="variation_id" value="" />

			<?php do_action( 'woocommerce_after_single_variation' ); ?>
		</div>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	<?php endif; ?>

</form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>
