<?php
/**
 * Show options for ordering
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     5.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $woocommerce, $wp_query;

if ( 1 == $wp_query->found_posts || ! woocommerce_products_will_display() )
	return;
?>
<form class="woocommerce-ordering" method="get">
	<select name="orderby" class="orderby">
		<?php
			$catalog_orderby = apply_filters( 'woocommerce_catalog_orderby', array(
				'menu_order' => esc_html__( 'Default sorting', 'kingdom' ),
				'popularity' => esc_html__( 'Sort by popularity', 'kingdom' ),
				'rating'     => esc_html__( 'Sort by average rating', 'kingdom' ),
				'date'       => esc_html__( 'Sort by newness', 'kingdom' ),
				'price'      => esc_html__( 'Sort by price: low to high', 'kingdom' ),
				'price-desc' => esc_html__( 'Sort by price: high to low', 'kingdom' )
			) );
			
			unset( $catalog_orderby['popularity'] );
			unset( $catalog_orderby['rating'] );
			// if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' )
				// unset( $catalog_orderby['rating'] );

			foreach ( $catalog_orderby as $id => $name )
				echo '<option value="' . esc_attr( $id ) . '" ' . selected( $orderby, $id, false ) . '>' . esc_attr( $name ) . '</option>';
		?>
	</select>
	<?php
		// Keep query string vars intact
		foreach ( $_GET as $key => $val ) {
			if ( 'orderby' === $key || 'submit' === $key )
				continue;
			
			if ( is_array( $val ) ) {
				foreach( $val as $innerVal ) {
					echo '<input type="hidden" name="' . esc_attr( $key ) . '[]" value="' . esc_attr( $innerVal ) . '" />';
				}
			
			} else {
				echo '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '" />';
			}
		}
	?>
</form>
