<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     5.0
 */
global $product, $WooZone;
$kingdom = kingdom();
$kingdom_core = kingdom()->coreFunctions;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$product_cats = null;
$product_cats = get_the_terms( $post->ID, 'product_cat' );

if( isset( $product_terms ) && is_array( $product_terms ) ) {
	$cat_count =  sizeof( $product_cats );
}
else {
	$cat_count =  0;
}

$product_tags = null;
$product_tags = get_the_terms( $post->ID, 'product_tag' );

if( isset( $product_terms ) && is_array( $product_terms ) ) {
	$tag_count =  sizeof( $product_tags );
}
else {
	$tag_count = 0;
}

?>

<?php
	/**
	 * woocommerce_before_single_product hook
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>

<div id="product-<?php the_ID(); ?>" <?php post_class( array('kingdom-prod-details', 'col-lg-12') ); ?>>
	<meta itemprop="url" content="<?php the_permalink(); ?>" />
	<div class="row">
		<div class="col-lg-5">
			<?php
				/**
				 * woocommerce_before_single_product_summary hook
				 *
				 * @hooked woocommerce_show_product_sale_flash - 10
				 * @hooked woocommerce_show_product_images - 20
				 */
				woocommerce_show_product_images();
			?>
		</div>
		
		<div class="col-lg-7">
	
			<?php
				/**
				 * woocommerce_single_product_summary hook
				 *
				 * @hooked woocommerce_template_single_title - 5
				 * @hooked woocommerce_template_single_rating - 10
				 * @hooked woocommerce_template_single_price - 10
				 * @hooked woocommerce_template_single_excerpt - 20
				 * @hooked woocommerce_template_single_add_to_cart - 30
				 * @hooked woocommerce_template_single_meta - 40
				 * @hooked woocommerce_template_single_sharing - 50
				 */
				//do_action( 'woocommerce_single_product_summary' );
			$rating_type = get_theme_mod('rating_type', $kingdom_core->defaults_theme["rating_type"]);
			$show_star_rating = get_theme_mod('show_star_rating', $kingdom_core->defaults_theme["show_star_rating"]);
			if( $show_star_rating == 'YES' && $rating_type == 'own' ) {
			?>
				<div class="kd_product_rating_pagination">
					<?php
					$_product_rating = (float)get_post_meta( $post->ID, '_product_rating', true );
					$_product_votes = (int)get_post_meta( $post->ID, '_product_votes', true );

					
					$rating = 0;
					if( $_product_votes == 0 ){
						$rating = 0;
					}else {
						$rating = (float)$_product_rating / $_product_votes;
					}
					?>
					<h2> Rating: </h2>
					<div class="show-amazon-rating kd-own-rating">
						<div class="star-rating" data-productid="<?php echo $product->get_id() ; ?>"><span style="width:<?php echo ($rating * 100 / 5);?>%"></span></div>
					</div>
					<ul class="kd_pager">
			            <li><?php previous_post_link('%link', esc_html__('Previous', 'kingdom')); ?></li>
						<li><?php next_post_link('%link', esc_html__(' / Next', 'kingdom')); ?></li>
			        </ul>
				</div>
			<?php 
			}elseif( $show_star_rating == 'YES' && $rating_type == 'amazon' ) {
				
				$asin = get_post_meta( $post->ID, '_amzASIN', true );
				if( $asin == false || empty($asin) || trim($asin) == "" ){
					$asin = 'invalid';
				}
				if( $asin != 'invalid' ){
			?>
					<div class="kd_product_rating_pagination">
						<h2> Rating: </h2>
						<div class="show-amazon-rating">
							<?php 
								// get cached rating 
								$cached_rating = get_post_meta( $product->get_id(), '_kd_amz_rating', true );
								$cached_rating_when = get_post_meta( $product->get_id(), '_kd_amz_rating_when', true );
								
								if( $cached_rating != false && $cached_rating_when != false && isset($cached_rating) && isset($cached_rating_when) ){
									if( time() - 172800 /* 48 hours */ <  $cached_rating_when) {
										echo wc_get_rating_html( floatval($cached_rating) );
							?>
										<input class="rating cached-rating" data-max="5" value="<?php echo (int)$cached_rating;?>" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
										<em><?php echo '(As Of ' . ( date('F j, Y, g:i a', $cached_rating_when ) ) . ')'; ?></em>
									<?php } else { ?>
										<input class="not_rating_yet" data-max="5" value="0" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
										<span class="the_loader"></span>
									<?php }
								} else { ?>
									<input class="not_rating_yet" data-max="5" value="0" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
									<span class="the_loader"></span>
								<?php
								}
								?>
						</div>
						<ul class="kd_pager">
				            <li><?php previous_post_link('%link', esc_html__('Previous', 'kingdom')); ?></li>
							<li><?php next_post_link('%link', esc_html__(' / Next', 'kingdom')); ?></li>
				        </ul>
					</div>
			<?php 
				}
			}
			?>
		
		    <div class="kd_description">
		        <?php woocommerce_template_single_title();?>
		        <h2><?php woocommerce_template_single_price();?></h2>
		        <div id="kd_general_description">
                    <?php
                        $gdt = get_theme_mod('product_general_description_type', $kingdom_core->defaults_theme["product_general_description_type"]);
						
                        if ( 'first_paragraph' == $gdt ) {
                            echo str_replace('[gallery]', '', apply_filters('the_content', $kingdom->coreFunctions->get_first_paragraph()));
                        } else {
                            woocommerce_template_single_excerpt();
                        }
                    ?>
		        </div>
				<?php 
				$enable_product_in_category = get_theme_mod('enable_product_in_category', $kingdom_core->defaults_theme["enable_product_in_category"]); 
				$enable_product_tags = get_theme_mod('enable_product_tags', $kingdom_core->defaults_theme["enable_product_tags"])
				?>
		        <?php if( $enable_product_in_category == 'YES' ) { ?>
					<h3 class="kd_post_in_cat"><?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', $cat_count, 'kingdom' ) . ' ', '.</span>' ); ?></h3>
				<?php } ?>
				<?php if( $enable_product_tags == 'YES' ) { ?>
					<h3 class="kd_post_in_tags"><?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'kingdom' ) . ' ', '.</span>' ); ?></h3>
				<?php } ?>
				
				<?php
					kingdom()->coreFunctions->print_WooZone_country_box();
					woocommerce_template_single_add_to_cart();
				?>
		
		        <div class="kd_social_share">
		            <?php 
				 		$kingdom->coreFunctions->print_share_buttons( $post->ID, $post->post_title );
				 	?>
		        </div>
		    </div>
		</div>
	</div>
	
	<?php
		/**
		 * woocommerce_after_single_product_summary hook
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_output_related_products - 20
		 */
		woocommerce_output_product_data_tabs();
		//do_action( 'woocommerce_after_single_product_summary' );
	?>

</div><!-- #product-<?php the_ID(); ?> -->

<?php do_action( 'woocommerce_after_single_product' ); ?>
