<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $kingdom, $product, $woocommerce_loop, $row, $item_size_class, $wp_query;
$kingdom_core = kingdom()->coreFunctions;
 
if( !is_front_page() /*&& is_page()*/ ) {
	//die( __FILE__ . ":" . __LINE__  );
	$row = !isset($row) ? 0 : $row;
	
	if ( $woocommerce_loop['loop'] % 3 == 0 ) {
		$row++;
	}

}
  
// Oh, the wonders of the alternate shop page
$shop_template = get_theme_mod('shop_template', $kingdom_core->defaults_theme["shop_template"]);
$products_per_page = get_theme_mod('products_per_page', $kingdom_core->defaults_theme["products_per_page"]);
if ($products_per_page % 3 == 0) {
	$rows = $products_per_page / 3;
}
else {
	$rows = ($products_per_page / 3) + 1;
}
 
// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Increase loop count
$woocommerce_loop['loop']++;

// Extra post classes
$classes = array();
if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
	$classes[] = 'first';
}
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
	$classes[] = 'last';
}

$item_size_class = isset($woocommerce_loop['item_size_class']) ? $woocommerce_loop['item_size_class'] : '';//'col-lg-3 col-sm-3 col-xs-12';

if( (is_product_taxonomy() || is_product_category() || is_shop() || (!is_front_page() && is_page())) && !is_product() || is_search() ) {
	if( isset($kingdom->coreFunctions->data['page_sidebars']) && count($kingdom->coreFunctions->data['page_sidebars']) > 0 && !is_search() ){
		if( !isset($woocommerce_loop['where']) || $woocommerce_loop['where'] != "related" ) {
			// Tweak for alternate shop page
			if ( $shop_template == 'regular' ) {
				$item_size_class = 'col-lg-' . ( isset($_COOKIE['kd_shop_columns_list']) ? $_COOKIE['kd_shop_columns_list'] : 4 ) . ' col-sm-12 col-md-12 col-xs-12';
			}
			else {
				if( $row % 2 == 1 ) {
					if( $woocommerce_loop['loop'] % 3 == 1) {
						$item_size_class = 'col-lg-5 col-sm-12 col-md-12 col-xs-12 no-padding-alternate';
					}
					else {
						$item_size_class = 'col-lg-12 col-sm-12 col-md-12 col-xs-12';	
					}		
				}
				else {
					if( $woocommerce_loop['loop'] % 3 == 1) {
						$item_size_class = 'col-lg-12 col-sm-12 col-md-12 col-xs-12';
					}
					else {
						$item_size_class = 'col-lg-5 col-sm-12 col-md-12 col-xs-12 no-padding-alternate';
					}		
				}
			}
		} elseif( $woocommerce_loop['where'] == "related" ) {
			$woocommerce_loop['columns'] = 3;
		}
	}
	else {
		if ( $shop_template == 'regular' ) {
			$item_size_class = 'col-lg-3 col-sm-6';
		}
		else {
			$item_size_class = 'col-lg-7 col-sm-6 no-padding-alternate';
		}
	}

	if( $shop_template == 'alternate') {

		if( $row % 2 == 1 ) {
			if( $woocommerce_loop['loop'] % 3 == 1) {
				// each row
				echo '<div class="row">';
			}
			if( $woocommerce_loop['loop'] % 3 == 2) {
				// small items' container
				if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search()  ) {
					echo '<div class="col-lg-5 col-md-12 col-sm-12 col-xs-12 no-padding-left">';
				}
				else {
					echo '<div class="col-lg-7 col-sm-12 col-md-12 col-xs-12 no-padding-left">';
				}
			}
		 	
			if( $woocommerce_loop['loop'] % 3 != 1) {
				// row inside col-lg-7 for each small item
				if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search() ) {
					$item_size_class = 'col-lg-12';
				}
					echo 	'<div class="row">';
			}
		}
		else {
			if( $woocommerce_loop['loop'] % 3 == 1) {
				echo '<div class="row">';
			}
			if( $woocommerce_loop['loop'] % 3 == 1) {
				if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search() ) {
					echo '<div class="col-lg-5">';
				}
				else {
					echo '<div class="col-lg-7 col-sm-12 col-md-12 col-xs-12 no-padding-left">';
				}
			}
		 	
			if( $woocommerce_loop['loop'] % 3 != 0) {
				if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search() ) {
					$item_size_class = 'col-lg-12';
				}
				echo 	'<div class="row">';
			}

		}
	}
	else {
		if( $woocommerce_loop['loop'] % 3 == 1 && $woocommerce_loop == 1) {
			echo '</div>';
		}
	}
	
}
?>


<div class="<?php 
				if ($shop_template == 'alternate' && (is_product_taxonomy() || is_product_category() || is_shop() || (!is_front_page() && is_page())) && !is_product() || ( is_search() && $shop_template == 'alternate') ) {
					if ( $row % 2 == 1 ) {
						echo ( $woocommerce_loop['loop'] % 3 != 1)  ? 'small-item': 'item';
					}
					else {
						echo ( $woocommerce_loop['loop'] % 3 != 0)  ? 'small-item': 'item';
					}
				}
				else {
					echo 'item';
				}

				?> <?php echo esc_attr( $item_size_class );?>" id="product-<?php echo esc_attr( $product->get_id() );?>" data-columns="<?php echo $woocommerce_loop['columns']; ?>">

	
	
	<div class="kd_hp_item">
		<div class="kd_hp_item_image">
			<?php woocommerce_show_product_sale_flash(); ?>
			<?php
			$rating_type = get_theme_mod('rating_type', $kingdom_core->defaults_theme["rating_type"]);
			$show_star_rating = get_theme_mod('show_star_rating', $kingdom_core->defaults_theme["show_star_rating"]);
			if( $show_star_rating == 'YES' && $rating_type == 'own' ) {
			
				$_product_rating = (int)get_post_meta( $product->get_id(), '_product_rating', true );
				$_product_votes = (int)get_post_meta( $product->get_id(), '_product_votes', true );
				
				if( $_product_votes == 0 ){
					$rating = 0;
				}else {
					$rating = floor($_product_rating / $_product_votes);
				} 
			?>
				<div class="show-amazon-rating kd-own-rating">
					<div class="star-rating" data-productid="<?php echo $product->get_id() ; ?>"><span style="width:<?php echo ($rating * 100 / 5);?>%"></span></div>
				</div>
			<?php 
			}elseif( $show_star_rating == 'YES' && $rating_type == 'amazon' ) {
				
				$asin = get_post_meta( $product->get_id(), '_amzASIN', true );
				if( $asin == false || empty($asin) || trim($asin) == "" ){
					$asin = 'invalid';
				}
				if( $asin != 'invalid' ){
			?>	
				<div class="show-amazon-rating">
					<?php 
						// get cached rating 
						$cached_rating = get_post_meta( $product->get_id(), '_kd_amz_rating', true );
						$cached_rating_when = get_post_meta( $product->get_id(), '_kd_amz_rating_when', true );
						if( $cached_rating != false && $cached_rating_when != false && isset($cached_rating) && isset($cached_rating_when) ){
							if( time() - 172800 /* 48 hours */ <  $cached_rating_when ) {
								echo wc_get_rating_html( floatval($cached_rating) )
					?>
								<input class="rating cached-rating" data-max="5" value="<?php echo (int)$cached_rating;?>" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
					<?php } else { ?>	
								<input class="not_rating_yet" data-max="5" value="0" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
								<span class="the_loader"></span>
					<?php
							}
						}else{
					?>
							<input class="not_rating_yet" data-max="5" value="0" data-productid="<?php echo $product->get_id() ; ?>" data-min="1" name="rating" type="number" />
							<span class="the_loader"></span>
						<?php
						}
						?>
					
				</div>	
			<?php 
				}
			}
			?>
			<a href="<?php esc_url( the_permalink() ); ?>"><?php echo woocommerce_template_loop_product_thumbnail();?></a>
		</div>
		

		<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">', '.</span>' ); ?>
		
		<div class="kd_hp_item_title">
			<h2><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h2>
			<p><?php woocommerce_template_loop_price(); ?></p>
		</div>
		
			<?php //echo woocommerce_template_loop_add_to_cart(); ?>
		
		<?php	
		/**
		 * woocommerce_after_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		remove_action('woocommerce_template_loop_product_link_close', 'woocommerce_after_shop_loop_item', 5);
		do_action( 'woocommerce_after_shop_loop_item' );
		?>
	</div>

	<?php // do_action( 'woocommerce_before_shop_loop_item' ); 

		if( (is_product_taxonomy() || is_product_category() || is_shop() || (!is_front_page() && is_page())) && !is_product() || is_search() ) {
			if( $shop_template == 'alternate') {
				if( $row % 2 == 1 ) {
					if( $woocommerce_loop['loop'] % 3 != 1) {
						echo '</div>';
					}

					if( $woocommerce_loop['loop'] % 3 == 0) {
						echo '</div>';
					}
				}
				else {
					if( $woocommerce_loop['loop'] % 3 != 0) {
						echo '</div>';
					}

					if( $woocommerce_loop['loop'] % 3 == 2) {
						echo '</div>';
					}
				}
			}
		}
		

	?>

</div>

<?php

	if( (is_product_taxonomy() || is_product_category() || is_shop() || (!is_front_page() && is_page())) && !is_product() || is_search() ) {
		
		if( $shop_template == 'alternate') {


						
			if( $row % 2 == 1 ) {

				if( $woocommerce_loop['loop'] % 3 == 0 && $wp_query->found_posts != $woocommerce_loop['loop'] ) {
					echo '</div>';
				}
				if( $products_per_page % 3 != 0 || $wp_query->found_posts != 0 ) {

					if( $woocommerce_loop['loop'] == $products_per_page ||  ($wp_query->found_posts == $woocommerce_loop['loop'] && is_search()) ) {
						if( $woocommerce_loop['loop'] % 3 != 1 ) {

							echo '</div>';
						}
						if( $woocommerce_loop['loop'] % 3 == 2 ) {

							echo '</div>';
							echo '</div>';
						}
						//echo '</div>';
						if( $products_per_page != 1 ) {
							echo '</div>';
						}

					} else {
						if( $wp_query->found_posts == $woocommerce_loop['loop'] ) {
							
							if( $woocommerce_loop['loop'] % 3 == 2 ) {
								echo '</div>';
							}
							if( $woocommerce_loop['loop'] % 3 != 1 ) {

								echo '</div>';
							}
							if( $products_per_page != 1 && $wp_query->found_posts != $woocommerce_loop['loop'] ) {
								echo '</div>';
							}
							if( $woocommerce_loop['loop'] % 3 == 1 && is_product_taxonomy() ) {
								echo '</div>';
								echo '</div>';
								echo '</div>';
							} 

						}
					}
				}


			}
			else {

				if( $woocommerce_loop['loop'] == $products_per_page || ($wp_query->found_posts == $woocommerce_loop['loop'] && is_search())  ) {
					echo '</div>';
					
					if( $woocommerce_loop['loop'] % 3 == 1 ) {

						echo '</div>';
					}
				} 
				else {

					if( $woocommerce_loop['loop'] % 3 == 1 && $wp_query->found_posts == $woocommerce_loop['loop']  ) {

						echo '</div>';
						echo '</div>';
					}
					if( $woocommerce_loop['loop'] % 3 == 0  ) {

						echo '</div>';
					}
					if( $woocommerce_loop['loop'] % 3 == 2 &&  $wp_query->found_posts == $woocommerce_loop['loop']  ) {

						echo '</div>';
					}
				}
			}
			
		}
	}
