<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     5.0
 */

global $woocommerce, $kingdom, $wp_query, $woocommerce_loop;
$kingdom_core = kingdom()->coreFunctions;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

get_header( 'shop' ); 
$enable_top_filters_sidebar = get_theme_mod('enable_top_filters_sidebar', $kingdom_core->defaults_theme["enable_top_filters_sidebar"]);
$shop_template = get_theme_mod('shop_template', $kingdom_core->defaults_theme["shop_template"]);
$enable_bottom_filters_sidebar = get_theme_mod('enable_bottom_filters_sidebar', $kingdom_core->defaults_theme["enable_bottom_filters_sidebar"]);
?>
	<div class="container kd_product_list_grid <?php if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search()) { echo 'kd_shop_no_sidebar'; } ?>" id="kd_products_listitems">
		<div class="row">
			
			<?php if( $enable_top_filters_sidebar == 'YES' && is_active_sidebar('shop-top-filters') ) { ?>
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<div class="kd_shop_sidebar">
					<div class="kd_filter_by">
						<div class="kd_filter_by_header">
							<div class="kd_filter_display_wrapper">
								<div class="row">
									<div class="col-lg-8 col-md-8 col-sm-8 col-xs-6">
										<h4>refine by:</h4>
									</div>
									<div class="col-lg-4 col-md-4 col-sm-4 col-xs-6">
										<a href="#" id="kd_filter_display_as_grid_2column"><i class="micon icon-grid6"></i></a>
										<a href="#" id="kd_filter_display_as_grid_3column"><i class="micon icon-grid"></i></a>
										<a href="#" id="kd_filter_by_show" class="filters-visible"><?php esc_html_e('Filter', 'kingdom'); ?> <i class="fa fa-filter"></i></a>
									</div>		
								</div>
							</div>
						</div>
						
						<div class="kd_filters_list">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
									<!-- <h1 class="kd_refine_by_caption"><?php esc_html_e('refine by:', 'kingdom'); ?></h1> -->
									
									<div class="row">
										<?php dynamic_sidebar( 'shop-top-filters' ); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
			
			<?php
				$kingdom->coreFunctions->printSidebar( 'left' );
			?>
			
			<div class="<?php echo esc_attr( $kingdom->coreFunctions->content_class() );?>" id="products">
				
				<div class="row">
					
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 kd_dropdown">
						<div class="row">
							<div class="col-lg-8 col-md-12 col-sm-12 col-xs-12">
								<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>
								
								<?php
									wc_get_template( 'loop/result-count.php' );
								?>
							</div>
		          			
							<?php if( $wp_query->found_posts > 1 && woocommerce_products_will_display() ): ?>
							<!-- Sorting -->
							<?php
							$orderby = isset( $_GET['orderby'] ) ?  wc_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
							?>
							<div class="col-lg-4 col-md-12 col-sm-12 col-xs-12">
								<div class="kd_dropdown btn-group kd_custom_select kd_loop_orderby">
									<ul class="dropdown-menu" role="menu"></ul>
									<?php wc_get_template( 'loop/orderby.php', array( 'orderby' => $orderby ) ); ?>
								</div>
							</div>
							<?php endif; ?>
						</div>
						<div class="row">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 kd_archive_description">
							<?php
								/**
								 * woocommerce_archive_description hook.
								 *
								 * @hooked woocommerce_taxonomy_archive_description - 10
								 * @hooked woocommerce_product_archive_description - 10
								 */
								do_action( 'woocommerce_archive_description' );
							?>
							</div>
						</div>
					</div>
					
				</div>
				
				<?php
				/**
				 * woocommerce_before_main_content hook
				 *
				 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
				 * @hooked woocommerce_breadcrumb - 20
				 */
				do_action( 'woocommerce_before_main_content' );
				?>
				
					<div class="row">
						<div class="col-md-12 kd_archive_pg">
							<?php 
							if ( $shop_template == 'regular' && ( isset($kingdom->coreFunctions->data['page_sidebars']) && count($kingdom->coreFunctions->data['page_sidebars']) > 0 ) && !is_search() ) {
								echo '<div class="row">';
							}
							if ( have_posts() ) : ?>
					
								<?php
									/**
									 * woocommerce_before_shop_loop hook
									 *
									 * @hooked woocommerce_result_count - 20
									 * @hooked woocommerce_catalog_ordering - 30
									 */
									//do_action( 'woocommerce_before_shop_loop' );
									wc_print_notices();
									if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search()) {
										if ( $shop_template == 'regular') {
											echo '<div class="row">';
										}
									}
								?>
					
								<?php woocommerce_product_loop_start(); ?>
					
									<?php woocommerce_product_subcategories(); ?>
									<div class="clear"></div>
									<?php 
										$row = 0;

										
										while ( have_posts() ) {
											/*
											if ( $woocommerce_loop['loop'] % 3 == 0 ) {
												$row++;
											}*/
										 	the_post();
										
										?>
										
										<?php wc_get_template_part( 'content', 'product' ); ?>
					
									<?php  } // end of the loop. ?>
					
								<?php woocommerce_product_loop_end(); 
									if( !isset($kingdom->coreFunctions->data['page_sidebars']) || count($kingdom->coreFunctions->data['page_sidebars']) == 0 || is_search()) {
										if ( $shop_template == 'regular') {
											echo '</div>';
										}
									}
								?>
								<?php
									/**
									 * woocommerce_after_shop_loop hook
									 *
									 * @hooked woocommerce_pagination - 10
									 */
									do_action( 'woocommerce_after_shop_loop' );
								?>
					
							<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>
					
								<?php wc_get_template( 'loop/no-products-found.php' ); ?>
							<?php endif; 
								if ( $shop_template == 'regular' && ( isset($kingdom->coreFunctions->data['page_sidebars']) && count($kingdom->coreFunctions->data['page_sidebars']) > 0  && !is_search() ) ) {
										echo '</div>';
									}
									if( $shop_template == 'alternate' && $wp_query->found_posts == 0 && is_product_taxonomy() ) {
										echo '</div>';
										echo '</div>';
									}

							?>

						</div>
					</div>
					
				
				<?php
					/**
					 * woocommerce_after_main_content hook
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action( 'woocommerce_after_main_content' );
				?>
			</div>
			
			<?php
				$kingdom->coreFunctions->printSidebar( 'right' );
			?>
			
			<?php if( $enable_bottom_filters_sidebar == 'YES' && is_active_sidebar('shop-footer-filters') ) { ?>
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<div class="kd_shop_sidebar">
					<div class="kd_filter_by">
						<div class="kd_filter_by_header">
							<div class="kd_filter_display_wrapper">
								<div class="row">
									<div class="col-lg-8">
										<h4>refine by:</h4>
									</div>
									<div class="col-lg-4">
										<a href="#" id="kd_filter_display_as_grid_2column"><i class="micon icon-grid6"></i></a>
										<a href="#" id="kd_filter_display_as_grid_3column"><i class="micon icon-grid"></i></a>
										<a href="#" id="kd_filter_by_show" class="filters-visible"><?php esc_html_e('Filter', 'kingdom'); ?> <i class="fa fa-filter"></i></a>
									</div>		
								</div>
							</div>
						</div>
						
						<div class="kd_filters_list">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">		
									<div class="row">
										<?php dynamic_sidebar( 'shop-footer-filters' ); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
			
		</div>
	</div>
<?php get_footer( 'shop' ); ?>