<?php
/**
 * Config file, return as json_encode
 * http://www.aa-team.com
 * ======================
 *
 * @author		AA-Team
 * @version		1.0
 */
$kingdom = $GLOBALS['kingdom']; 

function kd_get_categs_level0()
{
	global $wpdb;
	$prefix = $wpdb->prefix;

	$sql = "select t.name, t.slug, t.term_id, tt.parent, tt.*
		from " . ( $prefix ) . "term_taxonomy AS tt
		inner join " . ( $prefix ) . "terms AS t ON tt.term_id = t.term_id
		where tt.taxonomy = 'product_cat'
		AND tt.parent=0
		order by t.term_id";

	$results = $wpdb->get_results( $sql, ARRAY_A );
	$terms = array();
	if( $results && count($results) > 0 ){
		foreach ( $results as $term ) {
			$terms[ $term['term_id'] ] = $term['name'];
		}
	}

	return $terms;
}

echo json_encode(
	array(
		'shop_by_brand' => array(
			'version' => '1.0',
			'title' => esc_html__('Shop By Brand ', 'kingdom'),
			'description' => esc_html__("Custom Shop By Brand Widget. Simply add images to your brands and showcase them anywhere!", 'kingdom'),
			'options' => array(
				'title' 	=> array(
					'title'		=> esc_html__('Title', 'kingdom'),
					'type' 		=> 'text',
					'width'		=> '100%',
					'std' 		=> esc_html__('Shop by Brand', 'kingdom')	
				),
				'select_order' 	=> array(
					'title'		=> esc_html__('Select Categories', 'kingdom'),
					'type' 		=> 'select_in_order',
					'width'		=> '100%',
					'options'	=> kd_get_categs_level0()
				),
			)
		)
	)
);