<?php  
/**
 * @package WordPress
 * @subpackage:
 *	Name: 	Kingdom Amazon Affiliate Theme
 *	Alias: 	kingdom
 *	Author: AA-Team
 *	Name: 	http://themeforest.net/user/AA-Team/portfolio
 *  Template Name: Template Blog
 *	
**/
get_header();
global $tag, $cat; 
$kingdom_core = kingdom()->coreFunctions;
?>
	<div class="container">
		<div class="row">
			<?php kingdom()->coreFunctions->printSidebar( 'left' ); ?>
			
			<!-- Main Container -->
			<section class="<?php echo esc_attr( kingdom()->coreFunctions->content_class() );?>">
				<?php
				$args = array(
					'post_type' => 'post',
					'paged' => $paged,
				);
				
				if( isset($tag) && trim($tag) != "" ){
					$args['tag'] = $tag;
				}
				if( isset($cat) && trim($cat) != "" ){
					$args['cat'] = $cat;
				}
				
				$the_query = new WP_Query( $args );
				?>
				<?php if ( $the_query->have_posts() ) : ?>
				
				<div class="blog-box">
					<?php while( $the_query->have_posts() ) : $the_query->the_post(); ?>
					
					<div class="kd_simple_post">
						
						<?php
						if( has_post_thumbnail() ) {
						?>
							<div class="kd_simple_post_image kd_hovereffect">
								<a href="<?php echo esc_url( get_the_permalink() ); ?>">
									<?php echo get_the_post_thumbnail( $post->ID, 'kingdom_blog-featured-image' ); ?>
									<div class="mask">
									 	<div class="kd_bk_icon">
											<i class="micon icon-plus3"></i>
										</div>
									</div>
								</a>
							</div>
						<?php } ?>
						
						<div class="kd_simple_post_description <?php echo has_post_thumbnail() == false ? 'full' : '';?> ">
							<h2><a href="<?php echo esc_url( get_the_permalink() ); ?>"><?php the_title(); ?></a></h2>
							<input class="rating" data-max="5" data-min="1" name="rating" type="number" value="" />
							<?php 
								$show_post_date_meta	 = get_theme_mod('show_post_date_meta', $kingdom_core->defaults_theme["show_post_date_meta"]); 
								$show_post_category_meta = get_theme_mod('show_post_category_meta', $kingdom_core->defaults_theme["show_post_category_meta"]); 
								$show_post_comments_meta = get_theme_mod('show_post_comments_meta', $kingdom_core->defaults_theme["show_post_comments_meta"]); 
							?>
							<p class="kd_posts_post_meta" <?php if( $show_post_date_meta == 'NO' && $show_post_category_meta == 'NO' && $show_post_comments_meta == 'NO' ) { echo ' style="display: none;" '; } ?> >
								<span>
									<?php if( $show_post_date_meta == 'YES' ) { ?>
										<i class="micon icon-calendar"></i> <?php echo get_the_date(); ?> 
									<?php } ?>
									<?php if( $show_post_comments_meta == 'YES' ) { ?>
										<i class="micon icon-bubble9"></i> <?php comments_number(); ?> 
									<?php } ?>
									<?php if( $show_post_category_meta == 'YES' ) { ?>
										<i class="micon icon-file-text2"></i> <?php the_category(', ', 'multiple'); ?>
									<?php } ?>
								</span>
							</p>
							<div class="kd_blog_short_desc"><?php the_excerpt(); ?></div>
							<a href="<?php echo esc_url( get_the_permalink() ); ?>" class="kd_read_more"> <?php esc_html_e('Read More', 'kingdom'); ?></a>
						</div>
					</div>
					
					<div class="clearfix"></div>
					<hr class="kd_line"/>
					<?php endwhile; ?>
				</div>
			
				<div class="clearfix"></div>

				<?php if( $wp_query->post_count < $wp_query->found_posts ) { ?>
				<div class="row-fluid">
					<!-- Pagination -->
					<div class="pagination-container">
						<div class="pagination-left">
							<?php previous_posts_link( '<i class="first-arrow"></i>' . __('Newer', 'kingdom' ) ); ?>
						</div>
						<div class="pagination-right">
							<?php next_posts_link( '<i class="last-arrow"></i>' . __('Older', 'kingdom' ) ); ?>
						</div>
					</div>
				</div>
				<?php } ?>
				
				<?php wp_reset_query(); ?>
				<?php else : ?>
					<?php get_template_part( 'template', 'none' ); ?>
				<?php endif; ?>
			</section>
			
			<?php kingdom()->coreFunctions->printSidebar( 'right' ); ?>
		</div>
	</div>

<?php get_footer(); ?>