<?php 
/**
 * @package WordPress
 * @subpackage:
 *	Name: 	Kingdom Amazon Affiliate Theme
 *	Alias: 	kingdom
 *	Author: AA-Team
 *	Name: 	http://themeforest.net/user/AA-Team/portfolio
 *	
**/

get_header();
$kingdom_core = kingdom()->coreFunctions;
?>
   	<div class="container">
		<div class="row">
			<?php
				kingdom()->coreFunctions->printSidebar( 'left' ); 
			?>
			<!-- Main Container -->
			<section id="post-<?php the_ID(); ?>" class="<?php echo esc_attr( kingdom()->coreFunctions->content_class() );?>">
				<?php if( have_posts() ) : while( have_posts() ) : the_post();?>
				<div class="kd_featured_post kd_post_details">
					
					<?php if( has_post_thumbnail() ) :
						$thumb_id = get_post_thumbnail_id( $post->ID ); 
						$image = wp_get_attachment_image_src( $thumb_id, 'full' );
					?>
					
					<div class="kd_hovereffect">
						<a href="<?php echo esc_url($image[0]);?>" class="prettyPhoto" title="Image" >
							<?php echo wp_get_attachment_image( $thumb_id, 'kingdom_blog-featured-image' );?>
							<div class="mask">
						 		<div class="kd_bk_icon">
									<i class="micon icon-plus3"></i>
								</div>
							</div>
						</a>
					</div>
					
					<?php endif; ?>
					
					<div class="kd_product_rating_pagination">
						<input class="rating" data-max="5" data-min="1" name="rating" type="number" value="" />
						<ul class="kd_pager">
							<li><?php previous_post_link('%link', 'Previous'); ?></li>
							<li><?php next_post_link('%link', ' / Next'); ?></li>
						</ul>
					</div>
					
					<div class="clearfix"></div>
					
					<h1><?php the_title(); ?></h1>
					<?php 
						$show_post_date_meta	 = get_theme_mod('show_post_date_meta', $kingdom_core->defaults_theme["show_post_date_meta"]); 
						$show_post_category_meta = get_theme_mod('show_post_category_meta', $kingdom_core->defaults_theme["show_post_category_meta"]); 
						$show_post_comments_meta = get_theme_mod('show_post_comments_meta', $kingdom_core->defaults_theme["show_post_comments_meta"]); 
					?>
					<p class="kd_single_post_meta" <?php if( $show_post_date_meta == 'NO' && $show_post_category_meta == 'NO' && $show_post_comments_meta == 'NO' ) { echo ' style="display: none;" '; } ?> >
						<span>
							<?php if( $show_post_date_meta == 'YES' ) { ?>
								<i class="micon icon-calendar"></i> <?php echo get_the_date(); ?> 
							<?php } ?>
							<?php if( $show_post_comments_meta == 'YES' ) { ?>
								<i class="micon icon-bubble9"></i> <?php comments_number(); ?> 
							<?php } ?>
							<?php if( $show_post_category_meta == 'YES' ) { ?>
								<i class="micon icon-file-text2"></i> <?php the_category(', ', 'multiple'); ?>
							<?php } ?>
						</span>
					</p>
					
					<div class="post-entry">
						<?php the_content(); ?>
					</div>
					<?php wp_link_pages(); ?>
					
					<div class="kd_social_tags">
						 <div class="kd_social_share">
						 	<?php 
						 		kingdom()->coreFunctions->print_share_buttons( $post->ID, $post->post_title );
						 	?>
						</div>

						<div class="kd_tags">
							<?php the_tags(); ?>
						</div>
					</div>
				</div>
				
				<?php comments_template(); ?>

				<?php endwhile; endif; ?>
				
			</section>
			
			<?php
				kingdom()->coreFunctions->printSidebar( 'right' );
			?>
  		</div>
  	</div>
    <!-- end of content -->

<?php get_footer(); ?>
