<?php 
/**
 * @package WordPress
 * @subpackage:
 *	Name: 	Kingdom Amazon Affiliate Theme
 *	Alias: 	kingdom
 *	Author: AA-Team
 *	Name: 	http://themeforest.net/user/AA-Team/portfolio
 *	
**/
get_header();

global $wp_query; 
?>

<!-- Main Gray Content Background -->
<div class="gray-content-background">
	<div class="container">
		<div class="row-fluid">
		
			<?php 
				if( isset(kingdom()->coreFunctions->data['sidebar']['position']) && kingdom()->coreFunctions->data['sidebar']['position'] == 'left' ){
					load_template( kingdom()->cfg['paths']['theme_dir_path'] . '/sidebar.php', true );
				}
			?>
			
			<!-- Main Container -->
			<section class="<?php echo esc_attr( (isset(kingdom()->coreFunctions->data['sidebar']['position']) && kingdom()->coreFunctions->data['sidebar']['position'] == 'nosidebar' ? 'span16' : 'span12') ); ?>">
				<div class="main-content-box">
					<div class="extra-container-box">
						<div class="row-fluid">
							<div class="span16">
								<h1><?php esc_html_e('Search results:', 'kingdom'); ?></h1>
								<?php if( have_posts() ){ ?>
								<ul class="search-results">
									<?php 
									$last_post_type = '';
									while ( have_posts() ) : the_post(); 
										if( in_array( $post->post_type, array('testimonials', 'slideshow', 'partners')) ) continue;
									
										if( $post->post_type != $last_post_type ){
											$post_type_obj = get_post_type_object( $post->post_type ); 
									?>
											<h2><?php echo $post_type_obj->labels->name;?> <?php esc_html_e('results:', 'kingdom'); ?></h2>
									<?php		
										}
									?>
										<li class="post_type-<?php echo esc_attr( $post->post_type );?>">
												<div class="row-fluid">
													
													<?php 
													if(has_post_thumbnail()){
														$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail'); 
													?>
														<div class="span2">
															<a href="<?php echo esc_url( get_the_permalink() ); ?>"><img src="<?php echo esc_url($thumb[0]); ?>" alt="<?php echo the_title(); ?>"></a>
														</div>
													<?php } ?>
													<div class="span<?php echo esc_attr( (has_post_thumbnail() ? '14' : '16') );?>">
														<h4 class="test-overflow"><a href="<?php echo esc_url( get_the_permalink() ); ?>"><?php the_title(); ?></a></h4>
														<?php if( isset( $post->post_excerpt ) && $post->post_excerpt != '' ) { ?>
															<p><?php echo wp_trim_words( $post->post_excerpt, 60); ?></p>
														<?php } else { ?>
															<p><?php echo wp_trim_words( $post->post_content, 60); ?></p>
														<?php } ?>
													</div>	
												</div>
										</li>
									<?php 
										$last_post_type = $post->post_type;
									endwhile; ?>
								</ul>
								<?php }else{
									?>
									<p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with different keywords.', 'kingdom'); ?></p>
								<?php
								} ?>
							</div>
						</div>
					</div>
			</section>
					
				<?php 
				if( isset(kingdom()->coreFunctions->data['sidebar']['position']) && kingdom()->coreFunctions->data['sidebar']['position'] == 'right' ){
					load_template( kingdom()->cfg['paths']['theme_dir_path'] . '/sidebar.php', true );
				}
				?>
				</div>
		</div>
	</div>
</div>
<!-- end of content -->

<?php get_footer(); ?>
