<?php
class Menu_Item_Custom_Fields_Example {

	/**
	 * Holds our custom fields
	 *
	 * @var    array
	 * @access protected
	 * @since  Menu_Item_Custom_Fields_Example 0.2.0
	 */
	protected static $fields = array();


	/**
	 * Initialize plugin
	 */
	public static function init() {
		add_action( 'wp_nav_menu_item_custom_fields', array( __CLASS__, '_fields' ), 10, 4 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, '_save' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, '_columns' ), 99 );

		self::$fields = array(
			'menu-icon' => array(
				'label' => __( 'Menu Item Icon', 'kingdom' ),
				'type' => 'icon'
			),
			'menu-image' => array(
				'label' => __( 'Menu Item background Image', 'kingdom' ),
				'type' => 'image'
			)
		);
	}


	/**
	 * Save custom field value
	 *
	 * @wp_hook action wp_update_nav_menu_item
	 *
	 * @param int   $menu_id         Nav menu ID
	 * @param int   $menu_item_db_id Menu item ID
	 * @param array $menu_item_args  Menu item data
	 */
	public static function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}
		
		//check_admin_referer( 'update-nav_menu', 'update-nav-menu-nonce' );

		foreach ( self::$fields as $_key => $label ) {
			$key = sprintf( 'menu-item-%s', $_key );

			// Sanitize
			if ( ! empty( $_POST[ $key ][ $menu_item_db_id ] ) ) {
				// Do some checks here...
				$value = $_POST[ $key ][ $menu_item_db_id ];
			}
			else {
				$value = null;
			}

			// Update
			if ( ! is_null( $value ) ) {
				update_post_meta( $menu_item_db_id, $key, $value );
			}
			else {
				delete_post_meta( $menu_item_db_id, $key );
			}
		}
	}


	/**
	 * Print field
	 *
	 * @param object $item  Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args  Menu item args.
	 * @param int    $id    Nav menu ID.
	 *
	 * @return string Form fields
	 */
	public static function _fields( $id, $item, $depth, $args ) {
		foreach ( self::$fields as $_key => $elm ) :
			$key   = sprintf( 'menu-item-%s', $_key );
			$id    = sprintf( 'edit-%s-%s', $key, $item->ID );
			$name  = sprintf( '%s[%s]', $key, $item->ID );
			$value = get_post_meta( $item->ID, $key, true );
			//var_dump('<pre>',$value, $key, $item->ID,'</pre>'); die;  
			$class = sprintf( 'field-%s', $_key );
			?>
				<p class="description description-wide <?php echo esc_attr( $class ) ?>">
					<?php 
					
					if( $elm['type'] == 'icon' ){ 
						printf(
							'<label for="%1$s">%2$s<br />
								<div class="input-group" style="float: left;">
		                            <input placeholder="Click to choose an icon..." id="%1$s" name="%3$s" data-placement="bottomRight" class="form-control icp icp-auto" value="%4$s" type="text" />
		                            <span class="input-group-addon" style="background: #f96332; color: #fff;font-size: 15px; margin-left: -6px; position:relative; top:1px; padding: 3px 8px;"></span>
		                        </div>
	                        </label>',
							esc_attr( $id ),
							esc_html( $elm['label'] ),
							esc_attr( $name ),
							esc_attr( $value )
						);
					}

					if( $elm['type'] == 'image' ){ 

						$thumb = wp_get_attachment_image_src( $value, 'thumbnail' );
						if( $thumb == false ){
							$thumb = '';
						}else{
							$thumb = '<img src="' . $thumb[0] . '" />';
						}
						printf(
							'<label for="%1$s">%2$s<br />
								<div class="input-group kd_nav_upload_image_container" style="float: left;">
		                            <input placeholder="Click to choose an image..." id="%1$s" name="%3$s" data-placement="bottomRight" class="form-control kd_image_upload" value="%4$s" type="text" />
		                            <div class="kd_nav_img_preview">%5$s</div>

		                            ' . ( trim($thumb) != "" ? '<span class="kd_nav_change_img kingdom-new-button green">Change Image</span><span class="kd_nav_remove_img kingdom-new-button red">Remove Image</span>' : '<span class="kd_nav_change_img kingdom-new-button orange">Add Image</span>' ) . '
		                            
		                        </div>
	                        </label>',
							esc_attr( $id ),
							esc_html( $elm['label'] ),
							esc_attr( $name ),
							esc_attr( $value ),
							$thumb
						);
					}

					?>
				</p>
			<?php
		endforeach;
	}


	/**
	 * Add our fields to the screen options toggle
	 *
	 * @param array $columns Menu item columns
	 * @return array
	 */
	public static function _columns( $columns ) {
		$columns = array_merge( $columns, self::$fields );

		return $columns;
	}
}
Menu_Item_Custom_Fields_Example::init();