<?php
if ( !defined('ABSPATH') ) {
	$absolute_path = __FILE__;
	$path_to_file = explode( 'wp-content', $absolute_path );
	$path_to_wp = $path_to_file[0];

	/** Set up WordPress environment */
	if( file_exists( $path_to_wp.'/wp-load.php' ) ) {
		require_once( $path_to_wp.'/wp-load.php' );
	}else{
		require_once( '../../../wp-load.php' );
	}
	
	$kingdom_core = kingdom()->coreFunctions;
	
	kingdom()->coreFunctions->update_settings();
	
	$cssFiles = array( kingdom()->cfg['paths']['theme_dir_path'] . 'style.css' );
	if( file_exists( get_template_directory() . '-child/style.css' ) ) {
		$cssFiles[] = get_template_directory() . '-child/style.css';
	}
	
	$buffer = "";
	foreach ($cssFiles as $cssFile) {
		$buffer .= $kingdom->wp_filesystem->get_contents($cssFile);
	}
	
	$primary = get_theme_mod( 'primary', $kingdom_core->defaults_theme['primary'] );
	$secondary = get_theme_mod( 'secondary', $kingdom_core->defaults_theme['secondary'] );
	$menu_background = get_theme_mod( 'menu_background', $kingdom_core->defaults_theme['menu_background'] );
	$menu_normal_state = get_theme_mod( 'menu_normal_state', $kingdom_core->defaults_theme['menu_normal_state'] );
	$menu_hover_state = get_theme_mod( 'menu_hover_state', $kingdom_core->defaults_theme['menu_hover_state'] );
	$font_main = get_theme_mod( 'font_main', $kingdom_core->defaults_theme['font_main'] );
	$font_headings = get_theme_mod( 'font_headings', $kingdom_core->defaults_theme['font_headings'] );
	$main_menu_font = get_theme_mod( 'main_menu_font', $kingdom_core->defaults_theme['main_menu_font'] );
	$main_menu_font_size = get_theme_mod( 'main_menu_font_size', $kingdom_core->defaults_theme['main_menu_font_size'] );
	$main_menu_font_weight = get_theme_mod( 'main_menu_font_weight', $kingdom_core->defaults_theme['main_menu_font_weight'] );
	$main_menu_submenu_font_size = get_theme_mod( 'main_menu_submenu_font_size', $kingdom_core->defaults_theme['main_menu_submenu_font_size'] );
	$main_menu_submenu_font_weight = get_theme_mod( 'main_menu_submenu_font_weight', $kingdom_core->defaults_theme['main_menu_submenu_font_weight'] );
	$main_menu_vertical_spacing = get_theme_mod( 'main_menu_vertical_spacing', $kingdom_core->defaults_theme['main_menu_vertical_spacing'] );
	$main_menu_horizontal_spacing = get_theme_mod( 'main_menu_horizontal_spacing', $kingdom_core->defaults_theme['main_menu_horizontal_spacing'] );
	$main_menu_submenu_top_margin = get_theme_mod( 'main_menu_submenu_top_margin', $kingdom_core->defaults_theme['main_menu_submenu_top_margin'] );
	$main_content_font_size = get_theme_mod( 'main_content_font_size', $kingdom_core->defaults_theme['main_content_font_size']  );
	$main_content_font_weight= get_theme_mod( 'main_content_font_weight', $kingdom_core->defaults_theme['main_content_font_weight'] );
	$h1_font_size = get_theme_mod( 'h1_font_size', $kingdom_core->defaults_theme['h1_font_size'] );
	$h1_font_weight = get_theme_mod( 'h1_font_weight', $kingdom_core->defaults_theme['h1_font_weight'] );
	$h2_font_size = get_theme_mod( 'h2_font_size', $kingdom_core->defaults_theme['h2_font_size'] );
	$h2_font_weight = get_theme_mod( 'h2_font_weight', $kingdom_core->defaults_theme['h2_font_weight'] );
	$h3_font_size = get_theme_mod( 'h3_font_size', $kingdom_core->defaults_theme['h3_font_size'] );
	$h3_font_weight = get_theme_mod( 'h3_font_weight', $kingdom_core->defaults_theme['h3_font_weight'] );
	$h4_font_size = get_theme_mod( 'h4_font_size', $kingdom_core->defaults_theme['h4_font_size'] );
	$h4_font_weight = get_theme_mod( 'h4_font_weight', $kingdom_core->defaults_theme['h4_font_weight'] );
	$h5_font_size = get_theme_mod( 'h5_font_size', $kingdom_core->defaults_theme['h5_font_size'] );
	$h5_font_weight = get_theme_mod( 'h5_font_weight', $kingdom_core->defaults_theme['h5_font_weight'] );
	$h6_font_size = get_theme_mod( 'h6_font_size', $kingdom_core->defaults_theme['h6_font_size'] );
	$h6_font_weight = get_theme_mod( 'h6_font_weight', $kingdom_core->defaults_theme['h6_font_weight'] );
	$show_star_rating = get_theme_mod( 'show_star_rating', $kingdom_core->defaults_theme['show_star_rating'] );
	$show_footer_partners = get_theme_mod( 'show_footer_partners', $kingdom_core->defaults_theme['show_footer_partners'] );
	$enable_product_general_description = get_theme_mod( 'enable_product_general_description', $kingdom_core->defaults_theme['enable_product_general_description'] );
	
	if( $primary != '#C73030' ){
		$buffer = str_replace( array( strtolower($primary), "#C73030" ), strtoupper($primary), $buffer);
		$buffer = str_replace( array( strtolower($primary), "#C73030" ), strtoupper($primary), $buffer);
		$buffer = str_replace( array( strtolower("#A21312"), "#A21312" ), kingdom()->coreFunctions->adjustBrightness( strtoupper($primary), -30 ), $buffer);
	}
	
	if( $secondary != strtolower('#781B80') ){
		$buffer = str_replace( array( strtolower("#781B80"),"#781B80" ) , strtoupper(get_theme_mod( $secondary )), $buffer);
		$buffer = str_replace( array( strtolower("#196EA6"), "#196EA6" ), kingdom()->coreFunctions->adjustBrightness( strtoupper($secondary)), -30 ), $buffer);
	}
	
	if( $primary && 0 ){
		$buffer .= 'body .kd_hp_item_title p ins, html body .kd_hp_item_title p, .home .woocommerce .owl-buttons .owl-prev:hover, .home .woocommerce .owl-buttons .owl-next:hover, .owl-set .woocommerce .owl-buttons .owl-prev:hover, .owl-set .woocommerce .owl-buttons .owl-next:hover, #kd_footer_partners .owl-buttons .owl-prev:hover, #kd_footer_partners .owl-buttons .owl-next:hover, .kd_footer_smallmenu p a, .kd_social_share a , .kd_breadcrumbs_bk .breadcrumb > li  a, .kd_product_rating_pagination .kd_pager li a:hover, ul.product_list_widget span.amount, .woocommerce ul.product_list_widget span.amount, html body .cross-sell .cross-sell-buy-selectable .cross-sell-item-price, html body .cross-sell .cross-sell-buy-selectable a:hover, ul.product_list_widget li a:hover, .woocommerce ul.product_list_widget li a:hover, ul.product_list_widget li a:hover .product_list_widget_img_wrapper, .kingdom-widget ul li a:hover, .kd_small-cart .cart-details .kd_small_cart_items li .kd_cart_item-details p .kd_price, .kd_cart_total span, .kd_small-cart .cart-details .kd_small_cart_items li .kd_cart_item-details .kd_cart_item-close-btn:hover, a:hover { color: '.$secondary.';}';
		$buffer .= '.kingdom-widget #searchform input[type="submit"], .kingdom-widget .searchform input[type="submit"], .btn_addcart:hover, body  #cross-sell-add-to-cart, .btn_checkout { background-color: '.$menu_background.';}';
		$buffer .= 'body  #cross-sell-add-to-cart, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-range { background: '.$menu_background.'; color: '.$primary.';}}';
		$buffer .= '.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle { border: 2px solid '.$primary.';}';
		
	}
	
	
	if( $menu_normal_state ){
		$buffer .= 'body .navigationbar .kd_main_menu li a { color: '.$menu_normal_state.';}';
		$buffer .= 'body .navigationbar .kd_main_menu .sub-menu { box-shadow: 0 3px 0 0 '.$menu_normal_state.' inset; }';
	}
	
	if( $menu_hover_state ){
		$buffer .= 'body .navigationbar .kd_main_menu li a:hover, body .navigationbar .kd_main_menu > li.current-menu-item a { color: '.$menu_hover_state.';}';
	}
	
	if( $menu_background ){
		$buffer .= 'body .navigationbar { background-color: '.$menu_background.';}';
		$buffer .= '.navigationbar .kd_main_menu .sub-menu { background-color: '.$menu_background.';}';
		$buffer .= 'body .mean-container .mean-bar { background-color: '.$menu_background.';}';
		$buffer .= '.mean-container .mean-bar { background-color: '.$menu_background.';}';
		$buffer .= 'body .mean-container .mean-nav { background-color: '.$menu_background.';}';
		$buffer .= '.mean-container .mean-nav { background-color: '.$menu_background.';}';
	}
	
	// custom fonts
	if( $font_main ){
		$buffer = str_replace( "Open Sans", $font_main, $buffer );
	}
	
	if( $font_headings ){
		$buffer .= 'body .row h1, body .row h2, body .row h3, body .row h4, body .row h5, body .row h6 { font-family: '.$font_headings.' !important;}';
	}
	
	if( $main_menu_font ){
		$buffer .= 'body .navigationbar .kd_main_menu li a { font-family: '.$main_menu_font.' !important;}';
	}
	
	if( $main_menu_font_size ){
		$buffer .= 'body .navigationbar .kd_main_menu li a { font-size: '.$main_menu_font_size.' !important;}';
	}

	if( $main_menu_font_weight ){
		$buffer .= 'body .navigationbar .kd_main_menu li a { font-wieght: '.$main_menu_font_weight.' !important;}';
	}
	
	if( $main_menu_submenu_font_size ){
		$buffer .= 'body .navigationbar .kd_main_menu li ul li a { font-size: '.$main_menu_submenu_font_size.' !important;}';
	}
	
	if( $main_menu_submenu_font_weight ){
		$buffer .= 'body .navigationbar .kd_main_menu li ul li a { font-weight: '.$main_menu_submenu_font_weight.' !important;}';
	}
	
	if( $main_menu_vertical_spacing ){
		$buffer .= 'body .navigationbar .kd_main_menu > li a { padding-bottom: '.$main_menu_vertical_spacing.'; padding-top: '.$main_menu_vertical_spacing.';}';
	}
	
	if( $main_menu_horizontal_spacing ){
		$buffer .= 'body .navigationbar .kd_main_menu > li a { padding-left: '.$main_menu_horizontal_spacing.'; padding-right: '.$main_menu_horizontal_spacing.';}';
	}
	
	if( $main_menu_submenu_top_margin ){
		$buffer .= 'body .navigationbar .kd_main_menu .sub-menu { top: '.$main_menu_submenu_top_margin.';}';
	}
	
	if( $main_content_font_size ){
		$buffer .= 'body .row p { font-size: '.$main_content_font_size.' !important;}';
	}
	
	if( $main_content_font_weight ){
		$buffer .= 'body .row p { font-weight: '.$main_content_font_weight.' !important;}';
	}
	
	if( $h1_font_size ){
		$buffer .= 'body .row h1 { font-size: '.$h1_font_size.' !important;}';
	}
	
	if( $h1_font_weight ){
		$buffer .= 'body .row h1 { font-weight: '.$h1_font_weight.' !important;}';
	}
	
	if( $h2_font_size ){
		$buffer .= 'body .row h2 { font-size: '.$h2_font_size.' !important;}';
	}
	
	if( $h2_font_weight ){
		$buffer .= 'body .row h2 { font-weight: '. $h2_font_weight .' !important;}';
	}
	
	if( $h3_font_size ){
		$buffer .= 'body .row h3 { font-size: '.$h3_font_size.' !important;}';
	}
	
	if( $h3_font_weight ){
		$buffer .= 'body .row h3 { font-weight: '.$h3_font_weight.' !important;}';
	}
	
	if( $h4_font_size ){
		$buffer .= 'body .row h4 { font-size: '.$h4_font_size.' !important;}';
	}

	if( $h4_font_weight ){
		$buffer .= 'body .row h4 { font-weight: '.$h4_font_weight.' !important;}';
	}
	
	if( $h5_font_size ){
		$buffer .= 'body .row h5 { font-size: '.$h5_font_size.' !important;}';
	}
	
	if( $h5_font_weight ){
		$buffer .= 'body .row h5 { font-weight: '.$h5_font_weight.' !important;}';
	}
	
	if( $h6_font_size ){
		$buffer .= 'body .row h6 { font-size: '.$h6_font_size.' !important;}';
	}
	
	if( $h6_font_weight ){
		$buffer .= 'body .row h6 { font-weight: '.$h6_font_weight.' !important;}';
	}
	
	if( $show_star_rating == 'NO' ){
		$buffer .= 'body .rating-input { display: none !important;}';
	}
	
	if( $show_footer_partners == 'NO' ){
		$buffer .= 'body #kd_footer_partners { display: none !important;}';
	}

	if( $enable_product_general_description == 'NO' ){
		$buffer .= 'body #kd_general_description { display: none !important;}';
	}
	
	// end 
	
	// Remove comments
	$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
	 
	// Remove space after colons
	$buffer = str_replace(': ', ':', $buffer);
	 
	// Remove whitespace
	$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '    ', '    '), '', $buffer);
	 
	// Enable GZip encoding.
	if ( ! ini_get('zlib.output_compression') || 'ob_gzhandler' != ini_get('output_handler') ) ob_start();
	else ob_start("ob_gzhandler");
	 
	// Enable caching
	header('Cache-Control: public');
	 
	// Expire in one day
	header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
	 
	// Set the correct MIME type, because Apache won't set it for us
	header("Content-type: text/css");
	 
	// Write everything out
	echo $buffer;  
	
	// try to write the buffer as .css
	if( !is_file( get_template_directory() . '/load-style.css' ) ){
		$kingdom->wp_filesystem->put_contents( get_template_directory() . '/load-style.css', $buffer );
	}
}